/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexPackageImpl
extends PsiPackageBase
implements NavigationItem,
JSQualifiedNamedElement {
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;

    public FlexPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    protected PsiElement findPackage(String qName) {
        return this.createInstance(this.getManager(), qName);
    }

    protected FlexPackageImpl createInstance(PsiManager manager, String qName) {
        return new FlexPackageImpl(manager, qName);
    }

    protected Collection<PsiDirectory> getAllDirectories(boolean includeLibrarySources) {
        if (this.myDirectories == null) {
            CachedValueProvider provider = () -> {
                PsiManager manager = PsiManager.getInstance((Project)this.getProject());
                List directories = ContainerUtil.map((Collection)DirectoryIndex.getInstance((Project)this.getProject()).getDirectoriesByPackageName(this.getQualifiedName(), true).findAll(), virtualFile -> manager.findDirectory(virtualFile));
                return CachedValueProvider.Result.create((Object)directories, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)this.getProject())});
            };
            this.myDirectories = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(provider, false);
        }
        return (Collection)this.myDirectories.getValue();
    }

    public boolean isValid() {
        return this.getDirectories().length > 0;
    }

    @NotNull
    public Language getLanguage() {
        Language language = StdFileTypes.JS.getLanguage();
        if (language == null) {
            FlexPackageImpl.$$$reportNull$$$0(0);
        }
        return language;
    }

    public String toString() {
        return "Package:" + this.getQualifiedName();
    }

    public void navigate(boolean requestFocus) {
    }

    public ASTNode findNameIdentifier() {
        return null;
    }

    public PsiElement getNameIdentifier() {
        return null;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            FlexPackageImpl.$$$reportNull$$$0(1);
        }
        return jSContext;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        return JSPsiImplUtils.buildNamespaceFromQualifiedName((JSQualifiedNamedElement)this);
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            FlexPackageImpl.$$$reportNull$$$0(2);
        }
        return accessType;
    }

    public boolean isDeprecated() {
        return false;
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
        if (classOrInterface == null) {
            FlexPackageImpl.$$$reportNull$$$0(3);
        }
        return classOrInterface;
    }

    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespaceImpl jSNamespaceImpl = new JSNamespaceImpl(this.getNamespace(), this.getJSContext(), this.isNamespaceExplicitlyDeclared());
        if (jSNamespaceImpl == null) {
            FlexPackageImpl.$$$reportNull$$$0(4);
        }
        return jSNamespaceImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javascript/flex/refactoring/FlexPackageImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class DescriptionProvider
    implements ElementDescriptionProvider {
        @Nullable
        public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
            if (element == null) {
                DescriptionProvider.$$$reportNull$$$0(0);
            }
            if (location == null) {
                DescriptionProvider.$$$reportNull$$$0(1);
            }
            if (!(element instanceof FlexPackageImpl)) {
                return null;
            }
            if (location instanceof UsageViewLongNameLocation) {
                return JSBundle.message((String)"package.description", (Object[])new Object[]{((FlexPackageImpl)element).getQualifiedName()});
            }
            if (location instanceof UsageViewShortNameLocation) {
                return StringUtil.notNullize((String)((FlexPackageImpl)element).getName());
            }
            if (location instanceof UsageViewTypeLocation) {
                return JSBundle.message((String)"javascript.language.term.package", (Object[])new Object[0]);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "location";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/flex/refactoring/FlexPackageImpl$DescriptionProvider";
            objectArray[2] = "getElementDescription";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

