/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.javascript.flex.css.FlexInputFilter;
import com.intellij.javascript.flex.css.FlexStyleIndexInfo;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexStyleIndex
extends FileBasedIndexExtension<String, Set<FlexStyleIndexInfo>> {
    public static final ID<String, Set<FlexStyleIndexInfo>> INDEX_ID = ID.create((String)"js.style.index");
    private static final int VERSION = 18;
    private final DataExternalizer<Set<FlexStyleIndexInfo>> myDataExternalizer = new DataExternalizer<Set<FlexStyleIndexInfo>>(){

        public void save(@NotNull DataOutput out, Set<FlexStyleIndexInfo> value) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
            for (FlexStyleIndexInfo info : value) {
                FlexStyleIndex.writeUTF(out, info.getClassOrFileName());
                FlexStyleIndex.writeUTF(out, info.getAttributeName());
                FlexStyleIndex.writeUTF(out, info.getInherit());
                FlexStyleIndex.writeUTF(out, info.getType());
                FlexStyleIndex.writeUTF(out, info.getArrayType());
                FlexStyleIndex.writeUTF(out, info.getFormat());
                FlexStyleIndex.writeUTF(out, info.getEnumeration());
                out.writeBoolean(info.isInClass());
            }
        }

        public Set<FlexStyleIndexInfo> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            int size = DataInputOutputUtil.readINT((DataInput)in);
            LinkedHashSet result = ContainerUtil.newLinkedHashSet();
            for (int i = 0; i < size; ++i) {
                String className = FlexStyleIndex.readUTF(in);
                assert (className != null);
                String attributeName = FlexStyleIndex.readUTF(in);
                assert (attributeName != null);
                String inherit = FlexStyleIndex.readUTF(in);
                assert (inherit != null);
                String type = FlexStyleIndex.readUTF(in);
                String arrayType = FlexStyleIndex.readUTF(in);
                String format = FlexStyleIndex.readUTF(in);
                String enumeration = FlexStyleIndex.readUTF(in);
                boolean inClass = in.readBoolean();
                result.add(new FlexStyleIndexInfo(className, attributeName, inherit, type, arrayType, format, enumeration, inClass));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/flex/css/FlexStyleIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<String, Set<FlexStyleIndexInfo>> getName() {
        ID<String, Set<FlexStyleIndexInfo>> iD = INDEX_ID;
        if (iD == null) {
            FlexStyleIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Nullable
    private static String readUTF(@NotNull DataInput in) throws IOException {
        String s;
        if (in == null) {
            FlexStyleIndex.$$$reportNull$$$0(1);
        }
        return (s = IOUtil.readUTF((DataInput)in)).length() == 0 ? null : s;
    }

    private static void writeUTF(@NotNull DataOutput out, @Nullable String s) throws IOException {
        if (out == null) {
            FlexStyleIndex.$$$reportNull$$$0(2);
        }
        IOUtil.writeUTF((DataOutput)out, (String)(s != null ? s : ""));
    }

    private static <TKey, TValue> void addElement(Map<TKey, Set<TValue>> map, TKey key, TValue value) {
        LinkedHashSet list = map.get(key);
        if (list == null) {
            list = ContainerUtil.newLinkedHashSet();
            map.put(key, list);
        }
        list.add(value);
    }

    @NotNull
    private static String getQualifiedNameByMxmlFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            FlexStyleIndex.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FlexStyleIndex.$$$reportNull$$$0(4);
        }
        String name = FileUtil.getNameWithoutExtension((String)file.getName());
        String packageName = JSResolveUtil.getExpectedPackageNameFromFile((VirtualFile)file, (Project)project);
        if (packageName != null && packageName.length() > 0) {
            String string = packageName + "." + name;
            if (string == null) {
                FlexStyleIndex.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            FlexStyleIndex.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void indexMxmlFile(@NotNull XmlFile file, @NotNull VirtualFile virtualFile, final @NotNull Map<String, Set<FlexStyleIndexInfo>> map) {
        XmlTag rootTag;
        if (file == null) {
            FlexStyleIndex.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            FlexStyleIndex.$$$reportNull$$$0(8);
        }
        if (map == null) {
            FlexStyleIndex.$$$reportNull$$$0(9);
        }
        if ((rootTag = FlexStyleIndex.getRootTag(file)) != null) {
            final String classQName = FlexStyleIndex.getQualifiedNameByMxmlFile(virtualFile, file.getProject());
            JSResolveUtil.JSInjectedFilesVisitor jsFilesVisitor = new JSResolveUtil.JSInjectedFilesVisitor(){

                protected void process(JSFile file) {
                    FlexStyleIndex.indexAttributes((PsiElement)file, classQName, true, map);
                }
            };
            FlexUtils.processMxmlTags(rootTag, false, jsFilesVisitor);
        }
    }

    @Nullable
    private static XmlTag getRootTag(XmlFile file) {
        XmlDocument document = file.getDocument();
        if (document != null) {
            return document.getRootTag();
        }
        return null;
    }

    @NotNull
    public DataIndexer<String, Set<FlexStyleIndexInfo>, FileContent> getIndexer() {
        DataIndexer<String, Set<FlexStyleIndexInfo>, FileContent> dataIndexer = new DataIndexer<String, Set<FlexStyleIndexInfo>, FileContent>(){

            @NotNull
            public Map<String, Set<FlexStyleIndexInfo>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    3.$$$reportNull$$$0(0);
                }
                THashMap map = new THashMap();
                if (JavaScriptSupportLoader.isFlexMxmFile((String)inputData.getFileName())) {
                    PsiFile file = inputData.getPsiFile();
                    VirtualFile virtualFile = inputData.getFile();
                    if (file instanceof XmlFile) {
                        FlexStyleIndex.indexMxmlFile((XmlFile)file, virtualFile, (Map)map);
                    }
                } else {
                    StubTree tree = JSPackageIndex.getStubTree((FileContent)inputData);
                    if (tree != null) {
                        for (StubElement e : tree.getPlainList()) {
                            PsiElement psiElement;
                            if (e instanceof JSClassStub) {
                                psiElement = e.getPsi();
                                if (!(psiElement instanceof JSClass)) continue;
                                String qName = ((JSClass)psiElement).getQualifiedName();
                                FlexStyleIndex.indexAttributes(psiElement, qName, true, (Map)map);
                                continue;
                            }
                            if (!(e instanceof PsiFileStub) || !((psiElement = e.getPsi()) instanceof JSFile)) continue;
                            String name = ((JSFile)psiElement).getName();
                            FlexStyleIndex.indexAttributes(psiElement, name, false, (Map)map);
                        }
                    }
                }
                THashMap tHashMap = map;
                if (tHashMap == null) {
                    3.$$$reportNull$$$0(1);
                }
                return tHashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/flex/css/FlexStyleIndex$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/flex/css/FlexStyleIndex$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            FlexStyleIndex.$$$reportNull$$$0(10);
        }
        return dataIndexer;
    }

    private static void indexAttributes(PsiElement element, final String classQName, final boolean inClass, final Map<String, Set<FlexStyleIndexInfo>> map) {
        ActionScriptResolveUtil.processMetaAttributesForClass((PsiElement)element, (ActionScriptResolveUtil.MetaDataProcessor)new ActionScriptResolveUtil.MetaDataProcessor(){

            public boolean process(@NotNull JSAttribute jsAttribute) {
                String attrName;
                if (jsAttribute == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((attrName = jsAttribute.getName()) != null && "Style".equals(attrName)) {
                    FlexStyleIndexInfo info;
                    String propertyName;
                    JSAttributeNameValuePair pair = jsAttribute.getValueByName("name");
                    String string = propertyName = pair != null ? pair.getSimpleValue() : null;
                    if (propertyName != null && classQName != null && (info = FlexStyleIndexInfo.create(classQName, propertyName, jsAttribute, inClass)) != null) {
                        FlexStyleIndex.addElement(map, propertyName, info);
                        String classicPropertyName = FlexCssUtil.toClassicForm(propertyName);
                        if (!propertyName.equals(classicPropertyName)) {
                            FlexStyleIndex.addElement(map, classicPropertyName, info);
                        }
                    }
                }
                return true;
            }

            public boolean handleOtherElement(PsiElement el, PsiElement context, @Nullable Ref<PsiElement> continuePassElement) {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsAttribute", "com/intellij/javascript/flex/css/FlexStyleIndex$4", "process"));
            }
        }, (boolean)false);
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            FlexStyleIndex.$$$reportNull$$$0(11);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Set<FlexStyleIndexInfo>> getValueExternalizer() {
        DataExternalizer<Set<FlexStyleIndexInfo>> dataExternalizer = this.myDataExternalizer;
        if (dataExternalizer == null) {
            FlexStyleIndex.$$$reportNull$$$0(12);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FlexInputFilter flexInputFilter = FlexInputFilter.getInstance();
        if (flexInputFilter == null) {
            FlexStyleIndex.$$$reportNull$$$0(13);
        }
        return flexInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 18;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/css/FlexStyleIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/css/FlexStyleIndex";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameByMxmlFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readUTF";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeUTF";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameByMxmlFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "indexMxmlFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

