/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileBasedUserDataCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlIdValueReference
extends BasicAttributeValueReference {
    private static final FileBasedUserDataCache<List<PsiElement>> ourCachedIdsCache = new FileBasedUserDataCache<List<PsiElement>>(){
        private final Key<CachedValue<List<PsiElement>>> ourCachedIdsValueKey = Key.create((String)"mxml.id.cached.value");

        protected List<PsiElement> doCompute(PsiFile file) {
            final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(true){

                public void visitXmlTag(XmlTag tag) {
                    if (XmlIdValueReference.isAcceptableTagType(tag)) {
                        result.add(tag);
                    }
                    super.visitXmlTag(tag);
                }
            });
            return result;
        }

        protected Key<CachedValue<List<PsiElement>>> getKey() {
            return this.ourCachedIdsValueKey;
        }
    };

    public XmlIdValueReference(PsiElement element) {
        super(element);
    }

    @Nullable
    private static PsiElement getIdValueElement(PsiElement element) {
        if (element instanceof XmlTag) {
            XmlAttribute attribute = ((XmlTag)element).getAttribute("id", null);
            return attribute != null ? attribute.getValueElement() : null;
        }
        return element;
    }

    @Nullable
    protected static String getIdValue(PsiElement element) {
        if (element instanceof XmlTag) {
            return ((XmlTag)element).getAttributeValue("id");
        }
        return null;
    }

    protected static boolean isAcceptableTagType(XmlTag subTag) {
        return subTag.getAttributeValue("id") != null;
    }

    private void process(PsiElementProcessor<PsiElement> processor) {
        PsiFile psiFile = this.getElement().getContainingFile();
        for (PsiElement e : (List)ourCachedIdsCache.compute(psiFile)) {
            if (processor.execute(e)) continue;
            return;
        }
    }

    @Nullable
    public PsiElement resolve() {
        final Ref result = new Ref();
        this.process(new PsiElementProcessor<PsiElement>(){
            final String canonicalText;
            {
                this.canonicalText = XmlIdValueReference.this.getCanonicalText();
            }

            public boolean execute(@NotNull PsiElement element) {
                String idValue;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((idValue = XmlIdValueReference.getIdValue(element)) != null && idValue.equals(this.canonicalText)) {
                    result.set((Object)XmlIdValueReference.getIdValueElement(element));
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/XmlIdValueReference$2", "execute"));
            }
        });
        return (PsiElement)result.get();
    }

    @NotNull
    public Object[] getVariants() {
        final LinkedList result = new LinkedList();
        this.process(new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                result.add(XmlIdValueReference.getIdValue(element));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/XmlIdValueReference$3", "execute"));
            }
        });
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            XmlIdValueReference.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/XmlIdValueReference", "getVariants"));
    }
}

