/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.javascript.flex.FlexPropertiesSupport;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FlexPropertyReferenceProvider
extends PsiReferenceProvider {
    private static final Set<String> ourMethodsWithPropertyReferences = new THashSet(Arrays.asList("findResourceBundleWithResource", "getString", "getObject", "getClass", "getStringArray", "getNumber", "getInt", "getUint", "getBoolean"));
    private static final FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl> ourPropertyInfoProvider = new FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl>(){

        @Override
        public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
            return FlexPropertyReferenceProvider.getValueRange(element);
        }

        @Override
        public String getBundleName(JSLiteralExpressionImpl element) {
            return null;
        }

        @Override
        public boolean isSoft(JSLiteralExpressionImpl element) {
            return false;
        }
    };
    private static final FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl> ourSoftPropertyInfoProvider = new FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl>(){

        @Override
        public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
            return FlexPropertyReferenceProvider.getValueRange(element);
        }

        @Override
        public String getBundleName(JSLiteralExpressionImpl element) {
            return null;
        }

        @Override
        public boolean isSoft(JSLiteralExpressionImpl element) {
            return true;
        }
    };
    private static final FlexPropertiesSupport.BundleReferenceInfoProvider<JSLiteralExpressionImpl> ourBundleInfoProvider = new FlexPropertiesSupport.BundleReferenceInfoProvider<JSLiteralExpressionImpl>(){

        @Override
        public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
            return FlexPropertyReferenceProvider.getValueRange(element);
        }

        @Override
        public boolean isSoft(JSLiteralExpressionImpl element) {
            return false;
        }
    };
    private static final FlexPropertiesSupport.BundleReferenceInfoProvider<JSLiteralExpressionImpl> ourSoftBundleInfoProvider = new FlexPropertiesSupport.BundleReferenceInfoProvider<JSLiteralExpressionImpl>(){

        @Override
        public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
            return FlexPropertyReferenceProvider.getValueRange(element);
        }

        @Override
        public boolean isSoft(JSLiteralExpressionImpl element) {
            return true;
        }
    };

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            FlexPropertyReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            FlexPropertyReferenceProvider.$$$reportNull$$$0(1);
        }
        PsiElement parent = element.getParent();
        JSReferenceExpression invokedMethod = JSUtils.getMethodNameIfInsideCall((PsiElement)parent);
        ArrayList result = new ArrayList();
        if (invokedMethod != null) {
            JSExpression qualifier;
            boolean justResourceBundleRef = false;
            String invokedMethodName = invokedMethod.getReferencedName();
            if ((ourMethodsWithPropertyReferences.contains(invokedMethodName) || (justResourceBundleRef = "getResourceBundle".equals(invokedMethodName))) && ((qualifier = invokedMethod.getQualifier()) instanceof JSReferenceExpression || qualifier instanceof JSCallExpression && ((JSCallExpression)qualifier).getMethodExpression() instanceof JSReferenceExpression)) {
                PsiElement parentClass;
                PsiElement resolved;
                JSExpression[] args = ((JSArgumentList)parent).getArguments();
                boolean propertyRef = false;
                boolean bundleRef = false;
                if (justResourceBundleRef) {
                    bundleRef = args.length > 1 && args[1] == element;
                } else {
                    propertyRef = args.length > 1 && args[1] == element;
                    boolean bl = bundleRef = args.length > 0 && args[0] == element;
                    if (bundleRef && args.length == 1) {
                        bundleRef = false;
                        propertyRef = true;
                    }
                }
                boolean isSoft = true;
                if ((propertyRef || bundleRef) && (resolved = invokedMethod.resolve()) instanceof JSFunction && (parentClass = JSResolveUtil.findParent((PsiElement)resolved)) instanceof JSClass) {
                    String name = ((JSClass)parentClass).getName();
                    boolean bl = isSoft = name == null || name.indexOf("ResourceManager") == -1 && name.indexOf("ResourceBundle") == -1;
                }
                if (propertyRef) {
                    FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl> provider;
                    FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl> propertyReferenceInfoProvider = provider = isSoft ? ourSoftPropertyInfoProvider : ourPropertyInfoProvider;
                    if (args.length > 1 && !isSoft) {
                        Object expressionValue;
                        PsiElement resolved2;
                        JSExpression bundleExpression = args[0];
                        if (bundleExpression instanceof JSReferenceExpression && (resolved2 = ((JSReferenceExpression)bundleExpression).resolve()) instanceof JSVariable) {
                            bundleExpression = ((JSVariable)resolved2).getInitializer();
                        }
                        if (bundleExpression instanceof JSLiteralExpression && (expressionValue = ((JSLiteralExpression)bundleExpression).getValue()) instanceof String) {
                            provider = new FlexPropertiesSupport.PropertyReferenceInfoProvider<JSLiteralExpressionImpl>(){

                                @Override
                                public TextRange getReferenceRange(JSLiteralExpressionImpl element) {
                                    return FlexPropertyReferenceProvider.getValueRange(element);
                                }

                                @Override
                                public String getBundleName(JSLiteralExpressionImpl element) {
                                    return (String)expressionValue;
                                }

                                @Override
                                public boolean isSoft(JSLiteralExpressionImpl element) {
                                    return false;
                                }
                            };
                        }
                    }
                    Collections.addAll(result, FlexPropertiesSupport.getPropertyReferences((JSLiteralExpressionImpl)element, provider));
                } else if (bundleRef) {
                    PsiReference[] reference = FlexPropertiesSupport.getResourceBundleReference((JSLiteralExpressionImpl)element, isSoft ? ourSoftBundleInfoProvider : ourBundleInfoProvider);
                    Collections.addAll(result, reference);
                }
            }
        }
        PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            FlexPropertyReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private static TextRange getValueRange(JSLiteralExpressionImpl element) {
        int textLength = element.getTextLength();
        if (textLength < 2) {
            return null;
        }
        return new TextRange(1, textLength - 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/flex/FlexPropertyReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/flex/FlexPropertyReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

