/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class NotNullCachedComputableWrapper<T>
implements NotNullComputable<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)NotNullCachedComputableWrapper.class.getName());
    private volatile NotNullComputable<T> myComputable;
    private final AtomicReference<T> myValueRef;

    public NotNullCachedComputableWrapper(@NotNull NotNullComputable<T> computable) {
        if (computable == null) {
            NotNullCachedComputableWrapper.$$$reportNull$$$0(0);
        }
        this.myValueRef = new AtomicReference();
        this.myComputable = computable;
    }

    @NotNull
    public T compute() {
        Object value;
        block5: {
            while (true) {
                if ((value = this.myValueRef.get()) != null) {
                    T t = value;
                    if (t == null) {
                        NotNullCachedComputableWrapper.$$$reportNull$$$0(1);
                    }
                    return t;
                }
                NotNullComputable<T> computable = this.myComputable;
                if (computable == null) continue;
                RecursionGuard.StackStamp stamp = ourGuard.markStack();
                value = computable.compute();
                if (!stamp.mayCacheNow()) break block5;
                if (this.myValueRef.compareAndSet(null, value)) break;
            }
            this.myComputable = null;
            Object object = value;
            if (object == null) {
                NotNullCachedComputableWrapper.$$$reportNull$$$0(2);
            }
            return object;
        }
        Object object = value;
        if (object == null) {
            NotNullCachedComputableWrapper.$$$reportNull$$$0(3);
        }
        return object;
    }

    public boolean isComputed() {
        return this.myValueRef.get() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/util/NotNullCachedComputableWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/util/NotNullCachedComputableWrapper";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

