/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GrFileIndexUtil {
    public static boolean isGroovySourceFile(@NotNull PsiFile file) {
        if (file == null) {
            GrFileIndexUtil.$$$reportNull$$$0(0);
        }
        return file instanceof GroovyFileBase && GrFileIndexUtil.isGroovySourceFile((GroovyFileBase)file);
    }

    public static boolean isGroovySourceFile(@NotNull GroovyFileBase file) {
        if (file == null) {
            GrFileIndexUtil.$$$reportNull$$$0(1);
        }
        return GrFileIndexUtil.isInSourceFiles(file.getVirtualFile(), file.getProject());
    }

    private static boolean isInSourceFiles(@Nullable VirtualFile file, @NotNull Project project) {
        FileIndexFacade index;
        if (project == null) {
            GrFileIndexUtil.$$$reportNull$$$0(2);
        }
        return file != null && !(file instanceof LightVirtualFile) && ((index = FileIndexFacade.getInstance((Project)project)).isInSource(file) || index.isInLibraryClasses(file));
    }

    public static boolean hasNameInFile(@NotNull PsiFile file, @NotNull String name) {
        if (file == null) {
            GrFileIndexUtil.$$$reportNull$$$0(3);
        }
        if (name == null) {
            GrFileIndexUtil.$$$reportNull$$$0(4);
        }
        if (file.getVirtualFile() == null || DumbService.isDumb((Project)file.getProject())) {
            return StringUtil.contains((CharSequence)file.getViewProvider().getContents(), (CharSequence)name);
        }
        GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)file);
        return !FileBasedIndex.getInstance().getContainingFiles(IdIndex.NAME, (Object)new IdIndexEntry(name, true), scope).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/util/GrFileIndexUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isGroovySourceFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSourceFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNameInFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

