/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.transformations.impl.autoClone;

import com.intellij.lang.Language;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;
import org.jetbrains.plugins.groovy.transformations.TransformationUtilKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/groovy/transformations/impl/autoClone/AutoCloneTransformationSupport;", "Lorg/jetbrains/plugins/groovy/transformations/AstTransformationSupport;", "()V", "applyTransformation", "", "context", "Lorg/jetbrains/plugins/groovy/transformations/TransformationContext;", "Companion", "groovy-psi"})
public final class AutoCloneTransformationSupport
implements AstTransformationSupport {
    @NotNull
    private static final String AUTO_CLONE_FQN = "groovy.transform.AutoClone";
    @NotNull
    private static final String ORIGIN_INFO = "created by @AutoClone";
    @NotNull
    private static final String CNSE_FQN = "java.lang.CloneNotSupportedException";
    public static final Companion Companion = new Companion(null);

    @Override
    public void applyTransformation(@NotNull TransformationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PsiAnnotation psiAnnotation = context.getAnnotation(Companion.getAUTO_CLONE_FQN());
        if (psiAnnotation == null) {
            return;
        }
        PsiAnnotation annotation = psiAnnotation;
        context.addInterface("java.lang.Cloneable");
        LightMethodBuilder lightMethodBuilder = new LightMethodBuilder(context.getManager(), "clone");
        TransformationContext transformationContext = context;
        LightMethodBuilder $receiver = lightMethodBuilder;
        $receiver.addModifier("public");
        $receiver.setMethodReturnType((PsiType)TypesUtil.createType(context.getCodeClass()));
        $receiver.addException(Companion.getCNSE_FQN());
        $receiver.setNavigationElement((PsiElement)annotation);
        $receiver.setOriginInfo(Companion.getORIGIN_INFO());
        LightMethodBuilder lightMethodBuilder2 = lightMethodBuilder;
        TransformationUtilKt.plusAssign(transformationContext, (PsiMethod)lightMethodBuilder2);
        PsiAnnotationMemberValue psiAnnotationMemberValue = GrAnnotationUtilKt.findDeclaredDetachedValue(annotation, "style");
        if (!(psiAnnotationMemberValue instanceof GrReferenceExpression)) {
            psiAnnotationMemberValue = null;
        }
        GrReferenceExpression grReferenceExpression = (GrReferenceExpression)psiAnnotationMemberValue;
        if (grReferenceExpression == null) {
            return;
        }
        GrReferenceExpression value = grReferenceExpression;
        PsiElement psiElement = value.resolve();
        if (!(psiElement instanceof PsiEnumConstant)) {
            psiElement = null;
        }
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)psiElement;
        if (psiEnumConstant == null) {
            return;
        }
        PsiEnumConstant constant = psiEnumConstant;
        PsiClass psiClass = constant.getContainingClass();
        if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"groovy.transform.AutoCloneStyle") ^ true) {
            return;
        }
        switch (constant.getName()) {
            case "COPY_CONSTRUCTOR": {
                LightMethodBuilder $receiver2;
                LightMethodBuilder lightMethodBuilder3 = (LightMethodBuilder)context.getCodeClass().getCodeConstructors();
                if (((Object[])lightMethodBuilder3).length == 0) {
                    lightMethodBuilder3 = new LightMethodBuilder((PsiClass)context.getCodeClass(), (Language)GroovyLanguage.INSTANCE);
                    transformationContext = context;
                    $receiver2 = lightMethodBuilder3;
                    $receiver2.setConstructor(true);
                    $receiver2.addModifier("public");
                    $receiver2.setNavigationElement((PsiElement)context.getCodeClass());
                    lightMethodBuilder2 = lightMethodBuilder3;
                    TransformationUtilKt.plusAssign(transformationContext, (PsiMethod)lightMethodBuilder2);
                }
                lightMethodBuilder3 = new LightMethodBuilder((PsiClass)context.getCodeClass(), (Language)GroovyLanguage.INSTANCE);
                transformationContext = context;
                $receiver2 = lightMethodBuilder3;
                $receiver2.setConstructor(true);
                $receiver2.addModifier("protected");
                $receiver2.addParameter("other", (PsiType)TypesUtil.createType(context.getCodeClass()));
                $receiver2.setNavigationElement((PsiElement)context.getCodeClass());
                $receiver2.setOriginInfo(Companion.getORIGIN_INFO());
                lightMethodBuilder2 = lightMethodBuilder3;
                TransformationUtilKt.plusAssign(transformationContext, (PsiMethod)lightMethodBuilder2);
                break;
            }
            case "SIMPLE": {
                LightMethodBuilder lightMethodBuilder4 = new LightMethodBuilder(context.getManager(), "cloneOrCopyMembers");
                transformationContext = context;
                LightMethodBuilder $receiver3 = lightMethodBuilder4;
                $receiver3.addModifier("protected");
                $receiver3.setMethodReturnType((PsiType)PsiType.VOID);
                $receiver3.addParameter("other", (PsiType)TypesUtil.createType(context.getCodeClass()));
                $receiver3.addException(Companion.getCNSE_FQN());
                $receiver3.setNavigationElement((PsiElement)annotation);
                $receiver3.setOriginInfo(Companion.getORIGIN_INFO());
                lightMethodBuilder2 = lightMethodBuilder4;
                TransformationUtilKt.plusAssign(transformationContext, (PsiMethod)lightMethodBuilder2);
            }
        }
    }

    static {
        AUTO_CLONE_FQN = AUTO_CLONE_FQN;
        ORIGIN_INFO = ORIGIN_INFO;
        CNSE_FQN = CNSE_FQN;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/transformations/impl/autoClone/AutoCloneTransformationSupport$Companion;", "", "()V", "AUTO_CLONE_FQN", "", "getAUTO_CLONE_FQN", "()Ljava/lang/String;", "CNSE_FQN", "getCNSE_FQN", "ORIGIN_INFO", "getORIGIN_INFO", "groovy-psi"})
    private static final class Companion {
        @NotNull
        public final String getAUTO_CLONE_FQN() {
            return AUTO_CLONE_FQN;
        }

        @NotNull
        public final String getORIGIN_INFO() {
            return ORIGIN_INFO;
        }

        @NotNull
        public final String getCNSE_FQN() {
            return CNSE_FQN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

