/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceParameter.ExternalUsageInfo;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import com.intellij.refactoring.introduceParameter.IntroduceParameterUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringError;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.extract.ExtractUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContextImpl;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GroovyFieldValidator;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.GrIntroduceParameterSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.IntroduceParameterInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.parameter.ReferencedElementsCollector;

public class GroovyIntroduceParameterUtil {
    private static final Logger LOG = Logger.getInstance(GroovyIntroduceParameterUtil.class);

    private GroovyIntroduceParameterUtil() {
    }

    public static PsiField[] findUsedFieldsWithGetters(GrStatement[] statements, PsiClass containingClass) {
        if (containingClass == null) {
            return PsiField.EMPTY_ARRAY;
        }
        FieldSearcher searcher = new FieldSearcher(containingClass);
        for (GrStatement statement : statements) {
            statement.accept(searcher);
        }
        return searcher.getResult();
    }

    @Nullable
    public static PsiParameter getAnchorParameter(PsiParameterList parameterList, boolean isVarArgs) {
        PsiParameter[] parameters = parameterList.getParameters();
        int length = parameters.length;
        if (isVarArgs) {
            return length > 1 ? parameters[length - 2] : null;
        }
        return length > 0 ? parameters[length - 1] : null;
    }

    public static void removeParametersFromCall(GrClosureSignatureUtil.ArgInfo<PsiElement>[] actualArgs, TIntArrayList parametersToRemove) {
        parametersToRemove.forEach(paramNum -> {
            try {
                GrClosureSignatureUtil.ArgInfo actualArg = actualArgs[paramNum];
                for (PsiElement arg : actualArg.args) {
                    arg.delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return true;
        });
    }

    public static void removeParamsFromUnresolvedCall(GrCall callExpression, PsiParameter[] parameters, TIntArrayList parametersToRemove) {
        boolean hasNamedArgs;
        GrExpression[] arguments = callExpression.getExpressionArguments();
        GrClosableBlock[] closureArguments = callExpression.getClosureArguments();
        GrNamedArgument[] namedArguments = callExpression.getNamedArguments();
        if (namedArguments.length > 0) {
            if (parameters.length > 0) {
                PsiType type = parameters[0].getType();
                hasNamedArgs = InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map");
            } else {
                hasNamedArgs = false;
            }
        } else {
            hasNamedArgs = false;
        }
        parametersToRemove.forEachDescending(paramNum -> {
            try {
                if (paramNum == 0 && hasNamedArgs) {
                    for (GrNamedArgument namedArgument : namedArguments) {
                        namedArgument.delete();
                    }
                } else {
                    if (hasNamedArgs) {
                        --paramNum;
                    }
                    if (paramNum < arguments.length) {
                        arguments[paramNum].delete();
                    } else if (paramNum < arguments.length + closureArguments.length) {
                        closureArguments[paramNum - arguments.length].delete();
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            return true;
        });
    }

    public static void detectAccessibilityConflicts(@Nullable GroovyPsiElement elementToProcess, UsageInfo[] usages, MultiMap<PsiElement, String> conflicts, boolean replaceFieldsWithGetters, Project project) {
        if (elementToProcess == null) {
            return;
        }
        ReferencedElementsCollector collector = new ReferencedElementsCollector();
        elementToProcess.accept(collector);
        List<PsiElement> result = collector.getResult();
        if (result.isEmpty()) {
            return;
        }
        for (UsageInfo usageInfo : usages) {
            if (!(usageInfo instanceof ExternalUsageInfo) || !IntroduceParameterUtil.isMethodUsage((UsageInfo)usageInfo)) continue;
            PsiElement place = usageInfo.getElement();
            for (PsiElement element : result) {
                if (element instanceof PsiField && replaceFieldsWithGetters) {
                    PsiClass psiClass = ((PsiField)element).getContainingClass();
                    LOG.assertTrue(psiClass != null);
                    PsiMethod method = GroovyPropertyUtils.findGetterForField((PsiField)element);
                    if (method != null) {
                        element = method;
                    }
                }
                if (!(element instanceof PsiMember) || JavaPsiFacade.getInstance((Project)project).getResolveHelper().isAccessible((PsiMember)element, place, null)) continue;
                String message = RefactoringBundle.message((String)"0.is.not.accessible.from.1.value.for.introduced.parameter.in.that.method.call.will.be.incorrect", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer((PsiElement)place), (boolean)true)});
                conflicts.putValue((Object)element, (Object)message);
            }
        }
    }

    public static void processChangedMethodCall(PsiElement element, GrIntroduceParameterSettings settings, Project project) {
        if (!(element.getParent() instanceof GrMethodCallExpression)) {
            LOG.error((Object)element.getParent());
            return;
        }
        GrMethodCallExpression methodCall = (GrMethodCallExpression)element.getParent();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        String name = settings.getName();
        LOG.assertTrue(name != null);
        GrExpression expression = factory.createExpressionFromText(name, null);
        GrArgumentList argList = methodCall.getArgumentList();
        GroovyPsiElement[] exprs = argList.getAllArguments();
        if (exprs.length > 0) {
            argList.addAfter(expression, exprs[exprs.length - 1]);
        } else {
            argList.add(expression);
        }
        GroovyIntroduceParameterUtil.removeParametersFromCall(methodCall, settings);
    }

    private static void removeParametersFromCall(GrMethodCallExpression methodCall, GrIntroduceParameterSettings settings) {
        GroovyResolveResult resolveResult = methodCall.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        LOG.assertTrue(resolved instanceof PsiMethod);
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature((PsiMethod)resolved, resolveResult.getSubstitutor());
        GrClosureSignatureUtil.ArgInfo[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, methodCall);
        LOG.assertTrue(argInfos != null);
        settings.parametersToRemove().forEach(value -> {
            List args = argInfos[value].args;
            for (PsiElement arg : args) {
                arg.delete();
            }
            return true;
        });
    }

    public static GrMethod generateDelegate(PsiMethod prototype, IntroduceParameterData.ExpressionWrapper initializer, Project project) {
        GrMethod result;
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        if (prototype instanceof GrMethod) {
            result = (GrMethod)prototype.copy();
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(prototype.getModifierList().getText()).append(' ');
            if (prototype.getReturnTypeElement() != null) {
                builder.append(prototype.getReturnTypeElement().getText());
            }
            builder.append(' ').append(prototype.getName());
            builder.append(prototype.getParameterList().getText());
            builder.append("{}");
            result = factory.createMethodFromText(builder.toString());
        }
        StringBuilder call = new StringBuilder();
        call.append("def foo(){\n");
        GrParameter[] parameters = result.getParameters();
        call.append(prototype.getName());
        if (initializer.getExpression() instanceof GrClosableBlock) {
            if (parameters.length > 0) {
                call.append('(');
                for (GrParameter parameter : parameters) {
                    call.append(parameter.getName()).append(", ");
                }
                call.replace(call.length() - 2, call.length(), ")");
            }
            call.append(initializer.getText());
        } else {
            call.append('(');
            for (GrParameter parameter : parameters) {
                call.append(parameter.getName()).append(", ");
            }
            call.append(initializer.getText());
            call.append(")");
        }
        call.append("\n}");
        GrOpenBlock block = factory.createMethodFromText(call.toString()).getBlock();
        result.getBlock().replace(block);
        PsiElement parent = prototype.getParent();
        GrMethod method = (GrMethod)parent.addBefore((PsiElement)result, (PsiElement)prototype);
        JavaCodeStyleManager.getInstance((Project)method.getProject()).shortenClassReferences((PsiElement)method);
        return method;
    }

    public static TObjectIntHashMap<GrParameter> findParametersToRemove(IntroduceParameterInfo helper) {
        TObjectIntHashMap result = new TObjectIntHashMap();
        TextRange range = ExtractUtil.getRangeOfRefactoring(helper);
        GrParameter[] parameters = helper.getToReplaceIn().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            GrParameter parameter = parameters[i];
            if (!GroovyIntroduceParameterUtil.shouldRemove(parameter, range.getStartOffset(), range.getEndOffset())) continue;
            result.put((Object)parameter, i);
        }
        return result;
    }

    private static boolean shouldRemove(GrParameter parameter, int start, int end) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter)) {
            int offset;
            PsiElement element = reference.getElement();
            if (element == null || (offset = element.getTextRange().getStartOffset()) >= start && end > offset) continue;
            return false;
        }
        return true;
    }

    static PsiElement[] getOccurrences(GrIntroduceParameterSettings settings) {
        GrParametersOwner scope = settings.getToReplaceIn();
        GrExpression expression = settings.getExpression();
        if (expression != null) {
            PsiElement expr = PsiUtil.skipParentheses(expression, false);
            if (expr == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement[] occurrences = GroovyRefactoringUtil.getExpressionOccurrences(expr, scope);
            if (occurrences == null || occurrences.length == 0) {
                throw new GrRefactoringError(GroovyRefactoringBundle.message("no.occurrences.found", new Object[0]));
            }
            return occurrences;
        }
        GrVariable var = settings.getVar();
        LOG.assertTrue(var != null);
        List list = Collections.synchronizedList(new ArrayList());
        ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope((PsiElement)scope)).forEach(psiReference -> {
            PsiElement element = psiReference.getElement();
            if (element != null) {
                list.add(element);
            }
            return true;
        });
        return list.toArray(new PsiElement[list.size()]);
    }

    @Nullable
    public static GrExpression addClosureToCall(PsiElement initializer, GrArgumentList list) {
        if (!(initializer instanceof GrClosableBlock)) {
            return null;
        }
        PsiElement parent = list.getParent();
        if (!(parent instanceof GrMethodCallExpression)) {
            return null;
        }
        GrClosableBlock[] cls = ((GrMethodCallExpression)parent).getClosureArguments();
        GroovyPsiElement anchor = cls.length > 0 ? cls[cls.length - 1] : list;
        return (GrExpression)parent.addAfter(initializer, (PsiElement)anchor);
    }

    @Nullable
    static GrVariable findVar(IntroduceParameterInfo info) {
        GrVariable variable = info.getVar();
        if (variable != null) {
            return variable;
        }
        GrStatement[] statements = info.getStatements();
        if (statements.length != 1) {
            return null;
        }
        return GrIntroduceHandlerBase.findVariable(statements[0]);
    }

    @Nullable
    static GrExpression findExpr(IntroduceParameterInfo info) {
        GrStatement[] statements = info.getStatements();
        if (statements.length != 1) {
            return null;
        }
        return GrIntroduceHandlerBase.findExpression(statements[0]);
    }

    static LinkedHashSet<String> suggestNames(GrVariable var, GrExpression expr, StringPartInfo stringPart, GrParametersOwner scope, Project project) {
        if (expr != null) {
            GrIntroduceContextImpl introduceContext = new GrIntroduceContextImpl(project, null, expr, var, stringPart, PsiElement.EMPTY_ARRAY, scope);
            GroovyFieldValidator validator = new GroovyFieldValidator(introduceContext);
            return new LinkedHashSet<String>(Arrays.asList(GroovyNameSuggestionUtil.suggestVariableNames(expr, validator, true)));
        }
        if (var != null) {
            GrIntroduceContextImpl introduceContext = new GrIntroduceContextImpl(project, null, expr, var, stringPart, PsiElement.EMPTY_ARRAY, scope);
            GroovyFieldValidator validator = new GroovyFieldValidator(introduceContext);
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            names.add(var.getName());
            ContainerUtil.addAll(names, (Object[])GroovyNameSuggestionUtil.suggestVariableNameByType(var.getType(), validator));
            return names;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.add("closure");
        return names;
    }

    private static class FieldSearcher
    extends GroovyRecursiveElementVisitor {
        PsiClass myClass;
        private final List<PsiField> result = new ArrayList<PsiField>();

        private FieldSearcher(PsiClass aClass) {
            this.myClass = aClass;
        }

        public PsiField[] getResult() {
            return (PsiField[])ContainerUtil.toArray(this.result, (Object[])new PsiField[this.result.size()]);
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression ref) {
            if (ref == null) {
                FieldSearcher.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(ref);
            GrExpression qualifier = (GrExpression)ref.getQualifier();
            if (!PsiUtil.isThisReference(qualifier)) {
                return;
            }
            PsiElement resolved = ref.resolve();
            if (!(resolved instanceof PsiField)) {
                return;
            }
            PsiMethod getter = GroovyPropertyUtils.findGetterForField((PsiField)resolved);
            if (getter != null) {
                this.result.add((PsiField)resolved);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GroovyIntroduceParameterUtil$FieldSearcher", "visitReferenceExpression"));
        }
    }
}

