/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.convertToJava;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.containers.HashMap;
import gnu.trove.TIntArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class TypeProvider {
    private final Map<GrMethod, PsiType[]> inferredTypes = new HashMap();

    @NotNull
    public PsiType getReturnType(@NotNull PsiMethod method) {
        GrTypeElement typeElement;
        if (method == null) {
            TypeProvider.$$$reportNull$$$0(0);
        }
        if (method instanceof GrMethod && (typeElement = ((GrMethod)method).getReturnTypeElementGroovy()) != null) {
            PsiType psiType = typeElement.getType();
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(1);
            }
            return psiType;
        }
        PsiType smartReturnType = PsiUtil.getSmartReturnType(method);
        if (smartReturnType != null && !PsiType.NULL.equals((Object)smartReturnType)) {
            PsiType psiType = smartReturnType;
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(2);
            }
            return psiType;
        }
        if (PsiType.NULL.equals((Object)smartReturnType) && PsiUtil.isVoidMethod(method)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
            if (psiPrimitiveType == null) {
                TypeProvider.$$$reportNull$$$0(3);
            }
            return psiPrimitiveType;
        }
        PsiClassType psiClassType = TypesUtil.getJavaLangObject((PsiElement)method);
        if (psiClassType == null) {
            TypeProvider.$$$reportNull$$$0(4);
        }
        return psiClassType;
    }

    @NotNull
    public PsiType getVarType(@NotNull PsiVariable variable) {
        if (variable == null) {
            TypeProvider.$$$reportNull$$$0(5);
        }
        if (variable instanceof PsiParameter) {
            PsiType psiType = this.getParameterType((PsiParameter)variable);
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(6);
            }
            return psiType;
        }
        PsiType psiType = TypeProvider.getVariableTypeInner(variable);
        if (psiType == null) {
            TypeProvider.$$$reportNull$$$0(7);
        }
        return psiType;
    }

    @NotNull
    private static PsiType getVariableTypeInner(@NotNull PsiVariable variable) {
        if (variable == null) {
            TypeProvider.$$$reportNull$$$0(8);
        }
        PsiType type = null;
        if (variable instanceof GrVariable && (type = ((GrVariable)variable).getDeclaredType()) == null) {
            type = ((GrVariable)variable).getTypeGroovy();
        }
        if (type == null) {
            type = variable.getType();
        }
        PsiType psiType = type;
        if (psiType == null) {
            TypeProvider.$$$reportNull$$$0(9);
        }
        return psiType;
    }

    @NotNull
    public PsiType getParameterType(@NotNull PsiParameter parameter) {
        if (parameter == null) {
            TypeProvider.$$$reportNull$$$0(10);
        }
        if (!(parameter instanceof GrParameter)) {
            PsiElement scope = parameter.getDeclarationScope();
            if (scope instanceof GrAccessorMethod) {
                PsiType psiType = this.getVarType(((GrAccessorMethod)scope).getProperty());
                if (psiType == null) {
                    TypeProvider.$$$reportNull$$$0(11);
                }
                return psiType;
            }
            PsiType psiType = parameter.getType();
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(12);
            }
            return psiType;
        }
        PsiElement parent = parameter.getParent();
        if (!(parent instanceof GrParameterList)) {
            PsiType psiType = TypeProvider.getVariableTypeInner((PsiVariable)parameter);
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(13);
            }
            return psiType;
        }
        PsiElement pparent = parent.getParent();
        if (!(pparent instanceof GrMethod)) {
            PsiType psiType = parameter.getType();
            if (psiType == null) {
                TypeProvider.$$$reportNull$$$0(14);
            }
            return psiType;
        }
        PsiType[] types = this.inferMethodParameters((GrMethod)pparent);
        PsiType psiType = types[((GrParameterList)parent).getParameterNumber((GrParameter)parameter)];
        if (psiType == null) {
            TypeProvider.$$$reportNull$$$0(15);
        }
        return psiType;
    }

    @NotNull
    private PsiType[] inferMethodParameters(@NotNull GrMethod method) {
        PsiType[] psiTypes;
        if (method == null) {
            TypeProvider.$$$reportNull$$$0(16);
        }
        if ((psiTypes = this.inferredTypes.get(method)) != null) {
            if (psiTypes == null) {
                TypeProvider.$$$reportNull$$$0(17);
            }
            return psiTypes;
        }
        GrParameter[] parameters = method.getParameters();
        TIntArrayList paramInds = new TIntArrayList(parameters.length);
        PsiType[] types = PsiType.createArray((int)parameters.length);
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (parameters[i2].getTypeElementGroovy() == null) {
                paramInds.add(i2);
                continue;
            }
            types[i2] = parameters[i2].getType();
        }
        if (!paramInds.isEmpty()) {
            GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, PsiSubstitutor.EMPTY);
            MethodReferencesSearch.search((PsiMethod)method, (boolean)true).forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                PsiManager manager = element.getManager();
                GlobalSearchScope resolveScope = element.getResolveScope();
                if (element instanceof GrReferenceExpression) {
                    GrCall call = (GrCall)element.getParent();
                    GrClosureSignatureUtil.ArgInfo[] argInfos = GrClosureSignatureUtil.mapParametersToArguments(signature, call);
                    if (argInfos == null) {
                        return true;
                    }
                    paramInds.forEach(i -> {
                        PsiType type = GrClosureSignatureUtil.getTypeByArg(argInfos[i], manager, resolveScope);
                        types[i] = TypesUtil.getLeastUpperBoundNullable(type, types[i], manager);
                        return true;
                    });
                }
                return true;
            });
        }
        paramInds.forEach(i -> {
            if (types[i] == null || types[i] == PsiType.NULL) {
                types[i] = parameters[i].getType();
            }
            return true;
        });
        this.inferredTypes.put(method, types);
        if (types == null) {
            TypeProvider.$$$reportNull$$$0(18);
        }
        return types;
    }

    @NotNull
    public PsiType getReturnType(GrClosableBlock closure) {
        PsiType returnType = closure.getReturnType();
        if (PsiType.NULL.equals((Object)returnType) && PsiUtil.isBlockReturnVoid(closure)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
            if (psiPrimitiveType == null) {
                TypeProvider.$$$reportNull$$$0(19);
            }
            return psiPrimitiveType;
        }
        if (returnType == null) {
            PsiClassType psiClassType = TypesUtil.getJavaLangObject(closure);
            if (psiClassType == null) {
                TypeProvider.$$$reportNull$$$0(20);
            }
            return psiClassType;
        }
        PsiType psiType = TypesUtil.boxPrimitiveType(returnType, closure.getManager(), closure.getResolveScope());
        if (psiType == null) {
            TypeProvider.$$$reportNull$$$0(21);
        }
        return psiType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeProvider";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/convertToJava/TypeProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableTypeInner";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "inferMethodParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVarType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeInner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "inferMethodParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

