/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

@State(name="mvcRunTargetHistory", storages={@Storage(value="other.xml")})
public class MvcRunTargetHistoryService
implements PersistentStateComponent<String[]> {
    private static final int MAX_HISTORY_LENGTH = 20;
    private final LinkedList<String> myHistory = new LinkedList();
    private String myVmOptions = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getState() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            if (this.myHistory.isEmpty() && StringUtil.isEmpty((String)this.myVmOptions)) {
                return ArrayUtilRt.EMPTY_STRING_ARRAY;
            }
            String[] res = new String[this.myHistory.size() + 1];
            res[0] = '#' + this.myVmOptions;
            int i = 1;
            for (String s : this.myHistory) {
                res[i++] = s;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String getVmOptions() {
        LinkedList<String> linkedList = this.myHistory;
        // MONITORENTER : linkedList
        String string = this.myVmOptions;
        // MONITOREXIT : linkedList
        if (string != null) return string;
        MvcRunTargetHistoryService.$$$reportNull$$$0(0);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(String[] state) {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            this.myHistory.clear();
            int start = 0;
            if (state.length > 0 && state[0].charAt(0) == '#') {
                this.myVmOptions = state[0].substring(1);
                start = 1;
            } else {
                this.myVmOptions = "";
            }
            for (int i = start; i < state.length; ++i) {
                this.myHistory.add(state[i].trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHistory() {
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            return ArrayUtil.toStringArray(this.myHistory);
        }
    }

    public static MvcRunTargetHistoryService getInstance() {
        return (MvcRunTargetHistoryService)ServiceManager.getService(MvcRunTargetHistoryService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(@NotNull String command, @NotNull String vmOptions) {
        if (command == null) {
            MvcRunTargetHistoryService.$$$reportNull$$$0(1);
        }
        if (vmOptions == null) {
            MvcRunTargetHistoryService.$$$reportNull$$$0(2);
        }
        command = command.trim();
        LinkedList<String> linkedList = this.myHistory;
        synchronized (linkedList) {
            this.myVmOptions = vmOptions;
            this.myHistory.remove(command);
            this.myHistory.addFirst(command);
            if (this.myHistory.size() > 20) {
                this.myHistory.removeLast();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/MvcRunTargetHistoryService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmOptions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcRunTargetHistoryService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

