/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrClosureSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClosureParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;

public class SubstitutorComputer {
    private static final Logger LOG = Logger.getInstance(SubstitutorComputer.class);
    protected final PsiElement myPlace;
    private final PsiType myThisType;
    @Nullable
    private final PsiType[] myArgumentTypes;
    private final PsiType[] myTypeArguments;
    private final PsiElement myPlaceToInferContext;
    private final NotNullLazyValue<Collection<PsiElement>> myExitPoints;
    private final PsiResolveHelper myHelper;

    public SubstitutorComputer(PsiType thisType, @Nullable PsiType[] argumentTypes, PsiType[] typeArguments, PsiElement place, PsiElement placeToInferContext) {
        this.myThisType = thisType;
        this.myArgumentTypes = argumentTypes;
        this.myTypeArguments = typeArguments;
        this.myPlace = place;
        this.myPlaceToInferContext = placeToInferContext;
        this.myExitPoints = VolatileNotNullLazyValue.createValue(() -> {
            if (SubstitutorComputer.canBeExitPoint(place)) {
                GrControlFlowOwner flowOwner = ControlFlowUtils.findControlFlowOwner(place);
                return ContainerUtil.newHashSet(ControlFlowUtils.collectReturns(flowOwner));
            }
            return ContainerUtil.emptyList();
        });
        this.myHelper = JavaPsiFacade.getInstance((Project)this.myPlace.getProject()).getResolveHelper();
    }

    @Nullable
    protected PsiType inferContextType() {
        PsiElement parent = this.myPlaceToInferContext.getParent();
        if (parent instanceof GrReturnStatement || ((Collection)this.myExitPoints.getValue()).contains(this.myPlaceToInferContext)) {
            GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, GrMethod.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class});
            if (method != null) {
                return method.getReturnType();
            }
        } else {
            if (parent instanceof GrAssignmentExpression && this.myPlaceToInferContext.equals(((GrAssignmentExpression)parent).getRValue())) {
                PsiElement lValue = PsiUtil.skipParentheses(((GrAssignmentExpression)parent).getLValue(), false);
                if (lValue instanceof GrExpression && !(lValue instanceof GrIndexProperty)) {
                    return ((GrExpression)lValue).getNominalType();
                }
                return null;
            }
            if (parent instanceof GrVariable) {
                return ((GrVariable)parent).getDeclaredType();
            }
        }
        return null;
    }

    private static boolean canBeExitPoint(PsiElement place) {
        while (place != null) {
            if (place instanceof GrMethod || place instanceof GrClosableBlock || place instanceof GrClassInitializer) {
                return true;
            }
            if (place instanceof GrThrowStatement || place instanceof GrTypeDefinitionBody || place instanceof GroovyFile) {
                return false;
            }
            place = place.getParent();
        }
        return false;
    }

    public PsiSubstitutor obtainSubstitutor(@NotNull PsiSubstitutor substitutor, @NotNull PsiMethod method, @Nullable PsiElement resolveContext) {
        PsiTypeParameter[] typeParameters;
        if (substitutor == null) {
            SubstitutorComputer.$$$reportNull$$$0(0);
        }
        if (method == null) {
            SubstitutorComputer.$$$reportNull$$$0(1);
        }
        if (this.myTypeArguments.length == (typeParameters = method.getTypeParameters()).length) {
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiTypeParameter typeParameter = typeParameters[i];
                PsiType typeArgument = this.myTypeArguments[i];
                substitutor = substitutor.put(typeParameter, typeArgument);
            }
            return substitutor;
        }
        if (this.myArgumentTypes != null && method.hasTypeParameters()) {
            PsiType[] argTypes = this.myArgumentTypes;
            if (method instanceof GrGdkMethod) {
                PsiType[] newArgTypes = PsiType.createArray((int)(argTypes.length + 1));
                newArgTypes[0] = GdkMethodUtil.isInWithContext(resolveContext) ? ((GrExpression)resolveContext).getType() : this.myThisType;
                System.arraycopy(argTypes, 0, newArgTypes, 1, argTypes.length);
                argTypes = newArgTypes;
                method = ((GrGdkMethod)method).getStaticMethod();
                LOG.assertTrue(method.isValid());
            }
            return this.inferMethodTypeParameters(method, substitutor, typeParameters, argTypes);
        }
        return substitutor;
    }

    private PsiSubstitutor inferMethodTypeParameters(@NotNull PsiMethod method, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] argTypes) {
        if (method == null) {
            SubstitutorComputer.$$$reportNull$$$0(2);
        }
        if (partialSubstitutor == null) {
            SubstitutorComputer.$$$reportNull$$$0(3);
        }
        if (typeParameters == null) {
            SubstitutorComputer.$$$reportNull$$$0(4);
        }
        if (argTypes == null) {
            SubstitutorComputer.$$$reportNull$$$0(5);
        }
        if (typeParameters.length == 0 || this.myArgumentTypes == null) {
            return partialSubstitutor;
        }
        GrClosureSignature erasedSignature = GrClosureSignatureUtil.createSignature(method, partialSubstitutor, true);
        GrClosureSignature signature = GrClosureSignatureUtil.createSignature(method, partialSubstitutor);
        GrClosureParameter[] params = signature.getParameters();
        GrClosureSignatureUtil.ArgInfo<PsiType>[] argInfos = GrClosureSignatureUtil.mapArgTypesToParameters(erasedSignature, argTypes, this.myPlace, true);
        if (argInfos == null) {
            return partialSubstitutor;
        }
        int max = Math.max(params.length, argTypes.length);
        PsiType[] parameterTypes = PsiType.createArray((int)max);
        PsiType[] argumentTypes = PsiType.createArray((int)max);
        int i = 0;
        for (int paramIndex = 0; paramIndex < argInfos.length; ++paramIndex) {
            PsiType paramType = params[paramIndex].getType();
            GrClosureSignatureUtil.ArgInfo<PsiType> argInfo = argInfos[paramIndex];
            if (argInfo != null) {
                if (argInfo.isMultiArg && paramType instanceof PsiArrayType) {
                    paramType = ((PsiArrayType)paramType).getComponentType();
                }
                for (PsiType type : argInfo.args) {
                    argumentTypes[i] = this.handleConversion(paramType, type);
                    parameterTypes[i] = paramType;
                    ++i;
                }
                continue;
            }
            parameterTypes[i] = paramType;
            argumentTypes[i] = PsiType.NULL;
            ++i;
        }
        PsiSubstitutor substitutor = this.myHelper.inferTypeArguments(typeParameters, parameterTypes, argumentTypes, LanguageLevel.JDK_1_7);
        for (PsiTypeParameter typeParameter : typeParameters) {
            if (substitutor.getSubstitutionMap().containsKey(typeParameter) || (substitutor = this.inferFromContext(typeParameter, PsiUtil.getSmartReturnType(method), substitutor)).getSubstitutionMap().containsKey(typeParameter)) continue;
            substitutor = substitutor.put(typeParameter, null);
        }
        return partialSubstitutor.putAll(substitutor);
    }

    @Nullable
    private PsiType handleConversion(@Nullable PsiType paramType, @Nullable PsiType argType) {
        if (argType instanceof PsiClassType && SamConversionKt.isSamConversionAllowed(this.myPlace) && InheritanceUtil.isInheritor((PsiType)argType, (String)"groovy.lang.Closure") && !TypesUtil.isClassType(paramType, "groovy.lang.Closure")) {
            PsiType converted = this.handleConversionOfSAMType(paramType, (PsiClassType)argType);
            if (converted != null) {
                return converted;
            }
            return argType;
        }
        if (!TypesUtil.isAssignable(TypeConversionUtil.erasure((PsiType)paramType), argType, this.myPlace) && TypesUtil.isAssignableByMethodCallConversion(paramType, argType, this.myPlace)) {
            return paramType;
        }
        return argType;
    }

    @Nullable
    private PsiType handleConversionOfSAMType(@Nullable PsiType targetType, @NotNull PsiClassType closure) {
        if (closure == null) {
            SubstitutorComputer.$$$reportNull$$$0(6);
        }
        if (!(targetType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)targetType).resolveGenerics();
        PsiClass samClass = resolveResult.getElement();
        if (samClass == null) {
            return null;
        }
        PsiTypeParameter[] samClassTypeParameters = samClass.getTypeParameters();
        if (samClassTypeParameters.length == 0) {
            return null;
        }
        PsiMethod sam2 = SamConversionKt.findSingleAbstractMethod(samClass);
        if (sam2 == null) {
            return null;
        }
        PsiType samReturnType = sam2.getReturnType();
        if (samReturnType == null) {
            return null;
        }
        PsiType[] closureParameters = closure.getParameters();
        if (closureParameters.length != 1) {
            return null;
        }
        PsiSubstitutor substitutor = this.myHelper.inferTypeArguments(samClassTypeParameters, new PsiType[]{samReturnType}, closureParameters, LanguageLevel.JDK_1_8);
        if (substitutor.getSubstitutionMap().isEmpty()) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)this.myPlace.getProject()).createType(samClass, substitutor);
    }

    private PsiSubstitutor inferFromContext(@NotNull PsiTypeParameter typeParameter, @Nullable PsiType lType, @NotNull PsiSubstitutor substitutor) {
        if (typeParameter == null) {
            SubstitutorComputer.$$$reportNull$$$0(7);
        }
        if (substitutor == null) {
            SubstitutorComputer.$$$reportNull$$$0(8);
        }
        if (this.myPlace == null) {
            return substitutor;
        }
        PsiType inferred = this.myHelper.getSubstitutionForTypeParameter(typeParameter, lType, this.inferContextType(), false, LanguageLevel.JDK_1_7);
        if (inferred != PsiType.NULL) {
            return substitutor.put(typeParameter, inferred);
        }
        return substitutor;
    }

    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/SubstitutorComputer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "obtainSubstitutor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "inferMethodTypeParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "handleConversionOfSAMType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "inferFromContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

