/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.NotNullComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyMethodResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrMethodComparator;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.SubstitutorComputer;

public class MethodResolverProcessor
extends ResolverProcessor<GroovyMethodResult>
implements GrMethodComparator.Context {
    private final PsiType myThisType;
    @Nullable
    private final PsiType[] myArgumentTypes;
    private final boolean myAllVariants;
    private Set<GroovyMethodResult> myInapplicableCandidates;
    private final boolean myIsConstructor;
    private boolean myStopExecuting;
    private final SubstitutorComputer mySubstitutorComputer;

    public MethodResolverProcessor(@Nullable String name, @NotNull PsiElement place, boolean isConstructor, @Nullable PsiType thisType, @Nullable PsiType[] argumentTypes, @Nullable PsiType[] typeArguments) {
        if (place == null) {
            MethodResolverProcessor.$$$reportNull$$$0(0);
        }
        this(name, place, isConstructor, thisType, argumentTypes, typeArguments, false);
    }

    public MethodResolverProcessor(@Nullable String name, @NotNull PsiElement place, boolean isConstructor, @Nullable PsiType thisType, @Nullable PsiType[] argumentTypes, @Nullable PsiType[] typeArguments, boolean allVariants) {
        if (place == null) {
            MethodResolverProcessor.$$$reportNull$$$0(1);
        }
        super(name, ClassHint.RESOLVE_KINDS_METHOD_PROPERTY, place);
        this.myInapplicableCandidates = null;
        this.myStopExecuting = false;
        this.myIsConstructor = isConstructor;
        this.myThisType = thisType;
        this.mySubstitutorComputer = new SubstitutorComputer(this.myThisType, argumentTypes, typeArguments, this.myPlace, this.myPlace.getParent());
        PsiType[] psiTypeArray = this.myArgumentTypes = argumentTypes == null ? null : Arrays.copyOf(argumentTypes, argumentTypes.length);
        if (this.myArgumentTypes != null) {
            for (int i = 0; i < this.myArgumentTypes.length; ++i) {
                this.myArgumentTypes[i] = TypeConversionUtil.erasure((PsiType)this.myArgumentTypes[i]);
            }
        }
        this.myAllVariants = allVariants;
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            MethodResolverProcessor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            MethodResolverProcessor.$$$reportNull$$$0(3);
        }
        if (this.myStopExecuting) {
            return false;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor() != this.myIsConstructor) {
                return true;
            }
            PsiElement resolveContext = (PsiElement)state.get(ClassHint.RESOLVE_CONTEXT);
            SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
            PsiSubstitutor partialSubstitutor = MethodResolverProcessor.getSubstitutor(state);
            NotNullComputable substitutorComputer = () -> this.mySubstitutorComputer.obtainSubstitutor(partialSubstitutor, method, resolveContext);
            boolean isAccessible = this.isAccessible((PsiNamedElement)method);
            boolean isStaticsOK = this.isStaticsOK((PsiNamedElement)method, resolveContext, false);
            boolean isApplicable = PsiUtil.isApplicable(this.myArgumentTypes, method, partialSubstitutor, this.myPlace, true);
            boolean isValidResult = isStaticsOK && isAccessible && isApplicable;
            GroovyMethodResultImpl candidate = new GroovyMethodResultImpl(method, resolveContext, spreadState, partialSubstitutor, (NotNullComputable<PsiSubstitutor>)substitutorComputer, isAccessible, isStaticsOK, isValidResult);
            if (!this.myAllVariants && isValidResult) {
                this.addCandidate(candidate);
            } else {
                this.addInapplicableCandidate(candidate);
            }
        }
        return true;
    }

    protected boolean addInapplicableCandidate(@NotNull GroovyMethodResult candidate) {
        if (candidate == null) {
            MethodResolverProcessor.$$$reportNull$$$0(4);
        }
        if (this.myInapplicableCandidates == null) {
            this.myInapplicableCandidates = ContainerUtil.newLinkedHashSet();
        }
        return this.myInapplicableCandidates.add(candidate);
    }

    @NotNull
    protected static PsiSubstitutor getSubstitutor(@NotNull ResolveState state) {
        PsiSubstitutor substitutor;
        if (state == null) {
            MethodResolverProcessor.$$$reportNull$$$0(5);
        }
        if ((substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY)) == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            MethodResolverProcessor.$$$reportNull$$$0(6);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] getCandidates() {
        if (!this.myAllVariants && this.hasApplicableCandidates()) {
            GroovyResolveResult[] groovyResolveResultArray = this.filterCandidates();
            if (groovyResolveResultArray == null) {
                MethodResolverProcessor.$$$reportNull$$$0(7);
            }
            return groovyResolveResultArray;
        }
        if (this.myInapplicableCandidates != null && !this.myInapplicableCandidates.isEmpty()) {
            Set<GroovyMethodResult> resultSet = this.myAllVariants ? this.myInapplicableCandidates : this.filterCorrectParameterCount(this.myInapplicableCandidates);
            GroovyResolveResult[] groovyResolveResultArray = ResolveUtil.filterSameSignatureCandidates(resultSet);
            if (groovyResolveResultArray == null) {
                MethodResolverProcessor.$$$reportNull$$$0(8);
            }
            return groovyResolveResultArray;
        }
        if (GroovyResolveResult.EMPTY_ARRAY == null) {
            MethodResolverProcessor.$$$reportNull$$$0(9);
        }
        return GroovyResolveResult.EMPTY_ARRAY;
    }

    private Set<GroovyMethodResult> filterCorrectParameterCount(Set<GroovyMethodResult> candidates) {
        if (this.myArgumentTypes == null) {
            return candidates;
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (GroovyMethodResult candidate : candidates) {
            if (candidate.getElement().getParameterList().getParametersCount() != this.myArgumentTypes.length) continue;
            result.add(candidate);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return candidates;
    }

    private GroovyResolveResult[] filterCandidates() {
        List<GroovyResolveResult> array = this.getCandidatesInternal();
        if (array.size() == 1) {
            return array.toArray(new GroovyResolveResult[array.size()]);
        }
        ArrayList result = ContainerUtil.newArrayList();
        Iterator itr = array.iterator();
        result.add(itr.next());
        block0: while (itr.hasNext()) {
            GroovyMethodResult resolveResult = (GroovyMethodResult)itr.next();
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                GroovyMethodResult otherResolveResult = (GroovyMethodResult)iterator.next();
                int res = GrMethodComparator.compareMethods(resolveResult, otherResolveResult, this);
                if (res > 0) continue block0;
                if (res >= 0) continue;
                iterator.remove();
            }
            result.add(resolveResult);
        }
        return result.toArray(new GroovyResolveResult[result.size()]);
    }

    @Override
    public boolean hasCandidates() {
        return this.hasApplicableCandidates() || this.myInapplicableCandidates != null && !this.myInapplicableCandidates.isEmpty();
    }

    public boolean hasApplicableCandidates() {
        return super.hasCandidates();
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        return this.myArgumentTypes;
    }

    @Override
    @Nullable
    public PsiType[] getTypeArguments() {
        return this.mySubstitutorComputer.getTypeArguments();
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            MethodResolverProcessor.$$$reportNull$$$0(10);
        }
        super.handleEvent(event, associated);
        if (JavaScopeProcessorEvent.CHANGE_LEVEL == event && this.hasApplicableCandidates()) {
            this.myStopExecuting = true;
        }
    }

    @Override
    @Nullable
    public PsiType getThisType() {
        return this.myThisType;
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        PsiElement psiElement = this.myPlace;
        if (psiElement == null) {
            MethodResolverProcessor.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    @Override
    public boolean isConstructor() {
        return this.myIsConstructor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/MethodResolverProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/MethodResolverProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addInapplicableCandidate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

