/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.GrMethodComparator;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;

class GroovyResolverProcessorImpl
extends GroovyResolverProcessor
implements GrMethodComparator.Context {
    private final boolean myIsPartOfFqn;

    GroovyResolverProcessorImpl(@NotNull GrReferenceExpression ref, @NotNull EnumSet<GroovyResolveKind> kinds, boolean forceRValue) {
        if (ref == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(0);
        }
        if (kinds == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(1);
        }
        super(ref, kinds, null, forceRValue);
        this.myIsPartOfFqn = ResolveUtil.isPartOfFQN(ref);
    }

    @Override
    @NotNull
    public List<GroovyResolveResult> getCandidates() {
        PsiElement element;
        GroovyResolveResult candidate;
        List<GroovyResolveResult> candidates;
        if (this.myAcceptableKinds.contains((Object)GroovyResolveKind.PACKAGE) && this.myIsPartOfFqn && !(candidates = this.getCandidates(GroovyResolveKind.PACKAGE)).isEmpty()) {
            candidate = candidates.get(0);
            element = candidate.getElement();
            assert (element instanceof PsiPackage);
            GrReferenceExpressionImpl topRef = GroovyResolverProcessorImpl.getContextReferenceExpression(this.myRef);
            if (topRef != null) {
                String fqn = topRef.getTextSkipWhiteSpaceAndComments();
                if (JavaPsiFacade.getInstance((Project)this.myRef.getProject()).findClass(fqn, this.myRef.getResolveScope()) != null) {
                    List<GroovyResolveResult> list = candidates;
                    if (list == null) {
                        GroovyResolverProcessorImpl.$$$reportNull$$$0(2);
                    }
                    return list;
                }
            }
        }
        if (!(candidates = this.getCandidates(GroovyResolveKind.VARIABLE)).isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.METHOD);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> results2 = this.filterMethodCandidates(candidates);
            List<GroovyResolveResult> list = this.myRef.hasMemberPointer() ? ResolveUtil.collapseReflectedMethods(results2) : results2;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.ENUM_CONST);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.FIELD);
        if (!candidates.isEmpty()) {
            assert (candidates.size() == 1);
            candidate = candidates.get(0);
            element = candidate.getElement();
            if (element instanceof PsiField) {
                PsiClass containingClass = ((PsiField)element).getContainingClass();
                if (containingClass != null && PsiUtil.getContextClass(this.myRef) == containingClass) {
                    List<GroovyResolveResult> list = candidates;
                    if (list == null) {
                        GroovyResolverProcessorImpl.$$$reportNull$$$0(6);
                    }
                    return list;
                }
            } else if (!(element instanceof GrBindingVariable)) {
                List<GroovyResolveResult> list = candidates;
                if (list == null) {
                    GroovyResolverProcessorImpl.$$$reportNull$$$0(7);
                }
                return list;
            }
        }
        if (this.myIsPartOfFqn && !(candidates = this.getCandidates(GroovyResolveKind.PACKAGE, GroovyResolveKind.CLASS)).isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.PROPERTY);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates.size() <= 1 ? candidates : ContainerUtil.newSmartList((Object)candidates.get(0));
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.FIELD);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.PACKAGE, GroovyResolveKind.CLASS);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.PROPERTY);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        candidates = this.getCandidates(GroovyResolveKind.BINDING);
        if (!candidates.isEmpty()) {
            List<GroovyResolveResult> list = candidates;
            if (list == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        for (GroovyResolveKind kind : this.myAcceptableKinds) {
            Collection results3 = this.myInapplicableCandidates.get((Object)kind);
            if (results3.isEmpty()) continue;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])ResolveUtil.filterSameSignatureCandidates(this.filterCorrectParameterCount(results3)));
            if (arrayList == null) {
                GroovyResolverProcessorImpl.$$$reportNull$$$0(14);
            }
            return arrayList;
        }
        List<GroovyResolveResult> list = Collections.emptyList();
        if (list == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static GrReferenceExpressionImpl getContextReferenceExpression(GrReferenceExpression ref) {
        PsiElement firstNonReferenceExprParent = PsiTreeUtil.skipParentsOfType((PsiElement)ref, (Class[])new Class[]{GrReferenceExpressionImpl.class});
        return (GrReferenceExpressionImpl)PsiTreeUtil.findFirstParent((PsiElement)ref, parent -> parent.getParent() == firstNonReferenceExprParent && parent instanceof GrReferenceExpressionImpl);
    }

    private List<GroovyResolveResult> filterCorrectParameterCount(Collection<GroovyResolveResult> candidates) {
        PsiType[] argumentTypes = (PsiType[])this.myArgumentTypes.getValue();
        if (argumentTypes == null) {
            return ContainerUtil.newArrayList(candidates);
        }
        List result = ContainerUtil.newSmartList();
        for (GroovyResolveResult candidate : candidates) {
            if (candidate instanceof GroovyMethodResult) {
                if (((GroovyMethodResult)candidate).getElement().getParameterList().getParametersCount() != argumentTypes.length) continue;
                result.add(candidate);
                continue;
            }
            result.add(candidate);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return ContainerUtil.newArrayList(candidates);
    }

    private List<GroovyResolveResult> filterMethodCandidates(List<GroovyResolveResult> candidates) {
        if (candidates.size() <= 1) {
            return candidates;
        }
        ArrayList results2 = ContainerUtil.newArrayList();
        Iterator<GroovyResolveResult> itr = candidates.iterator();
        results2.add(itr.next());
        block0: while (itr.hasNext()) {
            GroovyResolveResult resolveResult = itr.next();
            if (resolveResult instanceof GroovyMethodResult) {
                Iterator iterator = results2.iterator();
                while (iterator.hasNext()) {
                    GroovyResolveResult otherResolveResult = (GroovyResolveResult)iterator.next();
                    if (!(otherResolveResult instanceof GroovyMethodResult)) continue;
                    int res = GrMethodComparator.compareMethods((GroovyMethodResult)resolveResult, (GroovyMethodResult)otherResolveResult, this);
                    if (res > 0) continue block0;
                    if (res >= 0) continue;
                    iterator.remove();
                }
            }
            results2.add(resolveResult);
        }
        return results2;
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        return (PsiType[])this.myArgumentTypes.getValue();
    }

    @Override
    @Nullable
    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    @Override
    @Nullable
    public PsiType getThisType() {
        return this.myThisType;
    }

    @Override
    @NotNull
    public PsiElement getPlace() {
        GrReferenceExpression grReferenceExpression = this.myRef;
        if (grReferenceExpression == null) {
            GroovyResolverProcessorImpl.$$$reportNull$$$0(16);
        }
        return grReferenceExpression;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

