/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyAllVariantsProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolveKind;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessorImpl;

public final class GroovyResolverProcessorBuilder {
    private boolean myIncomplete = false;
    private boolean myAllVariants = false;
    private GrExpression myUpToArgument = null;
    private boolean myForceRValue = false;

    @NotNull
    public GroovyResolverProcessor build(GrReferenceExpression ref) {
        EnumSet<GroovyResolveKind> kinds;
        EnumSet<GroovyResolveKind> enumSet = kinds = this.myIncomplete ? EnumSet.allOf(GroovyResolveKind.class) : GroovyResolverProcessorBuilder.computeKinds(ref);
        if (this.myAllVariants) {
            GroovyAllVariantsProcessor groovyAllVariantsProcessor = new GroovyAllVariantsProcessor(ref, kinds, this.myUpToArgument);
            if (groovyAllVariantsProcessor == null) {
                GroovyResolverProcessorBuilder.$$$reportNull$$$0(0);
            }
            return groovyAllVariantsProcessor;
        }
        GroovyResolverProcessorImpl groovyResolverProcessorImpl = new GroovyResolverProcessorImpl(ref, kinds, this.myForceRValue);
        if (groovyResolverProcessorImpl == null) {
            GroovyResolverProcessorBuilder.$$$reportNull$$$0(1);
        }
        return groovyResolverProcessorImpl;
    }

    @NotNull
    public static GroovyResolverProcessorBuilder builder() {
        GroovyResolverProcessorBuilder groovyResolverProcessorBuilder = new GroovyResolverProcessorBuilder();
        if (groovyResolverProcessorBuilder == null) {
            GroovyResolverProcessorBuilder.$$$reportNull$$$0(2);
        }
        return groovyResolverProcessorBuilder;
    }

    public GroovyResolverProcessorBuilder setIncomplete(boolean incomplete) {
        this.myIncomplete = incomplete;
        return this;
    }

    @NotNull
    public GroovyResolverProcessorBuilder setAllVariants(boolean allVariants) {
        this.myAllVariants = allVariants;
        GroovyResolverProcessorBuilder groovyResolverProcessorBuilder = this;
        if (groovyResolverProcessorBuilder == null) {
            GroovyResolverProcessorBuilder.$$$reportNull$$$0(3);
        }
        return groovyResolverProcessorBuilder;
    }

    @NotNull
    public GroovyResolverProcessorBuilder setUpToArgument(GrExpression upToArgument) {
        this.myUpToArgument = upToArgument;
        GroovyResolverProcessorBuilder groovyResolverProcessorBuilder = this;
        if (groovyResolverProcessorBuilder == null) {
            GroovyResolverProcessorBuilder.$$$reportNull$$$0(4);
        }
        return groovyResolverProcessorBuilder;
    }

    @NotNull
    public GroovyResolverProcessorBuilder setForceRValue(boolean forceRValue) {
        this.myForceRValue = forceRValue;
        GroovyResolverProcessorBuilder groovyResolverProcessorBuilder = this;
        if (groovyResolverProcessorBuilder == null) {
            GroovyResolverProcessorBuilder.$$$reportNull$$$0(5);
        }
        return groovyResolverProcessorBuilder;
    }

    @NotNull
    private static EnumSet<GroovyResolveKind> computeKinds(@NotNull GrReferenceExpression ref) {
        if (ref == null) {
            GroovyResolverProcessorBuilder.$$$reportNull$$$0(6);
        }
        if (ref.hasAt()) {
            EnumSet<GroovyResolveKind> enumSet = EnumSet.of(GroovyResolveKind.FIELD);
            if (enumSet == null) {
                GroovyResolverProcessorBuilder.$$$reportNull$$$0(7);
            }
            return enumSet;
        }
        if (ref.hasMemberPointer()) {
            EnumSet<GroovyResolveKind> enumSet = EnumSet.of(GroovyResolveKind.METHOD);
            if (enumSet == null) {
                GroovyResolverProcessorBuilder.$$$reportNull$$$0(8);
            }
            return enumSet;
        }
        EnumSet<GroovyResolveKind> result = EnumSet.allOf(GroovyResolveKind.class);
        if (!ResolveUtil.canBeClass(ref)) {
            result.remove((Object)GroovyResolveKind.CLASS);
        }
        if (!ResolveUtil.canBePackage(ref)) {
            result.remove((Object)GroovyResolveKind.PACKAGE);
        }
        if (ref.isQualified()) {
            result.remove((Object)GroovyResolveKind.BINDING);
        }
        if (!(ref.getParent() instanceof GrMethodCall)) {
            result.remove((Object)GroovyResolveKind.METHOD);
        }
        EnumSet<GroovyResolveKind> enumSet = result;
        if (enumSet == null) {
            GroovyResolverProcessorBuilder.$$$reportNull$$$0(9);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setAllVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpToArgument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setForceRValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/processors/GroovyResolverProcessorBuilder";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeKinds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeKinds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

