/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ClassUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.transformations.TransformationUtilKt;

public abstract class NonCodeMembersContributor {
    public static final ExtensionPointName<NonCodeMembersContributor> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.membersContributor");
    private static volatile MultiMap<String, NonCodeMembersContributor> ourClassSpecifiedContributors;
    private static NonCodeMembersContributor[] ourAllTypeContributors;

    public void processDynamicElements(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(3);
        }
        throw new RuntimeException("One of two 'processDynamicElements()' methods must be implemented");
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(5);
        }
        if (place == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(6);
        }
        if (state == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(7);
        }
        this.processDynamicElements(qualifierType, processor, place, state);
    }

    @Nullable
    protected String getParentClassName() {
        return null;
    }

    private static void ensureInit() {
        if (ourClassSpecifiedContributors != null) {
            return;
        }
        MultiMap contributorMap = new MultiMap();
        for (NonCodeMembersContributor contributor : (NonCodeMembersContributor[])EP_NAME.getExtensions()) {
            contributorMap.putValue((Object)contributor.getParentClassName(), (Object)contributor);
        }
        Collection allTypeContributors = contributorMap.remove(null);
        ourAllTypeContributors = allTypeContributors.toArray(new NonCodeMembersContributor[allTypeContributors.size()]);
        ourClassSpecifiedContributors = contributorMap;
    }

    public static boolean runContributors(@NotNull PsiType qualifierType, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(9);
        }
        if (place == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(10);
        }
        if (state == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(11);
        }
        NonCodeMembersContributor.ensureInit();
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)qualifierType);
        if (TransformationUtilKt.isUnderTransformation(aClass)) {
            return true;
        }
        List allDelegates = ContainerUtil.map(GroovyResolverProcessor.allProcessors(processor), MyDelegatingScopeProcessor::new);
        if (aClass != null) {
            for (String superClassName : ClassUtil.getSuperClassesWithCache(aClass).keySet()) {
                for (NonCodeMembersContributor enhancer : ourClassSpecifiedContributors.get((Object)superClassName)) {
                    if (NonCodeMembersContributor.invokeContributor(qualifierType, place, state, aClass, allDelegates, enhancer)) continue;
                    return false;
                }
            }
        }
        for (NonCodeMembersContributor contributor : ourAllTypeContributors) {
            if (NonCodeMembersContributor.invokeContributor(qualifierType, place, state, aClass, allDelegates, contributor)) continue;
            return false;
        }
        return GroovyDslFileIndex.processExecutors(qualifierType, place, processor, state);
    }

    private static boolean invokeContributor(@NotNull PsiType qualifierType, @NotNull PsiElement place, @NotNull ResolveState state, PsiClass aClass, List<MyDelegatingScopeProcessor> allDelegates, NonCodeMembersContributor enhancer) {
        if (qualifierType == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(12);
        }
        if (place == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(13);
        }
        if (state == null) {
            NonCodeMembersContributor.$$$reportNull$$$0(14);
        }
        ProgressManager.checkCanceled();
        for (MyDelegatingScopeProcessor delegatingProcessor : allDelegates) {
            enhancer.processDynamicElements(qualifierType, aClass, (PsiScopeProcessor)delegatingProcessor, place, state);
            if (delegatingProcessor.wantMore) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDynamicElements";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "runContributors";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeContributor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyDelegatingScopeProcessor
    extends DelegatingScopeProcessor {
        public boolean wantMore = true;

        public MyDelegatingScopeProcessor(PsiScopeProcessor delegate) {
            super(delegate);
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                MyDelegatingScopeProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                MyDelegatingScopeProcessor.$$$reportNull$$$0(1);
            }
            if (!this.wantMore) {
                return false;
            }
            this.wantMore = super.execute(element, state);
            return this.wantMore;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor$MyDelegatingScopeProcessor";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

