/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBuiltinTypeClassExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\u001f\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u0004*\u00020\u0002\u001a\f\u0010\u000e\u001a\u00020\u0004*\u00020\u000fH\u0002\u001a!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"advancedResolve", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;", "rhs", "", "getArgumentListType", "Lcom/intellij/psi/PsiType;", "getArgumentTypes", "", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;Z)[Lcom/intellij/psi/PsiType;", "getArrayClassType", "getSimpleArrayAccessType", "isClassLiteral", "isSimpleArrayAccess", "isSingleCharLiteral", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "multiResolve", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;Z)[Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "groovy-psi"})
@JvmName(name="GroovyIndexPropertyUtil")
public final class GroovyIndexPropertyUtil {
    public static final boolean isSimpleArrayAccess(@NotNull GrIndexProperty $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return GroovyIndexPropertyUtil.getSimpleArrayAccessType($receiver) != null;
    }

    @Nullable
    public static final PsiType getSimpleArrayAccessType(@NotNull GrIndexProperty $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiType psiType = $receiver.getInvokedExpression().getType();
        if (!(psiType instanceof PsiArrayType)) {
            psiType = null;
        }
        PsiArrayType psiArrayType = (PsiArrayType)psiType;
        if (psiArrayType == null) {
            return null;
        }
        PsiArrayType thisType = psiArrayType;
        Object object = ArraysKt.singleOrNull((Object[])$receiver.getArgumentList().getAllArguments());
        if (!(object instanceof GrExpression)) {
            object = null;
        }
        GrExpression grExpression = (GrExpression)object;
        if (grExpression == null) {
            return null;
        }
        GrExpression argument = grExpression;
        if (TypesUtil.isAssignableByMethodCallConversion((PsiType)PsiType.INT, argument.getType(), $receiver) || GroovyIndexPropertyUtil.isSingleCharLiteral(argument)) {
            return thisType.getComponentType();
        }
        return null;
    }

    private static final boolean isSingleCharLiteral(@NotNull GrExpression $receiver) {
        if (!($receiver instanceof GrLiteral)) {
            return false;
        }
        Object object = ((GrLiteral)$receiver).getValue();
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return false;
        }
        String value = string;
        return value.length() == 1;
    }

    public static final boolean isClassLiteral(@NotNull GrIndexProperty $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GrExpression invoked = $receiver;
        while (true) {
            GrExpression grExpression;
            if ((grExpression = invoked) instanceof GrBuiltinTypeClassExpression) {
                return true;
            }
            if (grExpression instanceof GrReferenceExpression) {
                return ((GrReferenceExpression)invoked).resolve() instanceof PsiClass;
            }
            if (!(grExpression instanceof GrIndexProperty)) break;
            Object[] objectArray = ((GrIndexProperty)invoked).getArgumentList().getAllArguments();
            Object[] objectArray2 = objectArray;
            if (!(objectArray2.length == 0)) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((GrIndexProperty)invoked).getInvokedExpression(), (String)"invoked.invokedExpression");
        }
        return false;
    }

    @Nullable
    public static final PsiType getArrayClassType(@NotNull GrIndexProperty $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiType psiType = ResolveUtil.getClassReferenceFromExpression($receiver);
        if (psiType == null) {
            return null;
        }
        PsiType arrayTypeBase = psiType;
        return TypesUtil.createJavaLangClassType(arrayTypeBase, $receiver.getProject(), $receiver.getResolveScope());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiType getArgumentListType(@NotNull GrIndexProperty $receiver) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GrArgumentList argList = $receiver.getArgumentList();
        Object object = argList.getNamedArguments();
        Object[] objectArray = object;
        if (!(objectArray.length == 0)) {
            return null;
        }
        GrExpression grExpression = (GrExpression)ArraysKt.singleOrNull((Object[])argList.getExpressionArguments());
        if (grExpression != null) {
            Object it = object = grExpression;
            return it.getType();
        }
        Object $receiver$iv = argList.getExpressionArguments();
        Object[] $i$a$1$let = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            GrExpression grExpression2 = (GrExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            PsiType psiType = it.getType();
            collection.add(psiType);
        }
        $receiver$iv = (List)destination$iv$iv;
        Object thisCollection$iv = $receiver$iv;
        PsiType[] psiTypeArray = thisCollection$iv.toArray(new PsiType[thisCollection$iv.size()]);
        if (psiTypeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        PsiType[] types = psiTypeArray;
        return (PsiType)new GrImmediateTupleType(types, JavaPsiFacade.getInstance((Project)$receiver.getProject()), $receiver.getResolveScope());
    }

    @Nullable
    public static final PsiType[] getArgumentTypes(@NotNull GrIndexProperty $receiver, boolean rhs) {
        GrAssignmentExpression grAssignmentExpression;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiType psiType = GroovyIndexPropertyUtil.getArgumentListType($receiver);
        if (psiType == null) {
            return null;
        }
        PsiType argumentListType = psiType;
        if (rhs) {
            return new PsiType[]{argumentListType};
        }
        PsiElement psiElement = $receiver.getParent();
        if (!(psiElement instanceof GrAssignmentExpression)) {
            psiElement = null;
        }
        if ((grAssignmentExpression = (GrAssignmentExpression)psiElement) == null || (grAssignmentExpression = grAssignmentExpression.getType()) == null) {
            return null;
        }
        GrAssignmentExpression rType = grAssignmentExpression;
        PsiType[] psiTypeArray = new PsiType[2];
        psiTypeArray[0] = argumentListType;
        GrAssignmentExpression grAssignmentExpression2 = rType;
        Intrinsics.checkExpressionValueIsNotNull((Object)grAssignmentExpression2, (String)"rType");
        psiTypeArray[1] = grAssignmentExpression2;
        return psiTypeArray;
    }

    @JvmOverloads
    @NotNull
    public static final GroovyResolveResult[] multiResolve(@NotNull GrIndexProperty $receiver, boolean rhs) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = rhs ? $receiver.getRValueReference() : $receiver.getLValueReference();
        if (object == null || (object = object.multiResolve(false)) == null) {
            object = GroovyResolveResult.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)GroovyResolveResult.EMPTY_ARRAY, (String)"GroovyResolveResult.EMPTY_ARRAY");
        }
        return object;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ GroovyResolveResult[] multiResolve$default(GrIndexProperty grIndexProperty, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return GroovyIndexPropertyUtil.multiResolve(grIndexProperty, bl);
    }

    @JvmOverloads
    @NotNull
    public static final GroovyResolveResult[] multiResolve(@NotNull GrIndexProperty $receiver) {
        return GroovyIndexPropertyUtil.multiResolve$default($receiver, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public static final GroovyResolveResult advancedResolve(@NotNull GrIndexProperty $receiver, boolean rhs) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        GroovyResolveResult groovyResolveResult = PsiImplUtil.extractUniqueResult(GroovyIndexPropertyUtil.multiResolve($receiver, rhs));
        Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"PsiImplUtil.extractUniqueResult(multiResolve(rhs))");
        return groovyResolveResult;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ GroovyResolveResult advancedResolve$default(GrIndexProperty grIndexProperty, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return GroovyIndexPropertyUtil.advancedResolve(grIndexProperty, bl);
    }

    @JvmOverloads
    @NotNull
    public static final GroovyResolveResult advancedResolve(@NotNull GrIndexProperty $receiver) {
        return GroovyIndexPropertyUtil.advancedResolve$default($receiver, false, 1, null);
    }
}

