/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.patterns.GroovyExpressionPattern;

public class GroovyMethodCallPattern
extends GroovyExpressionPattern<GrCallExpression, GroovyMethodCallPattern> {
    GroovyMethodCallPattern() {
        super(GrCallExpression.class);
    }

    public GroovyMethodCallPattern withArguments(final ElementPattern<? extends GrExpression> ... arguments) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>("withArguments"){

            public boolean accepts(@NotNull GrCallExpression callExpression, ProcessingContext context) {
                GrArgumentList argumentList;
                if (callExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((argumentList = callExpression.getArgumentList()) == null) {
                    return false;
                }
                GrExpression[] actualArguments = argumentList.getExpressionArguments();
                if (arguments.length != actualArguments.length) {
                    return false;
                }
                for (int i = 0; i < actualArguments.length; ++i) {
                    if (arguments[i].accepts((Object)actualArguments[i], context)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern$1", "accepts"));
            }
        });
    }

    public GroovyMethodCallPattern withMethodName(@NotNull String methodName) {
        if (methodName == null) {
            GroovyMethodCallPattern.$$$reportNull$$$0(0);
        }
        return this.withMethodName((ElementPattern<? extends String>)StandardPatterns.string().equalTo((Object)methodName));
    }

    public GroovyMethodCallPattern withMethodName(final ElementPattern<? extends String> methodName) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>("withMethodName"){

            public boolean accepts(@NotNull GrCallExpression callExpression, ProcessingContext context) {
                if (callExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(callExpression instanceof GrMethodCall)) {
                    return false;
                }
                GrExpression expression = ((GrMethodCall)callExpression).getInvokedExpression();
                if (!(expression instanceof GrReferenceExpression)) {
                    return false;
                }
                GrReferenceExpression refExpression = (GrReferenceExpression)expression;
                return methodName.accepts((Object)refExpression.getReferenceName(), context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern$2", "accepts"));
            }
        });
    }

    public GroovyMethodCallPattern withMethod(final ElementPattern<? extends PsiMethod> methodPattern) {
        return (GroovyMethodCallPattern)this.with((PatternCondition)new PatternCondition<GrCallExpression>("methodCall"){

            public boolean accepts(@NotNull GrCallExpression callExpression, ProcessingContext context) {
                if (callExpression == null) {
                    3.$$$reportNull$$$0(0);
                }
                for (GroovyResolveResult result : callExpression.getCallVariants(null)) {
                    if (!methodPattern.accepts((Object)result.getElement(), context)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern$3", "accepts"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/plugins/groovy/lang/psi/patterns/GroovyMethodCallPattern", "withMethodName"));
    }
}

