/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.toplevel.imports;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrImportStatementStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.processors.StaticMembersFilteringProcessor;

public class GrImportStatementImpl
extends GrStubElementBase<GrImportStatementStub>
implements GrImportStatement,
StubBasedPsiElement<GrImportStatementStub> {
    public GrImportStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrImportStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public GrImportStatementImpl(GrImportStatementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitImportStatement(this);
    }

    public String toString() {
        return "Import statement";
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GrImportStatementImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            GrImportStatementImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            GrImportStatementImpl.$$$reportNull$$$0(3);
        }
        if (!GrImportStatementImpl.shouldProcess(processor)) {
            return true;
        }
        if (this.isAncestor(place)) {
            return true;
        }
        if (this.isStatic() && lastParent instanceof GrImportStatement) {
            return true;
        }
        return !(this.isOnDemand() ? !this.processDeclarationsForMultipleElements(processor, lastParent, place, state) : !this.processDeclarationsForSingleElement(processor, lastParent, place, state));
    }

    private static boolean shouldProcess(PsiScopeProcessor processor) {
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        return classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS) || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD) || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD) || classHint.shouldProcess(ElementClassHint.DeclarationKind.ENUM_CONST);
    }

    private boolean isAncestor(@Nullable PsiElement place) {
        while (place instanceof GrCodeReferenceElement) {
            PsiElement parent = place.getParent();
            if (parent == this) {
                return true;
            }
            place = parent;
        }
        return false;
    }

    private boolean processDeclarationsForSingleElement(@NotNull PsiScopeProcessor processor, @Nullable PsiElement lastParent, @NotNull PsiElement place, @NotNull ResolveState state) {
        String name;
        if (processor == null) {
            GrImportStatementImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            GrImportStatementImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            GrImportStatementImpl.$$$reportNull$$$0(6);
        }
        if ((name = this.getImportedName()) == null) {
            return true;
        }
        if (this.isStatic()) {
            return this.processSingleStaticImport(processor, state, name, lastParent, place);
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        if (nameHint == null || name.equals(nameHint.getName(state))) {
            return this.processSingleClassImport(processor, state);
        }
        return true;
    }

    @Nullable
    private PsiClass resolveQualifier() {
        return (PsiClass)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            GrCodeReferenceElement reference = this.getImportReference();
            GrCodeReferenceElement qualifier = reference == null ? null : (GrCodeReferenceElement)reference.getQualifier();
            PsiElement target = qualifier == null ? null : qualifier.resolve();
            PsiClass clazz = target instanceof PsiClass ? (PsiClass)target : null;
            return CachedValueProvider.Result.create((Object)clazz, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, this});
        });
    }

    private boolean processSingleStaticImport(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull String importedName, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        GrCodeReferenceElement ref;
        if (processor == null) {
            GrImportStatementImpl.$$$reportNull$$$0(7);
        }
        if (state == null) {
            GrImportStatementImpl.$$$reportNull$$$0(8);
        }
        if (importedName == null) {
            GrImportStatementImpl.$$$reportNull$$$0(9);
        }
        if (place == null) {
            GrImportStatementImpl.$$$reportNull$$$0(10);
        }
        if ((ref = this.getImportReference()) == null) {
            return true;
        }
        PsiClass clazz = this.resolveQualifier();
        if (clazz == null) {
            return true;
        }
        state = state.put(ClassHint.RESOLVE_CONTEXT, (Object)this);
        String refName = ref.getReferenceName();
        if (refName == null) {
            return true;
        }
        Iterable<Pair<String, String>> namesMapping = GrImportStatementImpl.namesMapping(importedName, refName);
        for (PsiScopeProcessor each : GroovyResolverProcessor.allProcessors(processor)) {
            String hintName = ResolveUtil.getNameHint(each);
            for (Pair<String, String> names : namesMapping) {
                StaticMembersFilteringProcessor delegate;
                if (hintName != null && !hintName.equals(names.first) || clazz.processDeclarations((PsiScopeProcessor)(delegate = new StaticMembersFilteringProcessor(each, (String)names.second)), state, lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }

    private static Iterable<Pair<String, String>> namesMapping(@NotNull String importedName, @NotNull String refName) {
        if (importedName == null) {
            GrImportStatementImpl.$$$reportNull$$$0(11);
        }
        if (refName == null) {
            GrImportStatementImpl.$$$reportNull$$$0(12);
        }
        if (importedName.equals(refName)) {
            Iterable<String> importedNames = GrImportStatementImpl.names(importedName);
            return ContainerUtil.zip(importedNames, importedNames);
        }
        return ContainerUtil.zip(GrImportStatementImpl.names(importedName), GrImportStatementImpl.names(refName));
    }

    private static Iterable<String> names(@NotNull String importedName) {
        if (importedName == null) {
            GrImportStatementImpl.$$$reportNull$$$0(13);
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(importedName);
        result.add(GroovyPropertyUtils.getGetterNameNonBoolean(importedName));
        result.add(GroovyPropertyUtils.getGetterNameBoolean(importedName));
        result.add(GroovyPropertyUtils.getSetterName(importedName));
        return result;
    }

    private boolean processSingleClassImport(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (processor == null) {
            GrImportStatementImpl.$$$reportNull$$$0(14);
        }
        if (state == null) {
            GrImportStatementImpl.$$$reportNull$$$0(15);
        }
        if (!ResolveUtil.shouldProcessClasses((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            return true;
        }
        GrCodeReferenceElement ref = this.getImportReference();
        if (ref == null) {
            return true;
        }
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiClass)) {
            return true;
        }
        if (!this.isAliasedImport() && this.isFromSamePackage((PsiClass)resolved)) {
            return true;
        }
        return processor.execute(resolved, state.put(ClassHint.RESOLVE_CONTEXT, (Object)this));
    }

    private boolean isFromSamePackage(@NotNull PsiClass resolved) {
        if (resolved == null) {
            GrImportStatementImpl.$$$reportNull$$$0(16);
        }
        String qualifiedName = resolved.getQualifiedName();
        String packageName = ((GroovyFile)this.getContainingFile()).getPackageName();
        String assumed = packageName + '.' + resolved.getName();
        return !packageName.isEmpty() && assumed.equals(qualifiedName);
    }

    private boolean processDeclarationsForMultipleElements(@NotNull PsiScopeProcessor processor, @Nullable PsiElement lastParent, @NotNull PsiElement place, @NotNull ResolveState state) {
        PsiPackage aPackage;
        String qName;
        GrCodeReferenceElement ref;
        if (processor == null) {
            GrImportStatementImpl.$$$reportNull$$$0(17);
        }
        if (place == null) {
            GrImportStatementImpl.$$$reportNull$$$0(18);
        }
        if (state == null) {
            GrImportStatementImpl.$$$reportNull$$$0(19);
        }
        if ((ref = this.getImportReference()) == null) {
            return true;
        }
        if (this.isStatic()) {
            PsiElement resolved = ref.resolve();
            if (resolved instanceof PsiClass) {
                state = state.put(ClassHint.RESOLVE_CONTEXT, (Object)this);
                PsiClass clazz = (PsiClass)resolved;
                for (PsiScopeProcessor each : GroovyResolverProcessor.allProcessors(processor)) {
                    if (clazz.processDeclarations((PsiScopeProcessor)new DelegatingScopeProcessor(each){

                        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (state == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (element instanceof PsiMember && ((PsiMember)element).hasModifierProperty("static")) {
                                return super.execute(element, state);
                            }
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "element";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "state";
                                    break;
                                }
                            }
                            objectArray[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl$1";
                            objectArray[2] = "execute";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }, state, lastParent, place)) continue;
                    return false;
                }
            }
        } else if (ResolveUtil.shouldProcessClasses((ElementClassHint)processor.getHint(ElementClassHint.KEY)) && (qName = PsiUtil.getQualifiedReferenceText(ref)) != null && (aPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(qName)) != null && !((GroovyFile)this.getContainingFile()).getPackageName().equals(aPackage.getQualifiedName()) && !aPackage.processDeclarations(processor, state = state.put(ClassHint.RESOLVE_CONTEXT, (Object)this), lastParent, place)) {
            return false;
        }
        return true;
    }

    @Override
    public GrCodeReferenceElement getImportReference() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getReference();
        }
        return (GrCodeReferenceElement)this.findChildByType(GroovyElementTypes.REFERENCE_ELEMENT);
    }

    @Override
    @Nullable
    public String getImportedName() {
        if (this.isOnDemand()) {
            return null;
        }
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            String name = stub.getAliasName();
            if (name != null) {
                return name;
            }
            String referenceText = stub.getReferenceText();
            if (referenceText == null) {
                return null;
            }
            return StringUtil.getShortName((String)referenceText);
        }
        PsiElement aliasNameElement = this.getAliasNameElement();
        if (aliasNameElement != null) {
            return aliasNameElement.getText();
        }
        GrCodeReferenceElement ref = this.getImportReference();
        return ref == null ? null : ref.getReferenceName();
    }

    @Override
    public boolean isStatic() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.isStatic();
        }
        return this.findChildByType(GroovyTokenTypes.kSTATIC) != null;
    }

    @Override
    public boolean isAliasedImport() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.getAliasName() != null;
        }
        return this.getAliasNameElement() != null;
    }

    @Override
    public boolean isOnDemand() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            return stub.isOnDemand();
        }
        return this.findChildByType(GroovyTokenTypes.mSTAR) != null;
    }

    @Override
    @NotNull
    public GrModifierList getAnnotationList() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            GrModifierList grModifierList = (GrModifierList)ObjectUtils.assertNotNull((Object)this.getStubOrPsiChild(GroovyElementTypes.MODIFIERS));
            if (grModifierList == null) {
                GrImportStatementImpl.$$$reportNull$$$0(20);
            }
            return grModifierList;
        }
        GrModifierList grModifierList = (GrModifierList)this.findNotNullChildByClass(GrModifierList.class);
        if (grModifierList == null) {
            GrImportStatementImpl.$$$reportNull$$$0(21);
        }
        return grModifierList;
    }

    @Override
    @Nullable
    public PsiClass resolveTargetClass() {
        GrCodeReferenceElement ref = this.getImportReference();
        if (ref == null) {
            return null;
        }
        Object resolved = !this.isStatic() || this.isOnDemand() ? ref.resolve() : this.resolveQualifier();
        return resolved instanceof PsiClass ? (PsiClass)resolved : null;
    }

    @Override
    @Nullable
    public PsiElement getAliasNameElement() {
        GrImportStatementStub stub = (GrImportStatementStub)this.getStub();
        if (stub != null) {
            String alias = stub.getAliasName();
            if (alias == null) {
                return null;
            }
            GrImportStatement imp = GroovyPsiElementFactory.getInstance(this.getProject()).createImportStatementFromText("import A as " + alias);
            return imp.getAliasNameElement();
        }
        return this.findChildByType(GroovyTokenTypes.mIDENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/toplevel/imports/GrImportStatementImpl";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsForSingleElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processSingleStaticImport";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "namesMapping";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "names";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processSingleClassImport";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isFromSamePackage";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsForMultipleElements";
                break;
            }
            case 20: 
            case 21: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

