/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightModifierList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameterListBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrInnerClassConstructorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrReflectedMethodImpl
extends LightMethodBuilder
implements GrReflectedMethod {
    private static final Logger LOG = Logger.getInstance(GrReflectedMethodImpl.class);
    @NonNls
    public static final String CATEGORY_PARAMETER_NAME = "self";
    private final GrMethod myBaseMethod;
    private GrParameter[] mySkippedParameters = null;

    public GrReflectedMethodImpl(GrMethod baseMethod, GrParameter[] parameters, int optionalParams, PsiClassType categoryType) {
        super(baseMethod.getManager(), baseMethod.getLanguage(), baseMethod.getName(), (PsiParameterList)new GrLightParameterListBuilder(baseMethod.getManager(), baseMethod.getLanguage()), (PsiModifierList)new GrLightModifierList(baseMethod), (PsiReferenceList)new LightReferenceListBuilder(baseMethod.getManager(), baseMethod.getLanguage(), null), (PsiTypeParameterList)new LightTypeParameterListBuilder(baseMethod.getManager(), baseMethod.getLanguage()));
        this.initParameterList(parameters, optionalParams, categoryType);
        this.initTypeParameterList(baseMethod);
        this.initModifiers(baseMethod, categoryType != null);
        this.initThrowsList(baseMethod);
        this.setContainingClass(baseMethod.getContainingClass());
        this.setMethodReturnType(baseMethod.getReturnType());
        this.setConstructor(baseMethod.isConstructor());
        this.myBaseMethod = baseMethod;
    }

    private void initTypeParameterList(GrMethod method) {
        for (PsiTypeParameter parameter : method.getTypeParameters()) {
            this.addTypeParameter(parameter);
        }
    }

    private void initThrowsList(GrMethod baseMethod) {
        for (PsiClassType exception : baseMethod.getThrowsList().getReferencedTypes()) {
            this.addException(exception);
        }
    }

    private void initModifiers(GrMethod baseMethod, boolean isCategoryMethod) {
        GrLightModifierList myModifierList2 = (GrLightModifierList)this.getModifierList();
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if (!baseMethod.getModifierList().hasExplicitModifier(modifier)) continue;
            myModifierList2.addModifier(modifier);
        }
        for (GrAnnotation annotation : baseMethod.getModifierList().getRawAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName != null) {
                myModifierList2.addAnnotation(qualifiedName);
                continue;
            }
            myModifierList2.addAnnotation(((GrAnnotation)annotation).getShortName());
        }
        if (isCategoryMethod) {
            myModifierList2.addModifier("static");
        }
        if (this.mySkippedParameters.length != 0) {
            myModifierList2.removeModifier(1024);
        }
    }

    private void initParameterList(GrParameter[] parameters, int optionalParams, PsiClassType categoryType) {
        GrLightParameterListBuilder parameterList = (GrLightParameterListBuilder)this.getParameterList();
        ArrayList<GrParameter> skipped = new ArrayList<GrParameter>();
        if (categoryType != null) {
            parameterList.addParameter(new GrLightParameter(CATEGORY_PARAMETER_NAME, (PsiType)categoryType, this));
        }
        for (GrParameter parameter : parameters) {
            if (parameter.isOptional()) {
                if (optionalParams < 1) {
                    skipped.add(parameter);
                    continue;
                }
                --optionalParams;
            }
            parameterList.addParameter(this.createLightParameter(parameter));
        }
        LOG.assertTrue(optionalParams == 0);
        this.mySkippedParameters = skipped.toArray(new GrParameter[skipped.size()]);
    }

    private GrLightParameter createLightParameter(GrParameter parameter) {
        GrLightParameter lightParameter = new GrLightParameter(parameter.getName(), parameter.getDeclaredType(), this);
        lightParameter.setModifierList(parameter.getModifierList());
        return lightParameter;
    }

    @Override
    @NotNull
    public GrMethod getBaseMethod() {
        GrMethod grMethod = this.myBaseMethod;
        if (grMethod == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(0);
        }
        return grMethod;
    }

    @Override
    @NotNull
    public GrParameter[] getSkippedParameters() {
        if (this.mySkippedParameters == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(1);
        }
        return this.mySkippedParameters;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myBaseMethod.getNavigationElement();
        if (psiElement == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Override
    public GrOpenBlock getBlock() {
        return this.myBaseMethod.getBlock();
    }

    @Override
    public void setBlock(GrCodeBlock newBlock) {
        throw new UnsupportedOperationException("synthetic method!");
    }

    @Override
    public GrTypeElement getReturnTypeElementGroovy() {
        return this.myBaseMethod.getReturnTypeElementGroovy();
    }

    @Override
    public PsiType getInferredReturnType() {
        return this.myBaseMethod.getInferredReturnType();
    }

    @Override
    public GrTypeElement setReturnType(@Nullable PsiType newReturnType) {
        throw new UnsupportedOperationException("synthetic method!");
    }

    @Override
    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        Map<String, NamedArgumentDescriptor> map2 = this.myBaseMethod.getNamedParameters();
        if (map2 == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(3);
        }
        return map2;
    }

    @Override
    @NotNull
    public GrReflectedMethod[] getReflectedMethods() {
        if (GrReflectedMethod.EMPTY_ARRAY == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(4);
        }
        return GrReflectedMethod.EMPTY_ARRAY;
    }

    @Override
    public GrMember[] getMembers() {
        return this.myBaseMethod.getMembers();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.myBaseMethod.getNameIdentifierGroovy();
        if (psiElement == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @Override
    public GrParameter[] getParameters() {
        return this.getParameterList().getParameters();
    }

    @Override
    @NotNull
    public GrParameterList getParameterList() {
        GrParameterList grParameterList = (GrParameterList)super.getParameterList();
        if (grParameterList == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(6);
        }
        return grParameterList;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitMethod(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
    }

    @Override
    public GrDocComment getDocComment() {
        return this.myBaseMethod.getDocComment();
    }

    public String toString() {
        return this.getName() + " (" + StringUtil.join((Object[])this.getParameters(), f -> f.getType().getPresentableText() + " " + f.getName(), (String)", ") + ")";
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        GrModifierList grModifierList = (GrModifierList)super.getModifierList();
        if (grModifierList == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(7);
        }
        return grModifierList;
    }

    public Icon getIcon(int flags) {
        return this.myBaseMethod.getIcon(flags);
    }

    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this.myBaseMethod);
    }

    public boolean isPhysical() {
        return this.myBaseMethod.isPhysical();
    }

    @NotNull
    public static GrReflectedMethod[] createReflectedMethods(GrMethod method) {
        GrReflectedMethod[] grReflectedMethodArray = (GrReflectedMethod[])CachedValuesManager.getCachedValue((PsiElement)method, () -> CachedValueProvider.Result.create((Object)GrReflectedMethodImpl.doCreateReflectedMethods(method, null, method.getParameters()), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        if (grReflectedMethodArray == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(8);
        }
        return grReflectedMethodArray;
    }

    @NotNull
    public static GrReflectedMethod[] doCreateReflectedMethods(@NotNull GrMethod targetMethod, @Nullable PsiClassType categoryType, @NotNull GrParameter[] parameters) {
        if (targetMethod == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(10);
        }
        int count = 0;
        for (GrParameter parameter : parameters) {
            if (!parameter.isOptional()) continue;
            ++count;
        }
        if (count == 0 && categoryType == null) {
            if (GrReflectedMethod.EMPTY_ARRAY == null) {
                GrReflectedMethodImpl.$$$reportNull$$$0(11);
            }
            return GrReflectedMethod.EMPTY_ARRAY;
        }
        GrReflectedMethod[] methods = new GrReflectedMethod[count + 1];
        for (int i = 0; i <= count; ++i) {
            methods[i] = new GrReflectedMethodImpl(targetMethod, parameters, count - i, categoryType);
        }
        if (methods == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(12);
        }
        return methods;
    }

    public static GrReflectedMethod[] createReflectedConstructors(GrMethod method) {
        assert (method.isConstructor());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return GrReflectedMethod.EMPTY_ARRAY;
        }
        PsiClass enclosingClass = aClass.getContainingClass();
        if (enclosingClass != null && !aClass.hasModifierProperty("static")) {
            GrParameter[] parameters = GrInnerClassConstructorUtil.addEnclosingInstanceParam(method, enclosingClass, method.getParameterList().getParameters(), false);
            GrReflectedMethod[] reflectedMethods = GrReflectedMethodImpl.doCreateReflectedMethods(method, null, parameters);
            if (reflectedMethods.length > 0) {
                return reflectedMethods;
            }
            return new GrReflectedMethod[]{new GrReflectedMethodImpl(method, parameters, 0, null)};
        }
        return GrReflectedMethodImpl.doCreateReflectedMethods(method, null, method.getParameters());
    }

    @Nullable
    private static PsiClassType getCategoryType(GrMethod method) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        return GdkMethodUtil.getCategoryType(containingClass);
    }

    @NotNull
    public PsiElement getPrototype() {
        GrMethod grMethod = this.getBaseMethod();
        if (grMethod == null) {
            GrReflectedMethodImpl.$$$reportNull$$$0(13);
        }
        return grMethod;
    }

    @Override
    public boolean hasBlock() {
        return this.getBaseMethod().hasBlock();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkippedParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReflectedMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifierGroovy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createReflectedMethods";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrReflectedMethodImpl";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateReflectedMethods";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrototype";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doCreateReflectedMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

