/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClassReferenceType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class GrReferenceListImpl
extends GrStubElementBase<GrReferenceListStub>
implements StubBasedPsiElement<GrReferenceListStub>,
GrReferenceList {
    private static final Logger LOG = Logger.getInstance(GrReferenceListImpl.class);
    private PsiClassType[] myCachedTypes;

    public GrReferenceListImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrReferenceListImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement psi;
        if (child == null) {
            GrReferenceListImpl.$$$reportNull$$$0(1);
        }
        if ((psi = child.getPsi()) instanceof GrCodeReferenceElement) {
            GrCodeReferenceElement[] refs = this.getReferenceElementsGroovy();
            if (refs.length == 1) {
                PsiElement keyword = this.getKeyword();
                LOG.assertTrue(keyword != null);
                keyword.delete();
            } else {
                PsiElement comma;
                boolean forward = refs[0] == psi;
                PsiElement psiElement = comma = forward ? PsiUtil.skipWhitespacesAndComments(psi.getNextSibling(), true, true) : PsiUtil.skipWhitespacesAndComments(psi.getPrevSibling(), false, true);
                if (comma != null && comma.getNode().getElementType() == GroovyTokenTypes.mCOMMA) {
                    comma.delete();
                }
            }
            super.deleteChildInternal(child);
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    @Nullable
    public PsiElement getKeyword() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild != null && firstChild.getNode().getElementType() == this.getKeywordType()) {
            return firstChild;
        }
        return null;
    }

    public GrReferenceListImpl(GrReferenceListStub stub, IStubElementType elementType) {
        super(stub, elementType);
    }

    @Override
    @NotNull
    public GrCodeReferenceElement[] getReferenceElementsGroovy() {
        GrReferenceListStub stub = (GrReferenceListStub)this.getStub();
        if (stub != null) {
            String[] baseClasses = stub.getBaseClasses();
            GrCodeReferenceElement[] result = new GrCodeReferenceElement[baseClasses.length];
            for (int i = 0; i < baseClasses.length; ++i) {
                result[i] = GroovyPsiElementFactory.getInstance(this.getProject()).createReferenceElementFromText(baseClasses[i], this);
            }
            if (result == null) {
                GrReferenceListImpl.$$$reportNull$$$0(2);
            }
            return result;
        }
        GrCodeReferenceElement[] grCodeReferenceElementArray = (GrCodeReferenceElement[])this.findChildrenByClass(GrCodeReferenceElement.class);
        if (grCodeReferenceElementArray == null) {
            GrReferenceListImpl.$$$reportNull$$$0(3);
        }
        return grCodeReferenceElementArray;
    }

    @NotNull
    public PsiClassType[] getReferencedTypes() {
        if (this.myCachedTypes == null || !this.isValid()) {
            ArrayList<GrClassReferenceType> types = new ArrayList<GrClassReferenceType>();
            for (GrCodeReferenceElement ref : this.getReferenceElementsGroovy()) {
                types.add(new GrClassReferenceType(ref));
            }
            this.myCachedTypes = types.toArray(new PsiClassType[types.size()]);
        }
        if (this.myCachedTypes == null) {
            GrReferenceListImpl.$$$reportNull$$$0(4);
        }
        return this.myCachedTypes;
    }

    public void subtreeChanged() {
        this.myCachedTypes = null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            GrReferenceListImpl.$$$reportNull$$$0(5);
        }
        if (element instanceof GrCodeReferenceElement || element instanceof PsiJavaCodeReferenceElement) {
            if (this.findChildByType(this.getKeywordType()) == null) {
                this.getNode().getTreeParent().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", this.getNode());
                this.getNode().addLeaf(this.getKeywordType(), (CharSequence)this.getKeywordType().toString(), null);
            } else if (this.findChildByClass(GrCodeReferenceElement.class) != null) {
                PsiElement lastChild = this.getLastChild();
                if (!(lastChild = PsiUtil.skipWhitespacesAndComments(lastChild, false)).getNode().getElementType().equals(GroovyTokenTypes.mCOMMA)) {
                    this.getNode().addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", null);
                }
            }
        }
        return super.add(element);
    }

    protected abstract IElementType getKeywordType();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrReferenceListImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrReferenceListImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElementsGroovy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

