/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrThisReferenceResolver {
    @Nullable(value="null if ref is not actually 'this' reference")
    public static GroovyResolveResult[] resolveThisExpression(@NotNull GrReferenceExpression ref) {
        GroovyResolveResult result;
        PsiElement resolved;
        GrExpression qualifier;
        if (ref == null) {
            GrThisReferenceResolver.$$$reportNull$$$0(0);
        }
        if ((qualifier = (GrExpression)ref.getQualifier()) == null) {
            PsiElement parent = ref.getParent();
            if (parent instanceof GrConstructorInvocation) {
                return ((GrConstructorInvocation)parent).multiResolve(false);
            }
            PsiClass aClass = PsiUtil.getContextClass(ref);
            if (aClass != null) {
                return new GroovyResolveResultImpl[]{new GroovyResolveResultImpl((PsiElement)aClass, null, null, PsiSubstitutor.EMPTY, true, true)};
            }
        } else if (qualifier instanceof GrReferenceExpression && (resolved = (result = ((GrReferenceExpression)qualifier).advancedResolve()).getElement()) instanceof PsiClass && PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, ref, false)) {
            return new GroovyResolveResult[]{result};
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/GrThisReferenceResolver", "resolveThisExpression"));
    }
}

