/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.blocks;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.profiling.ResolveProfiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ControlFlowBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public abstract class GrBlockImpl
extends LazyParseablePsiElement
implements GrCodeBlock,
GrControlFlowOwner {
    private static final Key<CachedValue<Instruction[]>> CONTROL_FLOW = Key.create((String)"Control flow");

    protected GrBlockImpl(@NotNull IElementType type, CharSequence buffer) {
        if (type == null) {
            GrBlockImpl.$$$reportNull$$$0(0);
        }
        super(type, buffer);
    }

    public void delete() throws IncorrectOperationException {
        if (this.getParent() instanceof ASTDelegatePsiElement) {
            CheckUtil.checkWritable((PsiElement)this);
            ((ASTDelegatePsiElement)this.getParent()).deleteChildInternal(this.getNode());
        } else {
            this.getParent().deleteChildRange((PsiElement)this, (PsiElement)this);
        }
    }

    @Override
    public void removeElements(PsiElement[] elements) throws IncorrectOperationException {
        GroovyPsiElementImpl.removeElements(this, elements);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
        GroovyPsiElementImpl.acceptGroovyChildren(this, visitor2);
    }

    public <T extends GrStatement> T replaceWithStatement(T statement) {
        return GroovyPsiElementImpl.replaceWithStatement(this, statement);
    }

    public void clearCaches() {
        super.clearCaches();
        this.putUserData(CONTROL_FLOW, null);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiElement element;
        if (child == null) {
            GrBlockImpl.$$$reportNull$$$0(1);
        }
        if ((element = child.getPsi()) instanceof GrStatement) {
            PsiImplUtil.deleteStatementTail(this, element);
        }
        super.deleteChildInternal(child);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        if (last instanceof GrStatement) {
            PsiImplUtil.deleteStatementTail(this, last);
        }
        super.deleteChildRange(first, last);
    }

    @Override
    public Instruction[] getControlFlow() {
        assert (this.isValid());
        CachedValue controlFlow = (CachedValue)this.getUserData(CONTROL_FLOW);
        if (controlFlow == null) {
            controlFlow = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                try {
                    ResolveProfiler.start();
                    Instruction[] flow = new ControlFlowBuilder(this.getProject()).buildControlFlow(this);
                    CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)flow, (Object[])new Object[]{this.getContainingFile(), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                    return result;
                }
                finally {
                    long time = ResolveProfiler.finish();
                    ResolveProfiler.write((String)"flow", (PsiElement)this, (long)time);
                }
            }, false);
            controlFlow = (CachedValue)this.putUserDataIfAbsent(CONTROL_FLOW, controlFlow);
        }
        return ControlFlowBuilder.assertValidPsi((Instruction[])controlFlow.getValue());
    }

    @Override
    public void removeVariable(GrVariable variable) {
        PsiImplUtil.removeVariable(variable);
    }

    @Override
    public GrVariableDeclaration addVariableDeclarationBefore(GrVariableDeclaration declaration, GrStatement anchor) throws IncorrectOperationException {
        GrStatement statement = this.addStatementBefore(declaration, anchor);
        assert (statement instanceof GrVariableDeclaration);
        return (GrVariableDeclaration)statement;
    }

    private boolean mayUseNewLinesAsSeparators() {
        for (GrBlockImpl parent = this; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof GrString)) continue;
            GrString grString = (GrString)((Object)parent);
            return !grString.isPlainString();
        }
        return true;
    }

    @Override
    @NotNull
    public GrStatement[] getStatements() {
        GrStatement[] grStatementArray = PsiImplUtil.getStatements(this);
        if (grStatementArray == null) {
            GrBlockImpl.$$$reportNull$$$0(2);
        }
        return grStatementArray;
    }

    @Override
    @NotNull
    public GrStatement addStatementBefore(@NotNull GrStatement element, @Nullable GrStatement anchor) throws IncorrectOperationException {
        GrStatement actualAnchor;
        if (element == null) {
            GrBlockImpl.$$$reportNull$$$0(3);
        }
        if (anchor == null && this.getRBrace() == null) {
            throw new IncorrectOperationException();
        }
        if (anchor != null && !this.equals(anchor.getParent())) {
            throw new IncorrectOperationException();
        }
        LeafElement nls = Factory.createSingleLeafElement((IElementType)GroovyTokenTypes.mNLS, (CharSequence)"\n", (int)0, (int)1, null, (PsiManager)this.getManager());
        GrStatement grStatement = actualAnchor = anchor == null ? this.getRBrace() : anchor;
        if (this.mayUseNewLinesAsSeparators()) {
            PsiElement prev = actualAnchor.getPrevSibling();
            if (prev instanceof GrParameterList && prev.getTextLength() == 0 && prev.getPrevSibling() != null) {
                prev = prev.getPrevSibling();
            }
            if (!PsiUtil.isLineFeed(prev)) {
                this.addBefore(nls.getPsi(), actualAnchor);
            }
        }
        element = (GrStatement)this.addBefore(element, actualAnchor);
        if (this.mayUseNewLinesAsSeparators()) {
            this.addBefore(nls.getPsi(), actualAnchor);
        } else {
            this.addBefore(Factory.createSingleLeafElement((IElementType)GroovyTokenTypes.mNLS, (CharSequence)"\n", (int)0, (int)1, null, (PsiManager)this.getManager()).getPsi(), actualAnchor);
        }
        GrStatement grStatement2 = element;
        if (grStatement2 == null) {
            GrBlockImpl.$$$reportNull$$$0(4);
        }
        return grStatement2;
    }

    @Override
    public PsiElement getLBrace() {
        return this.findPsiChildByType(GroovyTokenTypes.mLCURLY);
    }

    @Override
    @Nullable
    public PsiElement getRBrace() {
        return this.findPsiChildByType(GroovyTokenTypes.mRCURLY);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GrBlockImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            GrBlockImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            GrBlockImpl.$$$reportNull$$$0(7);
        }
        return ResolveUtil.processChildren(this, processor, state, lastParent, place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrBlockImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/statements/blocks/GrBlockImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addStatementBefore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addStatementBefore";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

