/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;

public class GrClassReferenceType
extends PsiClassType {
    private final GrReferenceElement myReferenceElement;

    public GrClassReferenceType(GrReferenceElement referenceElement) {
        super(LanguageLevel.JDK_1_5);
        this.myReferenceElement = referenceElement;
    }

    public GrClassReferenceType(GrReferenceElement referenceElement, LanguageLevel languageLevel) {
        super(languageLevel);
        this.myReferenceElement = referenceElement;
    }

    @Nullable
    public PsiClass resolve() {
        return this.resolveGenerics().getElement();
    }

    @Nullable
    public String getClassName() {
        PsiClass resolved = this.resolve();
        if (resolved != null) {
            return resolved.getName();
        }
        return this.myReferenceElement.getReferenceName();
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiType[] psiTypeArray = this.myReferenceElement.getTypeArguments();
        if (psiTypeArray == null) {
            GrClassReferenceType.$$$reportNull$$$0(0);
        }
        return psiTypeArray;
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        final GroovyResolveResult resolveResult = this.myReferenceElement.advancedResolve();
        PsiClassType.ClassResolveResult classResolveResult = new PsiClassType.ClassResolveResult(){

            public PsiClass getElement() {
                PsiElement resolved = resolveResult.getElement();
                return resolved instanceof PsiClass ? (PsiClass)resolved : null;
            }

            @NotNull
            public PsiSubstitutor getSubstitutor() {
                PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
                if (psiSubstitutor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiSubstitutor;
            }

            public boolean isPackagePrefixPackageReference() {
                return false;
            }

            public boolean isAccessible() {
                return resolveResult.isAccessible();
            }

            public boolean isStaticsScopeCorrect() {
                return resolveResult.isStaticsOK();
            }

            @Nullable
            public PsiElement getCurrentFileResolveScope() {
                return resolveResult.getCurrentFileResolveContext();
            }

            public boolean isValidResult() {
                return this.isStaticsScopeCorrect() && this.isAccessible();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType$1", "getSubstitutor"));
            }
        };
        if (classResolveResult == null) {
            GrClassReferenceType.$$$reportNull$$$0(1);
        }
        return classResolveResult;
    }

    @NotNull
    public PsiClassType rawType() {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myReferenceElement.getProject());
        PsiClass clazz = this.resolve();
        if (clazz != null) {
            PsiClassType psiClassType = factory.createType(clazz, factory.createRawSubstitutor((PsiTypeParameterListOwner)clazz), this.getLanguageLevel());
            if (psiClassType == null) {
                GrClassReferenceType.$$$reportNull$$$0(2);
            }
            return psiClassType;
        }
        String qName = this.myReferenceElement.getClassNameText();
        PsiClassType psiClassType = factory.createTypeByFQClassName(qName, this.myReferenceElement.getResolveScope());
        if (psiClassType == null) {
            GrClassReferenceType.$$$reportNull$$$0(3);
        }
        return psiClassType;
    }

    @NotNull
    public String getPresentableText() {
        String string = PsiNameHelper.getPresentableText((String)this.myReferenceElement.getReferenceName(), (PsiAnnotation[])PsiAnnotation.EMPTY_ARRAY, (PsiType[])this.myReferenceElement.getTypeArguments());
        if (string == null) {
            GrClassReferenceType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myReferenceElement.getCanonicalText();
        if (string == null) {
            GrClassReferenceType.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isValid() {
        return this.myReferenceElement.isValid();
    }

    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            GrClassReferenceType.$$$reportNull$$$0(6);
        }
        return text.endsWith(this.getPresentableText()) && text.equals(this.getCanonicalText());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myReferenceElement.getResolveScope();
        if (globalSearchScope == null) {
            GrClassReferenceType.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            GrClassReferenceType.$$$reportNull$$$0(8);
        }
        return languageLevel;
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            GrClassReferenceType.$$$reportNull$$$0(9);
        }
        GrClassReferenceType grClassReferenceType = new GrClassReferenceType(this.myReferenceElement, languageLevel);
        if (grClassReferenceType == null) {
            GrClassReferenceType.$$$reportNull$$$0(10);
        }
        return grClassReferenceType;
    }

    public GrReferenceElement getReference() {
        return this.myReferenceElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGenerics";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "rawType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrClassReferenceType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

