/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;

public class InstructionImpl
implements Instruction {
    private final LinkedHashSet<Instruction> myPredecessors = new LinkedHashSet(1);
    private final LinkedHashSet<Instruction> mySuccessors = new LinkedHashSet(1);
    private LinkedHashSet<NegatingGotoInstruction> myNegations;
    protected final PsiElement myPsiElement;
    private int myNumber = -1;

    @Override
    @Nullable
    public PsiElement getElement() {
        return this.myPsiElement;
    }

    public InstructionImpl(@Nullable PsiElement element) {
        this.myPsiElement = element;
    }

    @Override
    @NotNull
    public Iterable<Instruction> successors(@NotNull CallEnvironment environment) {
        if (environment == null) {
            InstructionImpl.$$$reportNull$$$0(0);
        }
        Deque<CallInstruction> stack = environment.callStack(this);
        for (Instruction instruction : this.mySuccessors) {
            environment.update(stack, instruction);
        }
        LinkedHashSet<Instruction> linkedHashSet = this.mySuccessors;
        if (linkedHashSet == null) {
            InstructionImpl.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Iterable<Instruction> predecessors(@NotNull CallEnvironment environment) {
        if (environment == null) {
            InstructionImpl.$$$reportNull$$$0(2);
        }
        Deque<CallInstruction> stack = environment.callStack(this);
        for (Instruction instruction : this.myPredecessors) {
            environment.update(stack, instruction);
        }
        LinkedHashSet<Instruction> linkedHashSet = this.myPredecessors;
        if (linkedHashSet == null) {
            InstructionImpl.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Iterable<Instruction> allSuccessors() {
        LinkedHashSet<Instruction> linkedHashSet = this.mySuccessors;
        if (linkedHashSet == null) {
            InstructionImpl.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public Iterable<Instruction> allPredecessors() {
        LinkedHashSet<Instruction> linkedHashSet = this.myPredecessors;
        if (linkedHashSet == null) {
            InstructionImpl.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.myNumber);
        builder.append("(");
        for (Instruction successor : this.mySuccessors) {
            builder.append(successor.num());
            builder.append(',');
        }
        if (!this.mySuccessors.isEmpty()) {
            builder.delete(builder.length() - 1, builder.length());
        }
        builder.append(") ").append(this.getElementPresentation());
        return builder.toString();
    }

    @NotNull
    protected String getElementPresentation() {
        String string = "element: " + this.myPsiElement;
        if (string == null) {
            InstructionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public int num() {
        assert (this.myNumber != -1);
        return this.myNumber;
    }

    @Override
    @NotNull
    public Iterable<? extends NegatingGotoInstruction> getNegatingGotoInstruction() {
        if (this.myNegations == null) {
            List list = Collections.emptyList();
            if (list == null) {
                InstructionImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        LinkedHashSet<NegatingGotoInstruction> linkedHashSet = this.myNegations;
        if (linkedHashSet == null) {
            InstructionImpl.$$$reportNull$$$0(8);
        }
        return linkedHashSet;
    }

    public void addSuccessor(InstructionImpl instruction) {
        this.mySuccessors.add(instruction);
    }

    public void addPredecessor(InstructionImpl instruction) {
        this.myPredecessors.add(instruction);
    }

    void addNegationsFrom(Instruction instruction) {
        if (this.myNegations == null) {
            this.myNegations = new LinkedHashSet(1);
        }
        for (NegatingGotoInstruction negatingGotoInstruction : instruction.getNegatingGotoInstruction()) {
            this.myNegations.add(negatingGotoInstruction);
        }
        if (instruction instanceof NegatingGotoInstruction) {
            this.myNegations.add((NegatingGotoInstruction)instruction);
        }
    }

    final void setNumber(int num) {
        assert (this.myNumber == -1);
        this.myNumber = num;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/InstructionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "successors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "predecessors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allSuccessors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "allPredecessors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNegatingGotoInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "successors";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "predecessors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

