/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParameter;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GroovyDocPsiElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrDocMethodParamsImpl
extends GroovyDocPsiElementImpl
implements GrDocMethodParams {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocMethodParamsImpl");

    public GrDocMethodParamsImpl(@NotNull ASTNode node) {
        if (node == null) {
            GrDocMethodParamsImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public String toString() {
        return "GrDocMethodParameterList";
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitDocMethodParameterList(this);
    }

    @Override
    public PsiType[] getParameterTypes() {
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        PsiManagerEx manager = this.getManager();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.getProject());
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        for (GrDocMethodParameter parameter : this.getParameters()) {
            GrDocReferenceElement typeElement = parameter.getTypeElement();
            try {
                PsiType type = factory.createTypeFromText(typeElement.getText(), (PsiElement)this);
                type = TypesUtil.boxPrimitiveType(type, (PsiManager)manager, scope);
                types.add(type);
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
                types.add(null);
            }
        }
        return types.toArray(PsiType.createArray((int)types.size()));
    }

    @Override
    public GrDocMethodParameter[] getParameters() {
        ArrayList<GrDocMethodParameter> result = new ArrayList<GrDocMethodParameter>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!GrDocMethodParameter.class.isInstance(cur)) continue;
            result.add((GrDocMethodParameter)cur);
        }
        return result.toArray(new GrDocMethodParameter[result.size()]);
    }

    @Override
    @NotNull
    public PsiElement getLeftParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyDocTokenTypes.mGDOC_TAG_VALUE_LPAREN);
        assert (paren != null);
        PsiElement psiElement = paren.getPsi();
        if (psiElement == null) {
            GrDocMethodParamsImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Override
    @Nullable
    public PsiElement getRightParen() {
        ASTNode paren = this.getNode().findChildByType(GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN);
        return paren != null ? paren.getPsi() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMethodParamsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/groovydoc/psi/impl/GrDocMethodParamsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftParen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

