/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.GroovyDslFileIndex;
import org.jetbrains.plugins.groovy.lang.completion.ClosureCompleter;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureDescriptor;
import org.jetbrains.plugins.groovy.lang.completion.closureParameters.ClosureParameterInfo;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GdslClosureCompleter
extends ClosureCompleter {
    @Override
    protected List<ClosureParameterInfo> getParameterInfos(InsertionContext context, PsiMethod method, PsiSubstitutor substitutor, PsiElement place) {
        ArrayList<ClosureDescriptor> descriptors = new ArrayList<ClosureDescriptor>();
        GrReferenceExpression ref = (GrReferenceExpression)place;
        PsiType qtype = PsiImplUtil.getQualifierType(ref);
        if (qtype == null) {
            return null;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier != null) {
            PsiType type = qualifier.getType();
            if (type == null) {
                return null;
            }
            GdslClosureCompleter.processExecutors(qtype, ref, descriptors);
        } else {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
            for (PsiElement parent = ref.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof GrClosableBlock) {
                    GdslClosureCompleter.processExecutors((PsiType)TypesUtil.createTypeByFQClassName("groovy.lang.Closure", ref), ref, descriptors);
                    continue;
                }
                if (!(parent instanceof GrTypeDefinition)) continue;
                GdslClosureCompleter.processExecutors((PsiType)factory.createType((PsiClass)((GrTypeDefinition)parent), PsiType.EMPTY_ARRAY), ref, descriptors);
            }
        }
        for (ClosureDescriptor descriptor2 : descriptors) {
            if (!descriptor2.isMethodApplicable(method, ref)) continue;
            return descriptor2.getParameters();
        }
        return null;
    }

    private static void processExecutors(PsiType qtype, GrReferenceExpression ref, final ArrayList<ClosureDescriptor> descriptors) {
        GroovyDslFileIndex.processExecutors(qtype, ref, (PsiScopeProcessor)new BaseScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof ClosureDescriptor) {
                    descriptors.add((ClosureDescriptor)element);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/GdslClosureCompleter$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ResolveState.initial());
    }
}

