/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.IfEndInstruction;

public class InvertIfIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        GrUnaryExpression unaryCondition;
        if (element == null) {
            InvertIfIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            InvertIfIntention.$$$reportNull$$$0(1);
        }
        PsiElement parent = element.getParent();
        if (!"if".equals(element.getText()) || !(parent instanceof GrIfStatement)) {
            throw new IncorrectOperationException("Not invoked on an if");
        }
        GrIfStatement parentIf = (GrIfStatement)parent;
        GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(project);
        GrExpression condition = parentIf.getCondition();
        if (condition == null) {
            throw new IncorrectOperationException("Invoked on an if with empty condition");
        }
        GrExpression negatedCondition = null;
        if (condition instanceof GrUnaryExpression && "!".equals((unaryCondition = (GrUnaryExpression)condition).getOperationToken().getText())) {
            negatedCondition = InvertIfIntention.stripParenthesis(unaryCondition.getOperand());
        }
        if (negatedCondition == null) {
            String negatedExpressionText = (condition = InvertIfIntention.stripParenthesis(condition)) instanceof GrCallExpression || condition instanceof GrReferenceExpression ? "!" + condition.getText() : "!(" + condition.getText() + ")";
            negatedCondition = groovyPsiElementFactory.createExpressionFromText(negatedExpressionText, parentIf);
        }
        GrStatement thenBranch = parentIf.getThenBranch();
        boolean thenIsNotEmpty = InvertIfIntention.isNotEmpty(thenBranch);
        String newIfText = "if (" + negatedCondition.getText() + ") {}";
        if (thenIsNotEmpty) {
            newIfText = newIfText + " else {}";
        }
        GrIfStatement newIf = (GrIfStatement)groovyPsiElementFactory.createStatementFromText(newIfText, parentIf.getContext());
        InvertIfIntention.generateElseBranchTextAndRemoveTailStatements(parentIf, newIf);
        if (thenIsNotEmpty) {
            GrStatement elseBranch = newIf.getElseBranch();
            assert (elseBranch != null);
            elseBranch.replaceWithStatement(thenBranch);
        }
        parentIf.replace(newIf);
    }

    private static boolean isNotEmpty(@Nullable GrStatement thenBranch) {
        return thenBranch != null && (!(thenBranch instanceof GrBlockStatement) || ((GrBlockStatement)thenBranch).getBlock().getStatements().length != 0);
    }

    private static void generateElseBranchTextAndRemoveTailStatements(@NotNull GrIfStatement ifStatement, @NotNull GrIfStatement newIf) {
        if (ifStatement == null) {
            InvertIfIntention.$$$reportNull$$$0(2);
        }
        if (newIf == null) {
            InvertIfIntention.$$$reportNull$$$0(3);
        }
        GrStatement thenBranch = newIf.getThenBranch();
        assert (thenBranch != null);
        GrStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            thenBranch.replaceWithStatement(elseBranch);
            return;
        }
        PsiElement parent = ifStatement.getParent();
        if (!(parent instanceof GrStatementOwner)) {
            return;
        }
        if (!InvertIfIntention.isTailAfterIf(ifStatement, (GrStatementOwner)parent)) {
            return;
        }
        PsiElement start = ifStatement.getNextSibling();
        PsiElement end = parent instanceof GrCodeBlock ? ((GrCodeBlock)parent).getRBrace().getPrevSibling() : parent.getLastChild();
        GrOpenBlock block = ((GrBlockStatement)thenBranch).getBlock();
        block.addRangeAfter(start, end, block.getLBrace());
        parent.deleteChildRange(start, end);
    }

    private static boolean isTailAfterIf(@NotNull GrIfStatement ifStatement, @NotNull GrStatementOwner owner) {
        GrControlFlowOwner flowOwner;
        if (ifStatement == null) {
            InvertIfIntention.$$$reportNull$$$0(4);
        }
        if (owner == null) {
            InvertIfIntention.$$$reportNull$$$0(5);
        }
        if ((flowOwner = ControlFlowUtils.findControlFlowOwner(ifStatement)) == null) {
            return false;
        }
        Instruction[] flow = flowOwner.getControlFlow();
        Object[] statements = owner.getStatements();
        int index = ArrayUtilRt.find((Object[])statements, (Object)ifStatement);
        if (index == statements.length - 1) {
            return false;
        }
        GrStatement then = ifStatement.getThenBranch();
        for (Instruction i : flow) {
            PsiElement element = i.getElement();
            if (element == null || !PsiTreeUtil.isAncestor((PsiElement)then, (PsiElement)element, (boolean)true)) continue;
            for (Instruction succ : i.allSuccessors()) {
                if (!(succ instanceof IfEndInstruction)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static GrExpression stripParenthesis(GrExpression operand) {
        GrExpression innerExpression;
        while (operand instanceof GrParenthesizedExpression && (innerExpression = ((GrParenthesizedExpression)operand).getOperand()) != null) {
            operand = innerExpression;
        }
        GrExpression grExpression = operand;
        if (grExpression == null) {
            InvertIfIntention.$$$reportNull$$$0(6);
        }
        return grExpression;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                PsiElement parent;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((parent = element.getParent()) instanceof GrIfStatement)) {
                    return false;
                }
                if (((GrIfStatement)parent).getCondition() == null) {
                    return false;
                }
                return "if".equals(element.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention$1", "satisfiedBy"));
            }
        };
        if (psiElementPredicate == null) {
            InvertIfIntention.$$$reportNull$$$0(7);
        }
        return psiElementPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newIf";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/InvertIfIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "stripParenthesis";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateElseBranchTextAndRemoveTailStatements";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTailAfterIf";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

