/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.comments;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

class CStyleCommentPredicate
implements PsiElementPredicate {
    CStyleCommentPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            CStyleCommentPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiComment)) {
            return false;
        }
        if (element instanceof PsiDocComment) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType type = comment.getTokenType();
        if (!GroovyTokenTypes.mML_COMMENT.equals(type)) {
            return false;
        }
        PsiElement sibling = PsiTreeUtil.nextLeaf((PsiElement)comment);
        if (sibling == null) {
            return true;
        }
        if (!CStyleCommentPredicate.isWhitespace(sibling)) {
            return false;
        }
        String whitespaceText = sibling.getText();
        return whitespaceText.indexOf(10) >= 0 || whitespaceText.indexOf(13) >= 0;
    }

    private static boolean isWhitespace(PsiElement element) {
        return element.getText().replace("\n", "").trim().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/comments/CStyleCommentPredicate", "satisfiedBy"));
    }
}

