/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.formatter.blocks.ClosureBodyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GrLabelBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocMethodParams;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocTag;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrArrayDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrWildcardTypeArgument;

public class GroovyIndentProcessor
extends GroovyElementVisitor {
    public static final int GDOC_COMMENT_INDENT = 1;
    private static final TokenSet GSTRING_TOKENS_INNER = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mGSTRING_CONTENT, GroovyTokenTypes.mGSTRING_END, GroovyTokenTypes.mDOLLAR});
    private Indent myResult = null;
    private IElementType myChildType;
    private GroovyBlock myBlock;
    private PsiElement myChild;

    @NotNull
    public Indent getChildIndent(@NotNull GroovyBlock parentBlock, @NotNull ASTNode child) {
        if (parentBlock == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(0);
        }
        if (child == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(1);
        }
        this.myChildType = child.getElementType();
        if (parentBlock instanceof ClosureBodyBlock) {
            if (this.myChildType == GroovyElementTypes.PARAMETERS_LIST) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    GroovyIndentProcessor.$$$reportNull$$$0(2);
                }
                return indent;
            }
            if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    GroovyIndentProcessor.$$$reportNull$$$0(3);
                }
                return indent;
            }
        }
        if (parentBlock instanceof GrLabelBlock) {
            ASTNode first = parentBlock.getNode().getFirstChildNode();
            Indent indent = child == first ? Indent.getNoneIndent() : Indent.getLabelIndent();
            if (indent == null) {
                GroovyIndentProcessor.$$$reportNull$$$0(4);
            }
            return indent;
        }
        if (GSTRING_TOKENS_INNER.contains(this.myChildType)) {
            Indent indent = Indent.getAbsoluteNoneIndent();
            if (indent == null) {
                GroovyIndentProcessor.$$$reportNull$$$0(5);
            }
            return indent;
        }
        PsiElement parent = parentBlock.getNode().getPsi();
        if (parent instanceof GroovyPsiElement) {
            this.myBlock = parentBlock;
            this.myChild = child.getPsi();
            ((GroovyPsiElement)parent).accept(this);
            if (this.myResult != null) {
                Indent indent = this.myResult;
                if (indent == null) {
                    GroovyIndentProcessor.$$$reportNull$$$0(6);
                }
                return indent;
            }
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(7);
        }
        return indent;
    }

    @Override
    public void visitAssertStatement(@NotNull GrAssertStatement assertStatement) {
        if (assertStatement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(8);
        }
        if (this.myChildType != GroovyTokenTypes.kASSERT) {
            this.myResult = Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitAnnotationArrayInitializer(@NotNull GrAnnotationArrayInitializer arrayInitializer) {
        if (arrayInitializer == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(9);
        }
        if (this.myChildType != GroovyTokenTypes.mLBRACK && this.myChildType != GroovyTokenTypes.mRBRACK) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        if (listOrMap == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(10);
        }
        if (this.myChildType != GroovyTokenTypes.mLBRACK && this.myChildType != GroovyTokenTypes.mRBRACK) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitCaseSection(@NotNull GrCaseSection caseSection) {
        if (caseSection == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(11);
        }
        if (this.myChildType != GroovyElementTypes.CASE_LABEL) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
        if (switchStatement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(12);
        }
        if (this.myChildType == GroovyElementTypes.CASE_SECTION) {
            this.myResult = GroovyIndentProcessor.getSwitchCaseIndent(this.getGroovySettings());
        }
    }

    @Override
    public void visitLabeledStatement(@NotNull GrLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(13);
        }
        if (this.myChildType == GroovyTokenTypes.mIDENT) {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.myBlock.getContext().getSettings().getIndentOptions();
            if (indentOptions != null && indentOptions.LABEL_INDENT_ABSOLUTE) {
                this.myResult = Indent.getAbsoluteLabelIndent();
            } else if (!this.myBlock.getContext().getGroovySettings().INDENT_LABEL_BLOCKS) {
                this.myResult = Indent.getLabelIndent();
            }
        } else if (this.myBlock.getContext().getGroovySettings().INDENT_LABEL_BLOCKS) {
            this.myResult = Indent.getLabelIndent();
        }
    }

    @Override
    public void visitAnnotation(@NotNull GrAnnotation annotation) {
        if (annotation == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(14);
        }
        this.myResult = this.myChildType == GroovyElementTypes.ANNOTATION_ARGUMENTS ? Indent.getContinuationIndent() : Indent.getNoneIndent();
    }

    @Override
    public void visitArgumentList(@NotNull GrArgumentList list) {
        if (list == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(15);
        }
        if (this.myChildType != GroovyTokenTypes.mLPAREN && this.myChildType != GroovyTokenTypes.mRPAREN) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
        if (ifStatement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(16);
        }
        if (TokenSets.BLOCK_SET.contains(this.myChildType)) {
            if (this.myChild == ifStatement.getCondition()) {
                this.myResult = Indent.getContinuationWithoutFirstIndent();
            }
        } else if (this.myChild == ifStatement.getThenBranch()) {
            this.myResult = Indent.getNormalIndent();
        } else if (this.myChild == ifStatement.getElseBranch()) {
            this.myResult = this.getGroovySettings().SPECIAL_ELSE_IF_TREATMENT && this.myChildType == GroovyElementTypes.IF_STATEMENT ? Indent.getNoneIndent() : Indent.getNormalIndent();
        }
    }

    @Override
    public void visitAnnotationArgumentList(@NotNull GrAnnotationArgumentList annotationArgumentList) {
        if (annotationArgumentList == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(17);
        }
        this.myResult = this.myChildType == GroovyTokenTypes.mLPAREN || this.myChildType == GroovyTokenTypes.mRPAREN ? Indent.getNoneIndent() : Indent.getContinuationIndent();
    }

    @Override
    public void visitNamedArgument(@NotNull GrNamedArgument argument) {
        if (argument == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(18);
        }
        if (this.myChild == argument.getExpression()) {
            this.myResult = Indent.getContinuationIndent();
        }
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        if (variable == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(19);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitEnumConstant(@NotNull GrEnumConstant enumConstant) {
        if (enumConstant == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(20);
        }
        Indent.getNoneIndent();
    }

    @Override
    public void visitDocComment(@NotNull GrDocComment comment) {
        if (comment == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(21);
        }
        if (this.myChildType != GroovyDocTokenTypes.mGDOC_COMMENT_START) {
            this.myResult = Indent.getSpaceIndent((int)1);
        }
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        if (variableDeclaration == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(22);
        }
        if (this.myChild instanceof GrVariable) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitDocTag(@NotNull GrDocTag docTag) {
        if (docTag == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(23);
        }
        if (this.myChildType != GroovyDocTokenTypes.mGDOC_TAG_NAME) {
            this.myResult = Indent.getSpaceIndent((int)1);
        }
    }

    @Override
    public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
        if (expression == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(24);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        if (expression == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(25);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitThrowsClause(@NotNull GrThrowsClause throwsClause) {
        if (throwsClause == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(26);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitImplementsClause(@NotNull GrImplementsClause implementsClause) {
        if (implementsClause == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(27);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitDocMethodParameterList(@NotNull GrDocMethodParams params) {
        if (params == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(28);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitExtendsClause(@NotNull GrExtendsClause extendsClause) {
        if (extendsClause == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(29);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitFile(@NotNull GroovyFileBase file) {
        if (file == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(30);
        }
        this.myResult = Indent.getNoneIndent();
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (method == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(31);
        }
        if (this.myChildType == GroovyElementTypes.PARAMETERS_LIST) {
            this.myResult = Indent.getContinuationIndent();
        } else if (this.myChildType == GroovyElementTypes.THROW_CLAUSE) {
            this.myResult = this.getGroovySettings().ALIGN_THROWS_KEYWORD ? Indent.getNoneIndent() : Indent.getContinuationIndent();
        } else if (this.myChildType == GroovyElementTypes.OPEN_BLOCK) {
            this.myResult = GroovyIndentProcessor.getBlockIndent(this.getGroovySettings().METHOD_BRACE_STYLE);
        }
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(32);
        }
        if (this.myChildType == GroovyElementTypes.EXTENDS_CLAUSE || this.myChildType == GroovyElementTypes.IMPLEMENTS_CLAUSE) {
            this.myResult = Indent.getContinuationIndent();
        } else if (this.myChildType == GroovyElementTypes.ENUM_BODY || this.myChildType == GroovyElementTypes.CLASS_BODY) {
            this.myResult = GroovyIndentProcessor.getBlockIndent(this.getGroovySettings().CLASS_BRACE_STYLE);
        }
    }

    @Override
    public void visitTypeDefinitionBody(@NotNull GrTypeDefinitionBody typeDefinitionBody) {
        if (typeDefinitionBody == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(33);
        }
        if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
            this.myResult = GroovyIndentProcessor.getIndentInBlock(this.getGroovySettings().CLASS_BRACE_STYLE);
        }
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        if (closure == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(34);
        }
        if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
            this.myResult = Indent.getNormalIndent();
        }
    }

    @Override
    public void visitOpenBlock(@NotNull GrOpenBlock block) {
        IElementType type;
        if (block == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(35);
        }
        if ((type = block.getNode().getElementType()) != GroovyElementTypes.OPEN_BLOCK && type != GroovyElementTypes.CONSTRUCTOR_BODY) {
            return;
        }
        PsiElement parent = block.getParent();
        int braceStyle = parent instanceof GrMethod ? this.getGroovySettings().METHOD_BRACE_STYLE : this.getGroovySettings().BRACE_STYLE;
        if (this.myChildType != GroovyTokenTypes.mLCURLY && this.myChildType != GroovyTokenTypes.mRCURLY) {
            this.myResult = GroovyIndentProcessor.getIndentInBlock(braceStyle);
        }
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
        if (whileStatement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(36);
        }
        if (this.myChild == whileStatement.getBody() && !TokenSets.BLOCK_SET.contains(this.myChildType)) {
            this.myResult = Indent.getNormalIndent();
        } else if (this.myChild == whileStatement.getCondition()) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement synchronizedStatement) {
        if (synchronizedStatement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(37);
        }
        if (this.myChild == synchronizedStatement.getMonitor()) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement forStatement) {
        if (forStatement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(38);
        }
        if (this.myChild == forStatement.getBody() && !TokenSets.BLOCK_SET.contains(this.myChildType)) {
            this.myResult = Indent.getNormalIndent();
        } else if (this.myChild == forStatement.getClause()) {
            this.myResult = Indent.getContinuationWithoutFirstIndent();
        }
    }

    private CommonCodeStyleSettings getGroovySettings() {
        return this.myBlock.getContext().getSettings();
    }

    @Override
    public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
        if (expression == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(39);
        }
        this.myResult = this.myChildType == GroovyTokenTypes.mLPAREN || this.myChildType == GroovyTokenTypes.mRPAREN ? Indent.getNoneIndent() : Indent.getContinuationIndent();
    }

    public static Indent getSwitchCaseIndent(@NotNull CommonCodeStyleSettings settings) {
        if (settings == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(40);
        }
        if (settings.INDENT_CASE_FROM_SWITCH) {
            return GroovyIndentProcessor.getIndentInBlock(settings.BRACE_STYLE);
        }
        return Indent.getNoneIndent();
    }

    @Override
    public void visitParameterList(@NotNull GrParameterList parameterList) {
        if (parameterList == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(41);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitArrayDeclaration(@NotNull GrArrayDeclaration arrayDeclaration) {
        if (arrayDeclaration == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(42);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        if (expression == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(43);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitTypeArgumentList(@NotNull GrTypeArgumentList typeArgumentList) {
        if (typeArgumentList == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(44);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        if (refElement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(45);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitWildcardTypeArgument(@NotNull GrWildcardTypeArgument wildcardTypeArgument) {
        if (wildcardTypeArgument == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(46);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitAnnotationMethod(@NotNull GrAnnotationMethod annotationMethod) {
        if (annotationMethod == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(47);
        }
        if (this.myChild instanceof GrAnnotationMemberValue) {
            this.myResult = Indent.getContinuationIndent();
        } else {
            super.visitAnnotationMethod(annotationMethod);
        }
    }

    @Override
    public void visitAnnotationNameValuePair(@NotNull GrAnnotationNameValuePair nameValuePair) {
        if (nameValuePair == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(48);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        if (forInClause == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(49);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitForClause(@NotNull GrForClause forClause) {
        if (forClause == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(50);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitCatchClause(@NotNull GrCatchClause catchClause) {
        if (catchClause == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(51);
        }
        this.myResult = this.myChild == catchClause.getBody() ? GroovyIndentProcessor.getBlockIndent(this.getGroovySettings().BRACE_STYLE) : Indent.getContinuationWithoutFirstIndent();
    }

    @Override
    public void visitTryStatement(@NotNull GrTryCatchStatement tryCatchStatement) {
        if (tryCatchStatement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(52);
        }
        if (this.myChildType == GroovyElementTypes.OPEN_BLOCK) {
            this.myResult = GroovyIndentProcessor.getBlockIndent(this.getGroovySettings().BRACE_STYLE);
        }
    }

    @Override
    public void visitBlockStatement(@NotNull GrBlockStatement blockStatement) {
        if (blockStatement == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(53);
        }
        this.myResult = GroovyIndentProcessor.getBlockIndent(this.getGroovySettings().BRACE_STYLE);
    }

    @Override
    public void visitFinallyClause(@NotNull GrFinallyClause catchClause) {
        if (catchClause == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(54);
        }
        if (this.myChildType == GroovyElementTypes.OPEN_BLOCK) {
            this.myResult = GroovyIndentProcessor.getBlockIndent(this.getGroovySettings().BRACE_STYLE);
        }
    }

    @Override
    public void visitTypeParameterList(@NotNull GrTypeParameterList list) {
        if (list == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(55);
        }
        this.myResult = Indent.getContinuationWithoutFirstIndent();
    }

    @NotNull
    public static Indent getIndentInBlock(int braceStyle) {
        Indent indent = braceStyle == 3 ? Indent.getNoneIndent() : Indent.getNormalIndent();
        if (indent == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(56);
        }
        return indent;
    }

    @NotNull
    public static Indent getBlockIndent(int braceStyle) {
        Indent indent = braceStyle == 3 || braceStyle == 4 ? Indent.getNormalIndent() : Indent.getNoneIndent();
        if (indent == null) {
            GroovyIndentProcessor.$$$reportNull$$$0(57);
        }
        return indent;
    }

    public static ChildAttributes getChildSwitchIndent(GrCaseSection psiParent, int newIndex) {
        Indent indent = GroovyIndentProcessor.isFinishedCase(psiParent, newIndex) ? Indent.getNoneIndent() : Indent.getNormalIndent();
        return new ChildAttributes(indent, null);
    }

    public static boolean isFinishedCase(GrCaseSection psiParent, int newIndex) {
        PsiElement[] children = psiParent.getChildren();
        --newIndex;
        for (int i = 0; i < children.length && i < newIndex; ++i) {
            PsiElement child = children[i];
            if (!(child instanceof GrBreakStatement) && !(child instanceof GrContinueStatement) && !(child instanceof GrReturnStatement) && !(child instanceof GrThrowStatement)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertStatement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOrMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseSection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labeledStatement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 15: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationArgumentList";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDeclaration";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 24: 
            case 25: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwsClause";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementsClause";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendsClause";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinitionBody";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "synchronizedStatement";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayDeclaration";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentList";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wildcardTypeArgument";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationMethod";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameValuePair";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forInClause";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forClause";
                break;
            }
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchClause";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryCatchStatement";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/formatter/processors/GroovyIndentProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentInBlock";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 56: 
            case 57: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitAssertStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotationArrayInitializer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitListOrMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitCaseSection";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitSwitchStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitArgumentList";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitIfStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotationArgumentList";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedArgument";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitVariable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitEnumConstant";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitDocComment";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitVariableDeclaration";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitDocTag";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitConditionalExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitAssignmentExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowsClause";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitImplementsClause";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitDocMethodParameterList";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitExtendsClause";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitMethod";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeDefinition";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeDefinitionBody";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitClosure";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitOpenBlock";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileStatement";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitSynchronizedStatement";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitForStatement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchCaseIndent";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitParameterList";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayDeclaration";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitExpression";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeArgumentList";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitCodeReferenceElement";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitWildcardTypeArgument";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotationMethod";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotationNameValuePair";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitForInClause";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitForClause";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "visitCatchClause";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitTryStatement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockStatement";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitFinallyClause";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeParameterList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

