/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.AlignmentProvider;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockGenerator;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyWrappingProcessor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class ParameterListBlock
extends GroovyBlock {
    private final List<Block> mySubBlocks;
    private final TextRange myTextRange;

    @Override
    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            ParameterListBlock.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    public ParameterListBlock(@NotNull GrMethod method, @NotNull Indent indent, @Nullable Wrap wrap, @NotNull FormattingContext context) {
        if (method == null) {
            ParameterListBlock.$$$reportNull$$$0(1);
        }
        if (indent == null) {
            ParameterListBlock.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ParameterListBlock.$$$reportNull$$$0(3);
        }
        super(method.getParameterList().getNode(), indent, wrap, context);
        ASTNode methodNode = method.getNode();
        ASTNode leftParenth = methodNode.findChildByType(GroovyTokenTypes.mLPAREN);
        ASTNode rightParenth = methodNode.findChildByType(GroovyTokenTypes.mRPAREN);
        GroovyWrappingProcessor wrappingProcessor = new GroovyWrappingProcessor(this);
        this.mySubBlocks = new ArrayList<Block>();
        if (leftParenth != null) {
            this.mySubBlocks.add(new GroovyBlock(leftParenth, Indent.getNoneIndent(), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
        }
        List<ASTNode> astNodes = GroovyBlockGenerator.visibleChildren(this.myNode);
        boolean unfinished = ParameterListBlock.isParameterListUnfinished(this.myNode);
        if (this.myContext.getSettings().ALIGN_MULTILINE_PARAMETERS) {
            AlignmentProvider.Aligner aligner = this.myContext.getAlignmentProvider().createAligner(false);
            for (ASTNode node : astNodes) {
                aligner.append(node.getPsi());
            }
            if (rightParenth != null && unfinished) {
                aligner.append(rightParenth.getPsi());
            }
        }
        for (ASTNode childNode : astNodes) {
            this.mySubBlocks.add(new GroovyBlock(childNode, Indent.getContinuationIndent(), wrappingProcessor.getChildWrap(childNode), this.myContext));
        }
        if (rightParenth != null) {
            this.mySubBlocks.add(new GroovyBlock(rightParenth, unfinished ? Indent.getContinuationIndent() : Indent.getNoneIndent(), Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), this.myContext));
            if (!unfinished && this.myContext.getSettings().ALIGN_MULTILINE_METHOD_BRACKETS && leftParenth != null) {
                this.myContext.getAlignmentProvider().addPair(leftParenth, rightParenth, false);
            }
        }
        this.myTextRange = TextRange.create((int)this.mySubBlocks.get(0).getTextRange().getStartOffset(), (int)this.mySubBlocks.get(this.mySubBlocks.size() - 1).getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            ParameterListBlock.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static boolean isParameterListUnfinished(ASTNode parameterList) {
        ASTNode last = parameterList.getLastChildNode();
        return last instanceof PsiErrorElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/formatter/blocks/ParameterListBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/formatter/blocks/ParameterListBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

