/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.lang.LangBundle;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.findUsages.GroovyWordsScanner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.refactoring.rename.PropertyForRename;

public class GroovyFindUsagesProvider
implements FindUsagesProvider {
    @Nullable
    public WordsScanner getWordsScanner() {
        return new GroovyWordsScanner();
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GroovyFindUsagesProvider.$$$reportNull$$$0(0);
        }
        return psiElement instanceof PsiClass || psiElement instanceof PsiMethod || psiElement instanceof GrVariable;
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GroovyFindUsagesProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            GroovyFindUsagesProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof GrTraitTypeDefinition) {
            if ("trait" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(3);
            }
            return "trait";
        }
        if (element instanceof GrInterfaceDefinition) {
            String string = LangBundle.message((String)"java.terms.interface", (Object[])new Object[0]);
            if (string == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (element instanceof GrAnnotationTypeDefinition) {
            String string = LangBundle.message((String)"java.terms.annotation.interface", (Object[])new Object[0]);
            if (string == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (element instanceof GrEnumTypeDefinition) {
            String string = LangBundle.message((String)"java.terms.enum", (Object[])new Object[0]);
            if (string == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (element instanceof PsiClass) {
            if ("class" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(7);
            }
            return "class";
        }
        if (element instanceof PsiMethod) {
            if ("method" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(8);
            }
            return "method";
        }
        if (element instanceof PsiField) {
            if ("field" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(9);
            }
            return "field";
        }
        if (element instanceof PsiParameter) {
            if ("parameter" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(10);
            }
            return "parameter";
        }
        if (element instanceof GrBindingVariable) {
            if ("script binding variable" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(11);
            }
            return "script binding variable";
        }
        if (element instanceof PsiVariable) {
            if ("variable" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(12);
            }
            return "variable";
        }
        if (element instanceof GrLabeledStatement) {
            if ("label" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(13);
            }
            return "label";
        }
        if (element instanceof PropertyForRename) {
            if ("property" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(14);
            }
            return "property";
        }
        if (element instanceof GrClosableBlock) {
            if ("closure" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(15);
            }
            return "closure";
        }
        if (element instanceof GrExpression) {
            if ("expression" == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(16);
            }
            return "expression";
        }
        if ("" == null) {
            GroovyFindUsagesProvider.$$$reportNull$$$0(17);
        }
        return "";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element == null) {
            GroovyFindUsagesProvider.$$$reportNull$$$0(18);
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            String qName = aClass.getQualifiedName();
            String string = qName == null ? "" : qName;
            if (string == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(19);
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String result = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            PsiClass clazz = method.getContainingClass();
            if (clazz != null) {
                result = result + " of " + this.getDescriptiveName((PsiElement)clazz);
            }
            String string = result;
            if (string == null) {
                GroovyFindUsagesProvider.$$$reportNull$$$0(20);
            }
            return string;
        }
        if (element instanceof PsiVariable) {
            String name = ((PsiVariable)element).getName();
            if (name != null) {
                String string = name;
                if (string == null) {
                    GroovyFindUsagesProvider.$$$reportNull$$$0(21);
                }
                return string;
            }
        } else {
            if (element instanceof GrLabeledStatement) {
                String string = ((GrLabeledStatement)element).getName();
                if (string == null) {
                    GroovyFindUsagesProvider.$$$reportNull$$$0(22);
                }
                return string;
            }
            if (element instanceof PropertyForRename) {
                String string = ((PropertyForRename)element).getPropertyName();
                if (string == null) {
                    GroovyFindUsagesProvider.$$$reportNull$$$0(23);
                }
                return string;
            }
            if (element instanceof GrClosableBlock) {
                if ("closure" == null) {
                    GroovyFindUsagesProvider.$$$reportNull$$$0(24);
                }
                return "closure";
            }
            if (element instanceof GrLiteral) {
                String string = element.getText();
                if (string == null) {
                    GroovyFindUsagesProvider.$$$reportNull$$$0(25);
                }
                return string;
            }
        }
        if ("" == null) {
            GroovyFindUsagesProvider.$$$reportNull$$$0(26);
        }
        return "";
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element == null) {
            GroovyFindUsagesProvider.$$$reportNull$$$0(27);
        }
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getQualifiedName();
            if (name == null || !useFullName) {
                name = ((PsiClass)element).getName();
            }
            if (name != null) {
                String string = name;
                if (string == null) {
                    GroovyFindUsagesProvider.$$$reportNull$$$0(28);
                }
                return string;
            }
        } else {
            String name;
            if (element instanceof PsiMethod) {
                String string = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
                if (string == null) {
                    GroovyFindUsagesProvider.$$$reportNull$$$0(29);
                }
                return string;
            }
            if (element instanceof PsiVariable && (name = ((PsiVariable)element).getName()) != null) {
                String string = name;
                if (string == null) {
                    GroovyFindUsagesProvider.$$$reportNull$$$0(30);
                }
                return string;
            }
        }
        if ("" == null) {
            GroovyFindUsagesProvider.$$$reportNull$$$0(31);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsagesFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHelpId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptiveName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNodeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

