/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.testIntegration.GroovyTestFramework;

public class SpockTestFramework
extends GroovyTestFramework {
    @Override
    @NotNull
    public String getName() {
        if ("Spock" == null) {
            SpockTestFramework.$$$reportNull$$$0(0);
        }
        return "Spock";
    }

    @Override
    public String getLibraryPath() {
        return null;
    }

    @Override
    @Nullable
    public String getDefaultSuperClass() {
        return "spock.lang.Specification";
    }

    @Override
    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock_SetUp_Method.groovy");
    }

    @Override
    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("Spock cleanup Method.groovy");
    }

    @Override
    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        FileTemplateDescriptor fileTemplateDescriptor = new FileTemplateDescriptor("Spock Test Method.groovy");
        if (fileTemplateDescriptor == null) {
            SpockTestFramework.$$$reportNull$$$0(1);
        }
        return fileTemplateDescriptor;
    }

    @Override
    public boolean isTestMethod(PsiElement element, boolean checkAbstract) {
        return SpockUtils.isTestMethod(element);
    }

    @Override
    protected String getMarkerClassFQName() {
        return "spock.lang.Specification";
    }

    @Override
    protected boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        return clazz.getLanguage() == GroovyLanguage.INSTANCE && InheritanceUtil.isInheritor((PsiClass)clazz, (String)"spock.lang.Specification");
    }

    private PsiMethod findSpecificMethod(@NotNull PsiClass clazz, String methodName) {
        if (clazz == null) {
            SpockTestFramework.$$$reportNull$$$0(2);
        }
        if (!this.isTestClass(clazz, false)) {
            return null;
        }
        for (PsiMethod method : clazz.findMethodsByName(methodName, false)) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            return method;
        }
        return null;
    }

    @Override
    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            SpockTestFramework.$$$reportNull$$$0(3);
        }
        return this.findSpecificMethod(clazz, "setup");
    }

    @Override
    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            SpockTestFramework.$$$reportNull$$$0(4);
        }
        return this.findSpecificMethod(clazz, "cleanup");
    }

    @Override
    public char getMnemonic() {
        return 'S';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/ext/spock/SpockTestFramework";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodFileTemplateDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/ext/spock/SpockTestFramework";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSpecificMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSetUpMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTearDownMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

