/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GdkMethodHolder {
    private static final Key<CachedValue<GdkMethodHolder>> CACHED_NON_STATIC = Key.create((String)"Cached instance gdk method holder");
    private static final Key<CachedValue<GdkMethodHolder>> CACHED_STATIC = Key.create((String)"Cached static gdk method holder");
    private final String myClassName;
    private final ConcurrentMap<String, MultiMap<String, PsiMethod>> myOriginalMethodsByNameAndType;
    private final NotNullLazyValue<MultiMap<String, PsiMethod>> myOriginalMethodByType;
    private final boolean myStatic;

    private GdkMethodHolder(PsiClass categoryClass, boolean isStatic) {
        this.myClassName = categoryClass.getName();
        this.myStatic = isStatic;
        MultiMap byName = new MultiMap();
        for (PsiMethod m : categoryClass.getMethods()) {
            PsiParameter[] params = m.getParameterList().getParameters();
            if (params.length == 0 || params[0].getType() instanceof PsiPrimitiveType || !m.hasModifierProperty("public") || !m.hasModifierProperty("static") || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)m) || PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)m)) continue;
            byName.putValue((Object)m.getName(), (Object)m);
        }
        this.myOriginalMethodByType = VolatileNotNullLazyValue.createValue(() -> GdkMethodHolder.groupByType(byName.values()));
        this.myOriginalMethodsByNameAndType = ConcurrentFactoryMap.createMap(name -> GdkMethodHolder.groupByType(byName.get(name)));
    }

    @NotNull
    private static MultiMap<String, PsiMethod> groupByType(Collection<? extends PsiMethod> methods) {
        MultiMap map2 = new MultiMap();
        for (PsiMethod psiMethod : methods) {
            PsiType type = GdkMethodHolder.getCategoryTargetType(psiMethod);
            if (type == null) continue;
            map2.putValue((Object)type.getCanonicalText(), (Object)psiMethod);
        }
        MultiMap multiMap = map2;
        if (multiMap == null) {
            GdkMethodHolder.$$$reportNull$$$0(0);
        }
        return multiMap;
    }

    @Nullable
    private static PsiType getCategoryTargetType(@NotNull PsiMethod method) {
        if (method == null) {
            GdkMethodHolder.$$$reportNull$$$0(1);
        }
        PsiType parameterType = method.getParameterList().getParameters()[0].getType();
        return TypeConversionUtil.erasure((PsiType)parameterType);
    }

    public boolean processMethods(PsiScopeProcessor processor, @NotNull ResolveState state, PsiType qualifierType, Project project) {
        MultiMap map2;
        if (state == null) {
            GdkMethodHolder.$$$reportNull$$$0(2);
        }
        if (qualifierType == null) {
            return true;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String name = nameHint == null ? null : nameHint.getName(state);
        MultiMap multiMap = map2 = name != null ? (MultiMap)this.myOriginalMethodsByNameAndType.get(name) : (MultiMap)this.myOriginalMethodByType.getValue();
        if (map2.isEmpty()) {
            return true;
        }
        for (String superType : ResolveUtil.getAllSuperTypes(qualifierType, project)) {
            for (PsiMethod method : map2.get((Object)superType)) {
                String info;
                GrGdkMethod gdk = GrGdkMethodImpl.createGdkMethod(method, this.myStatic, info = GdkMethodUtil.generateOriginInfo(method));
                if (processor.execute((PsiElement)gdk, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static GdkMethodHolder getHolderForClass(PsiClass categoryClass, boolean isStatic) {
        Project project = categoryClass.getProject();
        Key<CachedValue<GdkMethodHolder>> key = isStatic ? CACHED_STATIC : CACHED_NON_STATIC;
        return (GdkMethodHolder)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)categoryClass, key, () -> {
            GdkMethodHolder result = new GdkMethodHolder(categoryClass, isStatic);
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
            VirtualFile vfile = categoryClass.getContainingFile().getVirtualFile();
            if (vfile != null && (rootManager.getFileIndex().isInLibraryClasses(vfile) || rootManager.getFileIndex().isInLibrarySource(vfile))) {
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{rootManager});
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, rootManager});
        }, false);
    }

    public String toString() {
        return "GDK Method Holder for " + this.myClassName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/dgm/GdkMethodHolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/dgm/GdkMethodHolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCategoryTargetType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

