/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypeConstants;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/PrecisionUtil;", "", "()V", "commonNegate", "", "num", "extractLiteralValue", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "isPossibleLooseOfPrecision", "", "targetType", "Lcom/intellij/psi/PsiType;", "actualType", "groovy-psi"})
public final class PrecisionUtil {
    public static final PrecisionUtil INSTANCE;

    public final boolean isPossibleLooseOfPrecision(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)targetType, (String)"targetType");
        Intrinsics.checkParameterIsNotNull((Object)actualType, (String)"actualType");
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        int targetRank = TypeConstants.getTypeRank(targetType);
        int actualRank = TypeConstants.getTypeRank(actualType);
        if (targetRank == 2 || actualRank == 2 || targetRank == 7) {
            return false;
        }
        if (actualRank == 0 || targetRank == 0 || actualRank <= targetRank) {
            return false;
        }
        Number number = this.extractLiteralValue(expression);
        if (number == null) {
            return true;
        }
        Number value = number;
        switch (targetRank) {
            case 1: {
                byte byteVal = value.byteValue();
                if (value instanceof Short) {
                    return Intrinsics.areEqual((Object)byteVal, (Object)value) ^ true;
                }
                if (value instanceof Integer) {
                    return Intrinsics.areEqual((Object)byteVal, (Object)value) ^ true;
                }
                if (value instanceof Long) {
                    return Intrinsics.areEqual((Object)byteVal, (Object)value) ^ true;
                }
                return value instanceof Float ? Intrinsics.areEqual((Object)Float.valueOf(byteVal), (Object)value) ^ true : Intrinsics.areEqual((Object)byteVal, (Object)value) ^ true;
            }
            case 3: {
                short shortVal = value.shortValue();
                if (value instanceof Integer) {
                    return Intrinsics.areEqual((Object)shortVal, (Object)value) ^ true;
                }
                if (value instanceof Long) {
                    return Intrinsics.areEqual((Object)shortVal, (Object)value) ^ true;
                }
                return value instanceof Float ? Intrinsics.areEqual((Object)Float.valueOf(shortVal), (Object)value) ^ true : Intrinsics.areEqual((Object)shortVal, (Object)value) ^ true;
            }
            case 4: {
                int intVal = value.intValue();
                if (value instanceof Long) {
                    return Intrinsics.areEqual((Object)intVal, (Object)value) ^ true;
                }
                return value instanceof Float ? Intrinsics.areEqual((Object)Float.valueOf(intVal), (Object)value) ^ true : Intrinsics.areEqual((Object)intVal, (Object)value) ^ true;
            }
            case 5: {
                long longVal = value.longValue();
                return value instanceof Float ? Intrinsics.areEqual((Object)Float.valueOf(longVal), (Object)value) ^ true : Intrinsics.areEqual((Object)longVal, (Object)value) ^ true;
            }
            case 8: {
                float floatVal = value.floatValue();
                return Intrinsics.areEqual((Object)floatVal, (Object)value) ^ true;
            }
        }
        return false;
    }

    private final Number extractLiteralValue(GrExpression expression) {
        Number number;
        Object object;
        GrExpression grExpression;
        boolean negativeNumber = false;
        GrExpression valueExpression = expression;
        if (expression instanceof GrUnaryExpression) {
            IElementType operationTokenType = ((GrUnaryExpression)expression).getOperationTokenType();
            if (CollectionsKt.listOf((Object[])new IElementType[]{GroovyTokenTypes.mPLUS, GroovyTokenTypes.mMINUS}).contains(operationTokenType)) {
                negativeNumber = Intrinsics.areEqual((Object)operationTokenType, (Object)GroovyTokenTypes.mMINUS);
                valueExpression = ((GrUnaryExpression)expression).getOperand();
            }
        }
        if (!((grExpression = valueExpression) instanceof GrLiteralImpl)) {
            grExpression = null;
        }
        if ((object = (GrLiteralImpl)grExpression) == null || (object = ((GrLiteralImpl)object).getValue()) == null) {
            return null;
        }
        Object literalValue = object;
        Object object2 = literalValue;
        if (!(object2 instanceof Number)) {
            object2 = null;
        }
        Number number2 = (Number)object2;
        if (number2 != null) {
            Number number3;
            Number it = number3 = number2;
            number = negativeNumber ? (Number)INSTANCE.commonNegate(it) : (Number)it;
        } else {
            number = null;
        }
        return number;
    }

    private final Number commonNegate(Number num) {
        Number number;
        Number number2 = num;
        if (number2 instanceof Byte) {
            number = (int)(-num.byteValue());
        } else if (number2 instanceof Short) {
            number = (int)(-num.shortValue());
        } else if (number2 instanceof Integer) {
            number = -num.intValue();
        } else if (number2 instanceof Long) {
            number = -num.longValue();
        } else if (number2 instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)num;
            BigInteger bigInteger2 = bigInteger.negate();
            Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"this.negate()");
            number = bigInteger2;
        } else if (number2 instanceof Float) {
            number = Float.valueOf(-num.floatValue());
        } else if (number2 instanceof Double) {
            number = -num.doubleValue();
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)num;
            BigDecimal bigDecimal2 = bigDecimal.negate();
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal2, (String)"this.negate()");
            number = bigDecimal2;
        } else {
            number = null;
        }
        return number;
    }

    private PrecisionUtil() {
    }

    static {
        PrecisionUtil precisionUtil;
        INSTANCE = precisionUtil = new PrecisionUtil();
    }
}

