/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.assignment.CallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ConstructorCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.DelegatingCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrBinaryExprInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrCastFix;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrChangeVariableType;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrConstructorInvocationInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrEnumConstantInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrIndexPropertyInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrListOrMapInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrMethodCallInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GrNewExpressionInfo;
import org.jetbrains.plugins.groovy.codeInspection.assignment.GroovyAssignabilityCheckInspection;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitorHelper;
import org.jetbrains.plugins.groovy.codeInspection.type.PrecisionUtil;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentUtilKt;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrBuilderMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrClosureType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.DefaultConstructor;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParamsEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.util.GrInnerClassConstructorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyIndexPropertyUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GroovyTypeCheckVisitor
extends BaseInspectionVisitor {
    private static final Logger LOG = Logger.getInstance(GroovyAssignabilityCheckInspection.class);

    private boolean checkCallApplicability(@Nullable PsiType type, boolean checkUnknownArgs, @NotNull CallInfo<? extends GroovyPsiElement> info) {
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(0);
        }
        PsiType[] argumentTypes = info.getArgumentTypes();
        GrExpression invoked = info.getInvokedExpression();
        if (invoked == null) {
            return true;
        }
        if (type instanceof GrClosureType) {
            if (argumentTypes == null) {
                return true;
            }
            GrClosureSignatureUtil.ApplicabilityResult result = PsiUtil.isApplicableConcrete(argumentTypes, (GrClosureType)type, info.getCall());
            switch (result) {
                case inapplicable: {
                    this.registerCannotApplyError(invoked.getText(), info);
                    return false;
                }
                case canBeApplicable: {
                    if (checkUnknownArgs) {
                        this.highlightUnknownArgs(info);
                    }
                    return !checkUnknownArgs;
                }
            }
            return true;
        }
        if (type != null) {
            GroovyResolveResult[] calls;
            for (GroovyResolveResult result : calls = ResolveUtil.getMethodCandidates(type, "call", (PsiElement)invoked, argumentTypes)) {
                PsiElement resolved = result.getElement();
                if (!(resolved instanceof PsiMethod && !result.isInvokedOnProperty() ? !this.checkMethodApplicability(result, checkUnknownArgs, info) : resolved instanceof PsiField && !this.checkCallApplicability(((PsiField)resolved).getType(), checkUnknownArgs && calls.length == 1, info))) continue;
                return false;
            }
            if (calls.length == 0 && !(invoked instanceof GrString)) {
                this.registerCannotApplyError(invoked.getText(), info);
            }
            return true;
        }
        return true;
    }

    private boolean checkCannotInferArgumentTypes(@NotNull CallInfo info) {
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(1);
        }
        if (info.getArgumentTypes() != null) {
            return true;
        }
        this.highlightUnknownArgs(info);
        return false;
    }

    private <T extends GroovyPsiElement> boolean checkConstructorApplicability(@NotNull GroovyResolveResult constructorResolveResult, @NotNull CallInfo<T> info, boolean checkUnknownArgs) {
        PsiType[] newTypes;
        GrExpression[] exprArgs;
        PsiElement element;
        if (constructorResolveResult == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(2);
        }
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((element = constructorResolveResult.getElement()) instanceof PsiMethod && ((PsiMethod)element).isConstructor(), (Object)element);
        PsiMethod constructor = (PsiMethod)element;
        GrArgumentList argList = info.getArgumentList();
        if (argList != null && (exprArgs = argList.getExpressionArguments()).length == 0 && !PsiUtil.isConstructorHasRequiredParameters(constructor)) {
            return true;
        }
        PsiType[] types = info.getArgumentTypes();
        PsiClass containingClass = constructor.getContainingClass();
        if (types != null && containingClass != null && (newTypes = GrInnerClassConstructorUtil.addEnclosingArgIfNeeded(types, info.getCall(), containingClass)).length != types.length) {
            return this.checkMethodApplicability(constructorResolveResult, checkUnknownArgs, new DelegatingCallInfo<T>(info){

                @Override
                @NotNull
                public PsiType[] getArgumentTypes() {
                    if (newTypes == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return newTypes;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/type/GroovyTypeCheckVisitor$1", "getArgumentTypes"));
                }
            });
        }
        return this.checkMethodApplicability(constructorResolveResult, checkUnknownArgs, info);
    }

    private void processConstructorCall(@NotNull ConstructorCallInfo<?> info) {
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(4);
        }
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getArgumentList())) {
            return;
        }
        if (!this.checkCannotInferArgumentTypes(info)) {
            return;
        }
        GroovyResolveResult[] results2 = info.multiResolve();
        boolean checkUnknowkArgs = results2.length == 1;
        for (GroovyResolveResult result : results2) {
            PsiElement resolved = result.getElement();
            if (!(resolved instanceof PsiMethod) || this.checkConstructorApplicability(result, info, checkUnknowkArgs)) continue;
            return;
        }
        if (results2.length > 1) {
            this.registerError(info.getElementToHighlight(), GroovyBundle.message("constructor.call.is.ambiguous", new Object[0]), null, ProblemHighlightType.GENERIC_ERROR);
        }
        this.checkNamedArgumentsType(info);
    }

    private boolean checkForImplicitEnumAssigning(@Nullable PsiType expectedType, @NotNull GrExpression expression, @NotNull GroovyPsiElement elementToHighlight) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(5);
        }
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(6);
        }
        if (!(expectedType instanceof PsiClassType)) {
            return false;
        }
        if (!GroovyConfigUtils.getInstance().isVersionAtLeast(elementToHighlight, "1.8")) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)expectedType).resolve();
        if (resolved == null || !resolved.isEnum()) {
            return false;
        }
        PsiType type = expression.getType();
        if (type == null) {
            return false;
        }
        if (!type.equalsToText("groovy.lang.GString") && !type.equalsToText("java.lang.String")) {
            return false;
        }
        Object result = GroovyConstantExpressionEvaluator.evaluate(expression);
        if (result == null || !(result instanceof String)) {
            this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.WEAK_WARNING, new Object[]{GroovyBundle.message("cannot.assign.string.to.enum.0", expectedType.getPresentableText())});
        } else {
            PsiField field = resolved.findFieldByName((String)result, true);
            if (!(field instanceof PsiEnumConstant)) {
                this.registerError((PsiElement)elementToHighlight, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{GroovyBundle.message("cannot.find.enum.constant.0.in.enum.1", result, expectedType.getPresentableText())});
            }
        }
        return true;
    }

    private void checkIndexProperty(@NotNull CallInfo<GrIndexProperty> info) {
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(7);
        }
        if (!this.checkCannotInferArgumentTypes(info)) {
            return;
        }
        PsiType[] types = info.getArgumentTypes();
        if (types == null) {
            return;
        }
        GroovyResolveResult[] results2 = info.multiResolve();
        GroovyResolveResult resolveResult = info.advancedResolve();
        if (resolveResult.getElement() != null) {
            PsiElement resolved = resolveResult.getElement();
            if (resolved instanceof PsiMethod && !resolveResult.isInvokedOnProperty()) {
                this.checkMethodApplicability(resolveResult, true, info);
            } else if (resolved instanceof GrField) {
                this.checkCallApplicability(((GrField)resolved).getTypeGroovy(), true, info);
            } else if (resolved instanceof PsiField) {
                this.checkCallApplicability(((PsiField)resolved).getType(), true, info);
            }
        } else if (results2.length > 0) {
            for (GroovyResolveResult result : results2) {
                PsiElement resolved = result.getElement();
                if (!(resolved instanceof PsiMethod && !result.isInvokedOnProperty() ? !this.checkMethodApplicability(result, false, info) : (resolved instanceof GrField ? !this.checkCallApplicability(((GrField)resolved).getTypeGroovy(), false, info) : resolved instanceof PsiField && !this.checkCallApplicability(((PsiField)resolved).getType(), false, info)))) continue;
                return;
            }
            this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("method.call.is.ambiguous", new Object[0])});
        } else {
            String typesString = GroovyTypeCheckVisitorHelper.buildArgTypesList(types);
            this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("cannot.find.operator.overload.method", typesString)});
        }
    }

    private <T extends GroovyPsiElement> boolean checkMethodApplicability(final @NotNull GroovyResolveResult methodResolveResult, boolean checkUnknownArgs, final @NotNull CallInfo<T> info) {
        GrReferenceExpression invoked;
        GrExpression qualifier;
        PsiType type;
        GrExpression qualifierExpression;
        PsiElement element;
        if (methodResolveResult == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(8);
        }
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(9);
        }
        if (!((element = methodResolveResult.getElement()) instanceof PsiMethod)) {
            return true;
        }
        if (element instanceof GrBuilderMethod) {
            return true;
        }
        PsiMethod method = (PsiMethod)element;
        if ("call".equals(method.getName()) && info.getInvokedExpression() instanceof GrReferenceExpression && (qualifierExpression = ((GrReferenceExpression)info.getInvokedExpression()).getQualifierExpression()) != null && (type = qualifierExpression.getType()) instanceof GrClosureType) {
            GrClosureSignatureUtil.ApplicabilityResult result = PsiUtil.isApplicableConcrete(info.getArgumentTypes(), (GrClosureType)type, info.getInvokedExpression());
            switch (result) {
                case inapplicable: {
                    this.highlightInapplicableMethodUsage(methodResolveResult, info, method);
                    return false;
                }
                case canBeApplicable: {
                    if (checkUnknownArgs) {
                        this.highlightUnknownArgs(info);
                    }
                    return !checkUnknownArgs;
                }
            }
            return true;
        }
        if (method instanceof GrGdkMethod && info.getInvokedExpression() instanceof GrReferenceExpression && (qualifier = PsiImplUtil.getRuntimeQualifier(invoked = (GrReferenceExpression)info.getInvokedExpression())) == null && method.getName().equals("call")) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(invoked.getProject());
            final GrReferenceExpression callRef = factory.createReferenceExpressionFromText("qualifier.call", invoked);
            callRef.setQualifier(invoked);
            return this.checkMethodApplicability(methodResolveResult, checkUnknownArgs, new DelegatingCallInfo<T>(info){

                @Override
                @Nullable
                public GrExpression getInvokedExpression() {
                    return callRef;
                }

                @Override
                @NotNull
                public GroovyResolveResult advancedResolve() {
                    GroovyResolveResult groovyResolveResult = methodResolveResult;
                    if (groovyResolveResult == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return groovyResolveResult;
                }

                @Override
                @NotNull
                public GroovyResolveResult[] multiResolve() {
                    GroovyResolveResult[] groovyResolveResultArray = new GroovyResolveResult[]{methodResolveResult};
                    if (groovyResolveResultArray == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return groovyResolveResultArray;
                }

                @Override
                @Nullable
                public PsiType getQualifierInstanceType() {
                    return info.getInvokedExpression().getType();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyTypeCheckVisitor$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "advancedResolve";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "multiResolve";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            });
        }
        if (info.getArgumentTypes() == null) {
            return true;
        }
        GrClosureSignatureUtil.ApplicabilityResult applicable = PsiUtil.isApplicableConcrete(info.getArgumentTypes(), method, methodResolveResult.getSubstitutor(), info.getCall(), false);
        switch (applicable) {
            case inapplicable: {
                this.highlightInapplicableMethodUsage(methodResolveResult, info, method);
                return false;
            }
            case canBeApplicable: {
                if (checkUnknownArgs) {
                    this.highlightUnknownArgs(info);
                }
                return !checkUnknownArgs;
            }
        }
        return true;
    }

    private void checkMethodCall(@NotNull CallInfo<? extends GrMethodCall> info) {
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(10);
        }
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getArgumentList())) {
            return;
        }
        if (info.getInvokedExpression() instanceof GrReferenceExpression) {
            GrExpression qualifier;
            GrReferenceExpression referenceExpression = (GrReferenceExpression)info.getInvokedExpression();
            GroovyResolveResult resolveResult = info.advancedResolve();
            GroovyResolveResult[] results2 = info.multiResolve();
            PsiElement resolved = resolveResult.getElement();
            if (resolved == null && (qualifier = referenceExpression.getQualifierExpression()) == null && GrHighlightUtil.isDeclarationAssignment(referenceExpression)) {
                return;
            }
            if (!this.checkCannotInferArgumentTypes(info)) {
                return;
            }
            if (resolved != null) {
                if (resolved instanceof PsiMethod && !resolveResult.isInvokedOnProperty()) {
                    this.checkMethodApplicability(resolveResult, true, info);
                } else {
                    this.checkCallApplicability(referenceExpression.getType(), true, info);
                }
            } else if (results2.length > 0) {
                for (GroovyResolveResult result : results2) {
                    PsiElement current = result.getElement();
                    if (!(current instanceof PsiMethod && !result.isInvokedOnProperty() ? !this.checkMethodApplicability(result, false, info) : !this.checkCallApplicability(referenceExpression.getType(), false, info))) continue;
                    return;
                }
                this.registerError(info.getElementToHighlight(), GroovyBundle.message("method.call.is.ambiguous", new Object[0]));
            }
        } else if (info.getInvokedExpression() != null) {
            PsiType type = info.getInvokedExpression().getType();
            this.checkCallApplicability(type, true, info);
        }
        this.checkNamedArgumentsType(info);
    }

    private void checkNamedArgumentsType(@NotNull CallInfo<?> info) {
        Object rawCall;
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(11);
        }
        if (!((rawCall = info.getCall()) instanceof GrCall)) {
            return;
        }
        GrCall call = (GrCall)rawCall;
        GrNamedArgument[] namedArguments = PsiUtil.getFirstMapNamedArguments(call);
        if (namedArguments.length == 0) {
            return;
        }
        Map<String, NamedArgumentDescriptor> map2 = GroovyNamedArgumentProvider.getNamedArgumentsFromAllProviders(call, null, false);
        if (map2 == null) {
            return;
        }
        this.checkNamedArguments(call, namedArguments, map2);
    }

    private void checkNamedArguments(GroovyPsiElement context, GrNamedArgument[] namedArguments, Map<String, NamedArgumentDescriptor> map2) {
        for (GrNamedArgument namedArgument : namedArguments) {
            PsiType expressionType;
            GrExpression namedArgumentExpression;
            String labelName = namedArgument.getLabelName();
            NamedArgumentDescriptor descriptor2 = map2.get(labelName);
            if (descriptor2 == null || (namedArgumentExpression = namedArgument.getExpression()) == null || GroovyTypeCheckVisitorHelper.getTupleInitializer(namedArgumentExpression) != null || PsiUtil.isRawClassMemberAccess(namedArgumentExpression) || (expressionType = TypesUtil.boxPrimitiveType(namedArgumentExpression.getType(), context.getManager(), context.getResolveScope())) == null || descriptor2.checkType(expressionType, context)) continue;
            this.registerError((PsiElement)namedArgumentExpression, ProblemHighlightType.GENERIC_ERROR, new Object[]{"Type of argument '" + labelName + "' can not be '" + expressionType.getPresentableText() + "'"});
        }
    }

    private void checkOperator(@NotNull CallInfo<? extends GrBinaryExpression> info) {
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(12);
        }
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(info.getCall())) {
            return;
        }
        if (GroovyTypeCheckVisitorHelper.isSpockTimesOperator(info.getCall())) {
            return;
        }
        GroovyResolveResult[] results2 = info.multiResolve();
        GroovyResolveResult resolveResult = info.advancedResolve();
        if (GroovyTypeCheckVisitorHelper.isOperatorWithSimpleTypes(info.getCall(), resolveResult)) {
            return;
        }
        if (!this.checkCannotInferArgumentTypes(info)) {
            return;
        }
        if (resolveResult.getElement() != null) {
            this.checkMethodApplicability(resolveResult, true, info);
        } else if (results2.length > 0) {
            for (GroovyResolveResult result : results2) {
                if (this.checkMethodApplicability(result, false, info)) continue;
                return;
            }
            this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("method.call.is.ambiguous", new Object[0])});
        }
    }

    private void highlightInapplicableMethodUsage(@NotNull GroovyResolveResult methodResolveResult, @NotNull CallInfo info, @NotNull PsiMethod method) {
        String message;
        if (methodResolveResult == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(13);
        }
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(14);
        }
        if (method == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(15);
        }
        PsiClass containingClass = method instanceof GrGdkMethod ? ((GrGdkMethod)method).getStaticMethod().getContainingClass() : method.getContainingClass();
        PsiType[] argumentTypes = info.getArgumentTypes();
        if (containingClass == null) {
            this.registerCannotApplyError(method.getName(), info);
            return;
        }
        if (method instanceof DefaultConstructor) {
            message = GroovyBundle.message("cannot.apply.default.constructor", method.getName());
        } else {
            String typesString = GroovyTypeCheckVisitorHelper.buildArgTypesList(argumentTypes);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            PsiClassType containingType = factory.createType(containingClass, methodResolveResult.getSubstitutor());
            String canonicalText = containingType.getInternalCanonicalText();
            message = method.isConstructor() ? GroovyBundle.message("cannot.apply.constructor", method.getName(), canonicalText, typesString) : GroovyBundle.message("cannot.apply.method1", method.getName(), canonicalText, typesString);
        }
        this.registerError(info.getElementToHighlight(), message, GroovyTypeCheckVisitorHelper.genCastFixes(GrClosureSignatureUtil.createSignature(methodResolveResult), argumentTypes, info.getArgumentList()), ProblemHighlightType.GENERIC_ERROR);
    }

    private void highlightUnknownArgs(@NotNull CallInfo info) {
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(16);
        }
        this.registerError(info.getElementToHighlight(), GroovyBundle.message("cannot.infer.argument.types", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.WEAK_WARNING);
    }

    private void processAssignment(@NotNull PsiType expectedType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight, @NotNull PsiElement context) {
        if (expectedType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(17);
        }
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(18);
        }
        if (toHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(19);
        }
        if (context == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(20);
        }
        this.checkPossibleLooseOfPrecision(expectedType, expression, toHighlight);
        this.processAssignment(expectedType, expression, toHighlight, "cannot.assign", context, GrTypeConverter.ApplicableTo.ASSIGNMENT);
    }

    private void processAssignment(@NotNull PsiType expectedType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight, @NotNull @PropertyKey(resourceBundle="org.jetbrains.plugins.groovy.GroovyBundle") String messageKey, @NotNull PsiElement context, @NotNull GrTypeConverter.ApplicableTo position) {
        GrListOrMap initializer;
        if (expectedType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(21);
        }
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(22);
        }
        if (toHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(23);
        }
        if (messageKey == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(24);
        }
        if (context == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(25);
        }
        if (position == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(26);
        }
        if ((initializer = GroovyTypeCheckVisitorHelper.getTupleInitializer(expression)) != null) {
            this.processConstructorCall(new GrListOrMapInfo(initializer));
            return;
        }
        if (PsiUtil.isRawClassMemberAccess(expression)) {
            return;
        }
        if (this.checkForImplicitEnumAssigning(expectedType, expression, expression)) {
            return;
        }
        PsiType actualType = expression.getType();
        if (actualType == null) {
            return;
        }
        ConversionResult result = TypesUtil.canAssign(expectedType, actualType, context, position);
        if (result == ConversionResult.OK) {
            return;
        }
        ArrayList fixes = ContainerUtil.newArrayList();
        fixes.add(new GrCastFix(expectedType, expression));
        String varName = GroovyTypeCheckVisitorHelper.getLValueVarName(toHighlight);
        if (varName != null) {
            fixes.add(new GrChangeVariableType(actualType, varName));
        }
        String message = GroovyBundle.message(messageKey, actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError(toHighlight, message, fixes.toArray(new LocalQuickFix[fixes.size()]), result == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private void processAssignment(@NotNull PsiType lType, @Nullable PsiType rType, @NotNull GroovyPsiElement context, @NotNull PsiElement elementToHighlight) {
        if (lType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(27);
        }
        if (context == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(28);
        }
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(29);
        }
        if (rType == null) {
            return;
        }
        ConversionResult result = TypesUtil.canAssign(lType, rType, context, GrTypeConverter.ApplicableTo.ASSIGNMENT);
        this.processResult(result, elementToHighlight, "cannot.assign", lType, rType, LocalQuickFix.EMPTY_ARRAY);
    }

    protected void processAssignmentWithinMultipleAssignment(@Nullable PsiType targetType, @Nullable PsiType actualType, @NotNull PsiElement context, @NotNull PsiElement elementToHighlight) {
        if (context == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(30);
        }
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(31);
        }
        if (targetType == null || actualType == null) {
            return;
        }
        ConversionResult result = TypesUtil.canAssignWithinMultipleAssignment(targetType, actualType, context);
        if (result == ConversionResult.OK) {
            return;
        }
        this.registerError(elementToHighlight, GroovyBundle.message("cannot.assign", actualType.getPresentableText(), targetType.getPresentableText()), LocalQuickFix.EMPTY_ARRAY, result == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(32);
        }
        super.visitTupleAssignmentExpression(expression);
        GrExpression initializer = expression.getRValue();
        if (initializer == null) {
            return;
        }
        GrTuple tupleExpression = expression.getLValue();
        GrReferenceExpression[] lValues = tupleExpression.getExpressions();
        if (initializer instanceof GrListOrMap) {
            GrExpression[] initializers = ((GrListOrMap)initializer).getInitializers();
            for (int i = 0; i < lValues.length; ++i) {
                GrReferenceExpression lValue = lValues[i];
                if (initializers.length > i) {
                    GrExpression rValue = initializers[i];
                    this.processAssignmentWithinMultipleAssignment(lValue.getType(), rValue.getType(), expression, rValue);
                    continue;
                }
                break;
            }
        } else {
            PsiType type = initializer.getType();
            PsiType rType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
            for (GrReferenceExpression lValue : lValues) {
                PsiType lType = lValue.getNominalType();
                if (PsiImplUtil.isSpreadAssignment(lValue)) {
                    PsiType argType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lType, (boolean)false);
                    if (argType != null && rType != null) {
                        this.processAssignment(argType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
                    }
                    return;
                }
                if (lValue instanceof GrReferenceExpression && lValue.resolve() instanceof GrReferenceExpression) {
                    return;
                }
                if (lType == null || rType == null) continue;
                this.processAssignment(lType, rType, tupleExpression, GroovyTypeCheckVisitorHelper.getExpressionPartToHighlight(lValue));
            }
        }
    }

    private void processResult(@NotNull ConversionResult result, @NotNull PsiElement elementToHighlight, @NotNull @PropertyKey(resourceBundle="org.jetbrains.plugins.groovy.GroovyBundle") String messageKey, @NotNull PsiType lType, @NotNull PsiType rType, @NotNull LocalQuickFix[] fixes) {
        if (result == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(33);
        }
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(34);
        }
        if (messageKey == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(35);
        }
        if (lType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(36);
        }
        if (rType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(37);
        }
        if (fixes == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(38);
        }
        if (result == ConversionResult.OK) {
            return;
        }
        this.registerError(elementToHighlight, GroovyBundle.message(messageKey, rType.getPresentableText(), lType.getPresentableText()), fixes, result == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    protected void processReturnValue(@NotNull GrExpression expression, @NotNull PsiElement context, @NotNull PsiElement elementToHighlight) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(39);
        }
        if (context == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(40);
        }
        if (elementToHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(41);
        }
        if (GroovyTypeCheckVisitorHelper.getTupleInitializer(expression) != null) {
            return;
        }
        PsiType returnType = PsiImplUtil.inferReturnType(expression);
        if (returnType == null || PsiType.VOID.equals((Object)returnType)) {
            return;
        }
        this.processAssignment(returnType, expression, elementToHighlight, "cannot.return.type", context, GrTypeConverter.ApplicableTo.RETURN_VALUE);
    }

    private void registerCannotApplyError(@NotNull String invokedText, @NotNull CallInfo info) {
        if (invokedText == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(42);
        }
        if (info == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(43);
        }
        if (info.getArgumentTypes() == null) {
            return;
        }
        String typesString = GroovyTypeCheckVisitorHelper.buildArgTypesList(info.getArgumentTypes());
        this.registerError(info.getElementToHighlight(), ProblemHighlightType.GENERIC_ERROR, new Object[]{GroovyBundle.message("cannot.apply.method.or.closure", invokedText, typesString)});
    }

    @Override
    protected void registerError(@NotNull PsiElement location, @NotNull String description, @Nullable LocalQuickFix[] fixes, ProblemHighlightType highlightType) {
        if (location == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(44);
        }
        if (description == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(45);
        }
        if (PsiUtil.isCompileStatic(location)) {
            if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
                super.registerError(location, description, fixes, highlightType);
            }
        } else if (highlightType == ProblemHighlightType.GENERIC_ERROR) {
            super.registerError(location, description, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        } else {
            super.registerError(location, description, fixes, highlightType);
        }
    }

    @Override
    public void visitEnumConstant(@NotNull GrEnumConstant enumConstant) {
        if (enumConstant == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(46);
        }
        super.visitEnumConstant(enumConstant);
        GrEnumConstantInfo info = new GrEnumConstantInfo(enumConstant);
        this.processConstructorCall(info);
        this.checkNamedArgumentsType(info);
    }

    @Override
    public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
        if (returnStatement == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(47);
        }
        super.visitReturnStatement(returnStatement);
        GrExpression value = returnStatement.getReturnValue();
        if (value != null) {
            this.processReturnValue(value, returnStatement, returnStatement.getReturnWord());
        }
    }

    @Override
    public void visitThrowStatement(@NotNull GrThrowStatement throwStatement) {
        if (throwStatement == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(48);
        }
        super.visitThrowStatement(throwStatement);
        GrExpression exception = throwStatement.getException();
        if (exception == null) {
            return;
        }
        PsiElement throwWord = throwStatement.getFirstChild();
        this.processAssignment((PsiType)PsiType.getJavaLangThrowable((PsiManager)throwStatement.getManager(), (GlobalSearchScope)throwStatement.getResolveScope()), exception, throwWord, throwWord);
    }

    @Override
    public void visitExpression(@NotNull GrExpression expression) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(49);
        }
        super.visitExpression(expression);
        if (GroovyTypeCheckVisitorHelper.isImplicitReturnStatement(expression)) {
            this.processReturnValue(expression, expression, expression);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(50);
        }
        super.visitMethodCallExpression(methodCallExpression);
        this.checkMethodCall(new GrMethodCallInfo(methodCallExpression));
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        if (newExpression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(51);
        }
        super.visitNewExpression(newExpression);
        if (newExpression.getArrayCount() > 0) {
            return;
        }
        GrCodeReferenceElement refElement = newExpression.getReferenceElement();
        if (refElement == null) {
            return;
        }
        GrNewExpressionInfo info = new GrNewExpressionInfo(newExpression);
        this.processConstructorCall(info);
    }

    @Override
    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
        if (applicationStatement == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(52);
        }
        super.visitApplicationStatement(applicationStatement);
        this.checkMethodCall(new GrMethodCallInfo(applicationStatement));
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression assignment) {
        PsiType targetType;
        if (assignment == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(53);
        }
        super.visitAssignmentExpression(assignment);
        GrExpression lValue = assignment.getLValue();
        if (!PsiUtil.mightBeLValue(lValue)) {
            return;
        }
        IElementType opToken = assignment.getOperationTokenType();
        if (opToken != GroovyTokenTypes.mASSIGN) {
            return;
        }
        GrExpression rValue = assignment.getRValue();
        if (rValue == null) {
            return;
        }
        if (lValue instanceof GrReferenceExpression && ((GrReferenceExpression)lValue).resolve() instanceof GrReferenceExpression) {
            return;
        }
        PsiType lValueNominalType = lValue.getNominalType();
        PsiType psiType = targetType = PsiImplUtil.isSpreadAssignment(lValue) ? com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)lValueNominalType, (boolean)false) : lValueNominalType;
        if (targetType == null) {
            return;
        }
        this.processAssignment(targetType, rValue, (PsiElement)lValue, (PsiElement)assignment);
    }

    void checkPossibleLooseOfPrecision(@NotNull PsiType targetType, @NotNull GrExpression expression, @NotNull PsiElement toHighlight) {
        PsiType actualType;
        if (targetType == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(54);
        }
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(55);
        }
        if (toHighlight == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(56);
        }
        if ((actualType = expression.getType()) == null) {
            return;
        }
        if (!PrecisionUtil.INSTANCE.isPossibleLooseOfPrecision(targetType, actualType, expression)) {
            return;
        }
        this.registerError(toHighlight, GroovyBundle.message("loss.of.precision", actualType.getPresentableText(), targetType.getPresentableText()), new LocalQuickFix[]{new GrCastFix(targetType, expression, false)}, ProblemHighlightType.GENERIC_ERROR);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression binary) {
        if (binary == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(57);
        }
        super.visitBinaryExpression(binary);
        this.checkOperator(new GrBinaryExprInfo(binary));
    }

    @Override
    public void visitCastExpression(@NotNull GrTypeCastExpression expression) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(58);
        }
        super.visitCastExpression(expression);
        GrExpression operand = expression.getOperand();
        if (operand == null) {
            return;
        }
        PsiType actualType = operand.getType();
        if (actualType == null) {
            return;
        }
        if (expression.getCastTypeElement() == null) {
            return;
        }
        PsiType expectedType = expression.getCastTypeElement().getType();
        ConversionResult result = TypesUtil.canCast(expectedType, actualType, expression);
        if (result == ConversionResult.OK) {
            return;
        }
        ProblemHighlightType highlightType = result == ConversionResult.ERROR ? ProblemHighlightType.GENERIC_ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        String message = GroovyBundle.message("cannot.cast", actualType.getPresentableText(), expectedType.getPresentableText());
        this.registerError((PsiElement)expression, highlightType, new Object[]{message});
    }

    @Override
    public void visitIndexProperty(@NotNull GrIndexProperty expression) {
        if (expression == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(59);
        }
        super.visitIndexProperty(expression);
        if (GroovyTypeCheckVisitorHelper.hasErrorElements(expression)) {
            return;
        }
        if (GroovyIndexPropertyUtil.isClassLiteral(expression)) {
            return;
        }
        if (GroovyIndexPropertyUtil.isSimpleArrayAccess(expression)) {
            return;
        }
        if (expression.getRValueReference() != null) {
            this.checkIndexProperty(new GrIndexPropertyInfo(expression, true));
        }
        if (expression.getLValueReference() != null) {
            this.checkIndexProperty(new GrIndexPropertyInfo(expression, false));
        }
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (method == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(60);
        }
        super.visitMethod(method);
        PsiTypeParameter[] parameters = method.getTypeParameters();
        HashMap map2 = ContainerUtil.newHashMap();
        for (PsiTypeParameter parameter : parameters) {
            PsiClassType[] types = parameter.getSuperTypes();
            PsiType bound = PsiIntersectionType.createIntersection((PsiType[])types);
            PsiWildcardType wildcardType = PsiWildcardType.createExtends((PsiManager)method.getManager(), (PsiType)bound);
            map2.put(parameter, wildcardType);
        }
        PsiSubstitutor substitutor = PsiSubstitutorImpl.createSubstitutor((Map)map2);
        for (GrParameter parameter : method.getParameterList().getParameters()) {
            GrExpression initializer = parameter.getInitializerGroovy();
            if (initializer == null) continue;
            PsiType targetType = parameter.getType();
            this.processAssignment(substitutor.substitute(targetType), initializer, parameter.getNameIdentifierGroovy(), (PsiElement)method);
        }
    }

    @Override
    public void visitConstructorInvocation(@NotNull GrConstructorInvocation invocation) {
        if (invocation == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(61);
        }
        super.visitConstructorInvocation(invocation);
        GrConstructorInvocationInfo info = new GrConstructorInvocationInfo(invocation);
        this.processConstructorCall(info);
        this.checkNamedArgumentsType(info);
    }

    @Override
    public void visitParameterList(@NotNull GrParameterList parameterList) {
        if (parameterList == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(62);
        }
        super.visitParameterList(parameterList);
        PsiElement parent = parameterList.getParent();
        if (!(parent instanceof GrClosableBlock)) {
            return;
        }
        Object[] parameters = parameterList.getParameters();
        if (parameters.length > 0) {
            List<PsiType[]> signatures = ClosureParamsEnhancer.findFittingSignatures((GrClosableBlock)parent);
            List paramTypes = ContainerUtil.map((Object[])parameters, parameter -> parameter.getType());
            if (signatures.size() > 1) {
                PsiType[] fittingSignature = (PsiType[])ContainerUtil.find(signatures, types -> {
                    if (parameterList == null) {
                        GroovyTypeCheckVisitor.$$$reportNull$$$0(67);
                    }
                    for (int i = 0; i < ((PsiType[])types).length; ++i) {
                        if (TypesUtil.isAssignableByMethodCallConversion((PsiType)paramTypes.get(i), types[i], parameterList)) continue;
                        return false;
                    }
                    return true;
                });
                if (fittingSignature == null) {
                    this.registerError((PsiElement)parameterList, GroovyInspectionBundle.message("no.applicable.signature.found", new Object[0]), null, ProblemHighlightType.GENERIC_ERROR);
                }
            } else if (signatures.size() == 1) {
                PsiType[] types2 = signatures.get(0);
                for (int i = 0; i < types2.length; ++i) {
                    GrTypeElement typeElement = parameters[i].getTypeElementGroovy();
                    if (typeElement == null) continue;
                    PsiType expected = types2[i];
                    PsiType actual = (PsiType)paramTypes.get(i);
                    if (TypesUtil.isAssignableByMethodCallConversion(actual, expected, parameterList)) continue;
                    this.registerError((PsiElement)typeElement, GroovyInspectionBundle.message("expected.type.0", expected.getCanonicalText(false), actual.getCanonicalText(false)), null, ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }
    }

    @Override
    public void visitForInClause(@NotNull GrForInClause forInClause) {
        if (forInClause == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(63);
        }
        super.visitForInClause(forInClause);
        GrVariable variable = forInClause.getDeclaredVariable();
        GrExpression iterated = forInClause.getIteratedExpression();
        if (variable == null || iterated == null) {
            return;
        }
        PsiType iteratedType = ClosureParameterEnhancer.findTypeForIteration(iterated, (PsiElement)forInClause);
        if (iteratedType == null) {
            return;
        }
        PsiType targetType = variable.getType();
        ConversionResult result = TypesUtil.canAssign(targetType, iteratedType, forInClause, GrTypeConverter.ApplicableTo.ASSIGNMENT);
        LocalQuickFix[] fixes = new LocalQuickFix[]{new GrCastFix((PsiType)TypesUtil.createListType(iterated, targetType), iterated)};
        this.processResult(result, variable, "cannot.assign", targetType, iteratedType, fixes);
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        GrExpression initializer;
        if (variable == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(64);
        }
        super.visitVariable(variable);
        PsiType varType = variable.getType();
        PsiElement parent = variable.getParent();
        if (variable instanceof GrParameter && ((GrParameter)variable).getDeclarationScope() instanceof GrMethod || parent instanceof GrForInClause) {
            return;
        }
        if (parent instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent).isTuple()) {
            GrVariableDeclaration tuple = (GrVariableDeclaration)parent;
            GrExpression initializer2 = tuple.getTupleInitializer();
            if (initializer2 == null) {
                return;
            }
            if (!(initializer2 instanceof GrListOrMap) && !PsiUtil.isCompileStatic(variable)) {
                PsiType type = initializer2.getType();
                if (type == null) {
                    return;
                }
                PsiType valueType = com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
                this.processAssignment(varType, valueType, tuple, variable.getNameIdentifierGroovy());
                return;
            }
        }
        if ((initializer = variable.getInitializerGroovy()) == null) {
            return;
        }
        this.processAssignment(varType, initializer, variable.getNameIdentifierGroovy(), (PsiElement)variable);
    }

    @Override
    public void visitListOrMap(@NotNull GrListOrMap listOrMap) {
        if (listOrMap == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(65);
        }
        super.visitListOrMap(listOrMap);
        Map<String, NamedArgumentDescriptor> descriptors = NamedArgumentUtilKt.getDescriptors(listOrMap);
        if (descriptors.isEmpty()) {
            return;
        }
        GrNamedArgument[] namedArguments = listOrMap.getNamedArguments();
        if (namedArguments.length == 0) {
            return;
        }
        this.checkNamedArguments(listOrMap, namedArguments, descriptors);
    }

    @Override
    protected void registerError(@NotNull PsiElement location, ProblemHighlightType highlightType, Object ... args) {
        if (location == null) {
            GroovyTypeCheckVisitor.$$$reportNull$$$0(66);
        }
        this.registerError(location, (String)args[0], LocalQuickFix.EMPTY_ARRAY, highlightType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorResolveResult";
                break;
            }
            case 5: 
            case 18: 
            case 22: 
            case 32: 
            case 39: 
            case 49: 
            case 55: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 29: 
            case 31: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodResolveResult";
                break;
            }
            case 15: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 19: 
            case 23: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toHighlight";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 30: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokedText";
                break;
            }
            case 44: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstant";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationStatement";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binary";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 62: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forInClause";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOrMap";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyTypeCheckVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCallApplicability";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCannotInferArgumentTypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstructorApplicability";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processConstructorCall";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForImplicitEnumAssigning";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIndexProperty";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodApplicability";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodCall";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNamedArgumentsType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOperator";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightInapplicableMethodUsage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightUnknownArgs";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "processAssignment";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "processAssignmentWithinMultipleAssignment";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTupleAssignmentExpression";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "processResult";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "processReturnValue";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCannotApplyError";
                break;
            }
            case 44: 
            case 45: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "visitEnumConstant";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReturnStatement";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThrowStatement";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExpression";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "visitApplicationStatement";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPossibleLooseOfPrecision";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCastExpression";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIndexProperty";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethod";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstructorInvocation";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParameterList";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForInClause";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariable";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[2] = "visitListOrMap";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$visitParameterList$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

