/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyTypeCheckVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTupleAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public class GroovyStaticTypeCheckVisitor
extends GroovyTypeCheckVisitor {
    private AnnotationHolder myHolder;

    @Override
    public void visitTupleAssignmentExpression(@NotNull GrTupleAssignmentExpression expression) {
        if (expression == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(0);
        }
        super.visitTupleAssignmentExpression(expression);
        GrExpression initializer = expression.getRValue();
        if (initializer != null) {
            PsiType[] types = (PsiType[])Arrays.stream(expression.getLValue().getExpressions()).map(it -> it.getType()).toArray(PsiType[]::new);
            this.checkTupleAssignment(initializer, types);
        }
    }

    @Override
    public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
        GrExpression initializer;
        if (variableDeclaration == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(1);
        }
        if (variableDeclaration.isTuple() && (initializer = variableDeclaration.getTupleInitializer()) != null) {
            PsiType[] types = (PsiType[])Arrays.stream(variableDeclaration.getVariables()).map(it -> it.getType()).toArray(PsiType[]::new);
            this.checkTupleAssignment(initializer, types);
        }
        super.visitVariableDeclaration(variableDeclaration);
    }

    void checkTupleAssignment(@NotNull GrExpression initializer, @NotNull PsiType[] types) {
        if (initializer == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(2);
        }
        if (types == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(3);
        }
        if (initializer instanceof GrListOrMap && !((GrListOrMap)initializer).isMap()) {
            GrListOrMap initializerList = (GrListOrMap)initializer;
            GrExpression[] expressions = initializerList.getInitializers();
            if (types.length > expressions.length) {
                this.registerError((PsiElement)initializer, GroovyBundle.message("incorrect.number.of.values", types.length, expressions.length), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR);
            }
            return;
        }
        this.registerError((PsiElement)initializer, GroovyBundle.message("multiple.assignments.without.list.expr", new Object[0]), new LocalQuickFix[]{GroovyQuickFixFactory.getInstance().createMultipleAssignmentFix(types.length)}, ProblemHighlightType.GENERIC_ERROR);
    }

    @Override
    protected void registerError(final @NotNull PsiElement location, final @NotNull String description, final @Nullable LocalQuickFix[] fixes, final ProblemHighlightType highlightType) {
        if (location == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(4);
        }
        if (description == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(5);
        }
        if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
            return;
        }
        ArrayList intentions = ContainerUtil.newArrayList();
        if (fixes != null) {
            for (final LocalQuickFix fix : fixes) {
                intentions.add(new IntentionAction(){

                    @NotNull
                    public String getText() {
                        String string = fix.getName();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    @NotNull
                    public String getFamilyName() {
                        String string = fix.getFamilyName();
                        if (string == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string;
                    }

                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return true;
                    }

                    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
                        if (project == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        InspectionManager manager = InspectionManager.getInstance((Project)project);
                        ProblemDescriptor descriptor2 = manager.createProblemDescriptor(location, description, fixes, highlightType, fixes.length == 1, false);
                        fix.applyFix(project, (CommonProblemDescriptor)descriptor2);
                    }

                    public boolean startInWriteAction() {
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 2: 
                            case 3: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 2: 
                            case 3: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyStaticTypeCheckVisitor$1";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "project";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getText";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getFamilyName";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyStaticTypeCheckVisitor$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "isAvailable";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "invoke";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 2: 
                            case 3: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
            }
        }
        this.registerError(location, description, intentions.toArray(new IntentionAction[intentions.size()]), highlightType);
    }

    protected void registerError(@NotNull PsiElement location, @NotNull String description, @Nullable IntentionAction[] fixes, ProblemHighlightType highlightType) {
        if (location == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(6);
        }
        if (description == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(7);
        }
        if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
            return;
        }
        Annotation annotation = this.myHolder.createErrorAnnotation(location, description);
        if (fixes == null) {
            return;
        }
        for (IntentionAction intention : fixes) {
            annotation.registerFix(intention);
        }
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(8);
        }
    }

    public void accept(@NotNull GroovyPsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(10);
        }
        this.myHolder = holder;
        try {
            element.accept(this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitSpreadArgument(@NotNull GrSpreadArgument spreadArgument) {
        if (spreadArgument == null) {
            GroovyStaticTypeCheckVisitor.$$$reportNull$$$0(11);
        }
        this.registerError((PsiElement)spreadArgument, GroovyBundle.message("spread.operator.is.not.available", new Object[0]), GroovyStaticTypeCheckVisitor.buildSpreadArgumentFix(spreadArgument), ProblemHighlightType.GENERIC_ERROR);
    }

    private static LocalQuickFix[] buildSpreadArgumentFix(GrSpreadArgument spreadArgument) {
        GrCallExpression parent = (GrCallExpression)PsiTreeUtil.getParentOfType((PsiElement)spreadArgument, GrCallExpression.class);
        if (parent == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        PsiMethod resolveMethod = parent.resolveMethod();
        if (resolveMethod == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{GroovyQuickFixFactory.getInstance().createSpreadArgumentFix(resolveMethod.getParameters().length)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDeclaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spreadArgument";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/type/GroovyStaticTypeCheckVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTupleAssignmentExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariableDeclaration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTupleAssignment";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSpreadArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

