/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.resources;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class TypeCustomizerInspection
extends BaseInspection {
    private static final HashSet<String> CUSTOMIZER_EVENT_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"setup", "finish", "unresolvedVariable", "unresolvedProperty", "unresolvedAttribute", "beforeMethodCall", "afterMethodCall", "onMethodSelection", "methodNotFound", "beforeVisitMethod", "afterVisitMethod", "beforeVisitClass", "afterVisitClass", "incompatibleAssignment"});

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitFile(@NotNull GroovyFileBase file) {
                CompilerConfiguration configuration;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((configuration = CompilerConfiguration.getInstance((Project)file.getProject())) != null && !configuration.isResourceFile(file.getVirtualFile()) && TypeCustomizerInspection.fileSeemsToBeTypeCustomizer(file)) {
                    LocalQuickFix[] fixes = new LocalQuickFix[]{new AddToResourceFix(file)};
                    String message = GroovyInspectionBundle.message("type.customizer.is.not.marked.as.a.resource.file", new Object[0]);
                    this.registerError((PsiElement)file, message, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection$1", "visitFile"));
            }
        };
        if (baseInspectionVisitor == null) {
            TypeCustomizerInspection.$$$reportNull$$$0(0);
        }
        return baseInspectionVisitor;
    }

    public static boolean fileSeemsToBeTypeCustomizer(@NotNull PsiFile file) {
        if (file == null) {
            TypeCustomizerInspection.$$$reportNull$$$0(1);
        }
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript()) {
            for (GrStatement statement : ((GroovyFile)file).getStatements()) {
                GrExpression invoked;
                if (!(statement instanceof GrMethodCall) || !((invoked = ((GrMethodCall)statement).getInvokedExpression()) instanceof GrReferenceExpression) || ((GrReferenceExpression)invoked).isQualified() || !TypeCustomizerInspection.isCustomizerEvent(((GrReferenceExpression)invoked).getReferenceName())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCustomizerEvent(@Nullable String name) {
        return CUSTOMIZER_EVENT_NAMES.contains(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fileSeemsToBeTypeCustomizer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddToResourceFix
    implements LocalQuickFix {
        private final PsiFile myFile;

        public AddToResourceFix(PsiFile file) {
            this.myFile = file;
        }

        @NotNull
        public String getName() {
            String string = GroovyInspectionBundle.message("add.to.resources", new Object[0]);
            if (string == null) {
                AddToResourceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = GroovyInspectionBundle.message("add.type.customizer.to.resources", new Object[0]);
            if (string == null) {
                AddToResourceFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            VirtualFile virtualFile;
            if (project == null) {
                AddToResourceFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                AddToResourceFix.$$$reportNull$$$0(3);
            }
            if ((virtualFile = this.myFile.getVirtualFile()) == null) {
                return;
            }
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            VirtualFile contentRoot = fileIndex.getContentRootForFile(virtualFile);
            if (contentRoot == null) {
                return;
            }
            VirtualFile sourceRoot = fileIndex.getSourceRootForFile(virtualFile);
            if (sourceRoot == null) {
                String path = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)contentRoot, (char)'/');
                CompilerConfiguration.getInstance((Project)project).addResourceFilePattern(path);
            } else {
                String path = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)sourceRoot, (char)'/');
                String sourceRootPath = VfsUtilCore.getRelativePath((VirtualFile)sourceRoot, (VirtualFile)contentRoot, (char)'/');
                CompilerConfiguration.getInstance((Project)project).addResourceFilePattern(sourceRootPath + ':' + path);
            }
            DaemonCodeAnalyzer.getInstance((Project)project).restart(this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection$AddToResourceFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/resources/TypeCustomizerInspection$AddToResourceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

