/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.ChangeToOperatorInspection;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;

class AsBooleanTransformation
extends Transformation {
    public static final String NEGATION = GroovyTokenTypes.mLNOT.toString();
    public static final String DOUBLE_NEGATION = NEGATION + NEGATION;

    AsBooleanTransformation() {
    }

    @Nullable
    protected String getPrefix(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            AsBooleanTransformation.$$$reportNull$$$0(0);
        }
        if (options == null) {
            AsBooleanTransformation.$$$reportNull$$$0(1);
        }
        if (AsBooleanTransformation.isImplicitlyBoolean(methodCall)) {
            return "";
        }
        if (options.useDoubleNegation()) {
            return DOUBLE_NEGATION;
        }
        return null;
    }

    @Override
    public void apply(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            AsBooleanTransformation.$$$reportNull$$$0(2);
        }
        if (options == null) {
            AsBooleanTransformation.$$$reportNull$$$0(3);
        }
        GrInspectionUtil.replaceExpression(methodCall, this.getPrefix(methodCall, options) + Objects.requireNonNull(AsBooleanTransformation.getBase(methodCall)).getText());
    }

    @Override
    public boolean couldApplyInternal(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        if (methodCall == null) {
            AsBooleanTransformation.$$$reportNull$$$0(4);
        }
        if (options == null) {
            AsBooleanTransformation.$$$reportNull$$$0(5);
        }
        return AsBooleanTransformation.getBase(methodCall) != null && methodCall.getExpressionArguments().length == 0 && this.getPrefix(methodCall, options) != null && methodCall.getClosureArguments().length == 0;
    }

    @Override
    protected boolean needParentheses(@NotNull GrMethodCall methodCall, @NotNull ChangeToOperatorInspection.Options options) {
        String prefix;
        if (methodCall == null) {
            AsBooleanTransformation.$$$reportNull$$$0(6);
        }
        if (options == null) {
            AsBooleanTransformation.$$$reportNull$$$0(7);
        }
        return DOUBLE_NEGATION.equals(prefix = this.getPrefix(methodCall, options)) && ParenthesesUtils.checkPrecedence(ParenthesesUtils.PREFIX_PRECEDENCE, (GrExpression)methodCall);
    }

    private static boolean isImplicitlyBoolean(GrMethodCall methodCall) {
        PsiElement parent = methodCall.getParent();
        if (parent instanceof GrIfStatement || parent instanceof GrWhileStatement) {
            return true;
        }
        if (parent instanceof GrConditionalExpression && ((GrConditionalExpression)parent).getCondition().equals(methodCall)) {
            return true;
        }
        if (parent instanceof GrUnaryExpression && PsiType.BOOLEAN.equals((Object)((GrUnaryExpression)parent).getType())) {
            return true;
        }
        return parent instanceof GrBinaryExpression && PsiType.BOOLEAN.equals((Object)((GrBinaryExpression)parent).getType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrefix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "couldApplyInternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "needParentheses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

