/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.actions.GroovySourceFolderDetector;
import org.jetbrains.plugins.groovy.actions.GroovyTemplatesFactory;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.projectRoots.RootTypesKt;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class NewGroovyClassAction
extends JavaCreateTemplateInPackageAction<GrTypeDefinition>
implements DumbAware {
    public NewGroovyClassAction() {
        super(GroovyBundle.message("newclass.menu.action.text", new Object[0]), GroovyBundle.message("newclass.menu.action.description", new Object[0]), JetgroovyIcons.Groovy.Class, RootTypesKt.ROOT_TYPES);
    }

    protected void buildDialog(final Project project, PsiDirectory directory, CreateFileFromTemplateDialog.Builder builder) {
        builder.setTitle(GroovyBundle.message("newclass.dlg.title", new Object[0])).addKind("Class", JetgroovyIcons.Groovy.Class, "Groovy Class.groovy").addKind("Interface", JetgroovyIcons.Groovy.Interface, "Groovy Interface.groovy");
        if (GroovyConfigUtils.getInstance().isVersionAtLeast((PsiElement)directory, "2.3", true)) {
            builder.addKind("Trait", JetgroovyIcons.Groovy.Trait, "Groovy Trait.groovy");
        }
        builder.addKind("Enum", JetgroovyIcons.Groovy.Enum, "Groovy Enum.groovy").addKind("Annotation", JetgroovyIcons.Groovy.AnnotationType, "Groovy Annotation.groovy");
        for (FileTemplate template : FileTemplateManager.getInstance((Project)project).getAllTemplates()) {
            FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension());
            if (!fileType.equals((Object)GroovyFileType.GROOVY_FILE_TYPE) || JavaDirectoryService.getInstance().getPackage(directory) == null) continue;
            builder.addKind(template.getName(), JetgroovyIcons.Groovy.Class, template.getName());
        }
        builder.setValidator((InputValidator)new InputValidatorEx(){

            public String getErrorText(String inputString) {
                return "This is not a valid Groovy qualified name";
            }

            public boolean checkInput(String inputString) {
                return true;
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString) && PsiNameHelper.getInstance((Project)project).isQualifiedName(inputString);
            }
        });
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && LibrariesUtil.hasGroovySdk((Module)LangDataKeys.MODULE.getData(dataContext));
    }

    protected String getActionName(PsiDirectory directory, String newName, String templateName) {
        return GroovyBundle.message("newclass.menu.action.text", new Object[0]);
    }

    protected PsiElement getNavigationElement(@NotNull GrTypeDefinition createdElement) {
        if (createdElement == null) {
            NewGroovyClassAction.$$$reportNull$$$0(0);
        }
        return createdElement.getLBrace();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (!presentation.isVisible()) {
            return;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(e.getDataContext());
        if (view == null) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isInSourceContent(dir.getVirtualFile()) || !this.checkPackageExists(dir)) continue;
            for (GroovySourceFolderDetector detector : (GroovySourceFolderDetector[])GroovySourceFolderDetector.EP_NAME.getExtensions()) {
                if (!detector.isGroovySourceFolder(dir)) continue;
                presentation.setWeight(42.0);
                break;
            }
            return;
        }
    }

    protected final GrTypeDefinition doCreate(PsiDirectory dir, String className, String templateName) throws IncorrectOperationException {
        String fileName = className + ".groovy";
        PsiFile fromTemplate = GroovyTemplatesFactory.createFromTemplate(dir, className, fileName, templateName, true, new String[0]);
        if (fromTemplate instanceof GroovyFile) {
            CodeStyleManager.getInstance((PsiManager)fromTemplate.getManager()).reformat((PsiElement)fromTemplate);
            return ((GroovyFile)fromTemplate).getTypeDefinitions()[0];
        }
        String description = fromTemplate.getFileType().getDescription();
        throw new IncorrectOperationException(GroovyBundle.message("groovy.file.extension.is.not.mapped.to.groovy.file.type", description));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdElement", "org/jetbrains/plugins/groovy/actions/NewGroovyClassAction", "getNavigationElement"));
    }
}

