/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.profiles.SpringProfile;
import com.intellij.spring.profiles.SpringProfilesFactory;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringProfilePsiReference
extends PsiReferenceBase<PsiElement> {
    private final String myProfileName;
    private final Module myModule;
    private final boolean myIsDefinition;

    public SpringProfilePsiReference(@NotNull PsiElement element, @NotNull TextRange range, @NotNull Module module, boolean definition) {
        if (element == null) {
            SpringProfilePsiReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SpringProfilePsiReference.$$$reportNull$$$0(1);
        }
        if (module == null) {
            SpringProfilePsiReference.$$$reportNull$$$0(2);
        }
        super(element, range);
        this.myIsDefinition = definition;
        this.myProfileName = range.substring(element.getText());
        this.myModule = module;
    }

    public PsiElement resolve() {
        if (StringUtil.isEmptyOrSpaces((String)this.myProfileName)) {
            return this.myElement;
        }
        SpringProfilesFactory profilesFactory = SpringProfilesFactory.getInstance(this.myModule);
        if (this.myIsDefinition) {
            return profilesFactory.getOrCreateProfile(this.myProfileName, this.getElement());
        }
        return profilesFactory.findProfile(this.myProfileName);
    }

    public boolean isSoft() {
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        Set<SpringProfile> profiles = SpringProfilesFactory.getInstance(this.myModule).getProfiles();
        SpringProfile[] springProfileArray = profiles.toArray(new SpringProfile[profiles.size()]);
        if (springProfileArray == null) {
            SpringProfilePsiReference.$$$reportNull$$$0(3);
        }
        return springProfileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/profiles/SpringProfilePsiReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/profiles/SpringProfilePsiReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

