/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils.filters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.filters.SpringContextFilter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextIncludeAnnotationFilter
extends SpringContextFilter.IncludeExpression {
    public SpringContextIncludeAnnotationFilter(@Nullable String expression) {
        super(expression);
    }

    @Override
    @NotNull
    public Set<SpringStereotypeElement> includeStereotypes(@NotNull Module module, @NotNull Set<PsiPackage> packages) {
        String annotation;
        if (module == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(annotation = this.getExpression()))) {
            GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            PsiClass annotationClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(annotation, searchScope);
            Set<SpringStereotypeElement> set = SpringContextIncludeAnnotationFilter.getAnnotatedStereotypes(annotationClass, searchScope, packages);
            if (set == null) {
                SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<SpringStereotypeElement> set = Collections.emptySet();
        if (set == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public static Set<SpringStereotypeElement> getAnnotatedStereotypes(@Nullable PsiClass annotationClass, @NotNull GlobalSearchScope searchScope, @NotNull Set<PsiPackage> packages) {
        if (searchScope == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(4);
        }
        if (packages == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(5);
        }
        if (annotationClass == null || !annotationClass.isAnnotationType()) {
            Set<SpringStereotypeElement> set = Collections.emptySet();
            if (set == null) {
                SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(6);
            }
            return set;
        }
        LinkedHashSet components = ContainerUtil.newLinkedHashSet();
        Set<PsiClass> annotatedClasses = SpringContextIncludeAnnotationFilter.getAnnotatedClasses(annotationClass, packages, searchScope);
        for (PsiClass annotatedClass : annotatedClasses) {
            components.add(new CustomSpringComponent(annotationClass.getQualifiedName(), annotatedClass));
        }
        LinkedHashSet linkedHashSet = components;
        if (linkedHashSet == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    private static Set<PsiClass> getAnnotatedClasses(@NotNull PsiClass annotationClass, @NotNull Set<PsiPackage> packages, @NotNull GlobalSearchScope searchScope) {
        if (annotationClass == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(8);
        }
        if (packages == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            SpringContextIncludeAnnotationFilter.$$$reportNull$$$0(10);
        }
        LinkedHashSet annotatedClasses = ContainerUtil.newLinkedHashSet();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor((Collection)annotatedClasses);
        for (PsiPackage psiPackage : packages) {
            GlobalSearchScope scope = searchScope.intersectWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
            AnnotatedElementsSearch.searchPsiClasses((PsiClass)annotationClass, (SearchScope)scope).forEach((Processor)processor);
        }
        return annotatedClasses;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/utils/filters/SpringContextIncludeAnnotationFilter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "includeStereotypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedStereotypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "includeStereotypes";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedStereotypes";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

