/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.qualifiers;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.model.QualifierAttribute;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.NameValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="@Qualifier")
public class SpringJamQualifier
extends CommonModelElement.PsiBase
implements JamElement,
SpringQualifier {
    private final PsiAnnotation myAnno;
    protected final PsiModifierListOwner myModifierListOwner;
    private final Project myProject;

    public SpringJamQualifier(@NotNull PsiAnnotation anno, @Nullable PsiModifierListOwner modifierListOwner) {
        if (anno == null) {
            SpringJamQualifier.$$$reportNull$$$0(0);
        }
        this.myAnno = anno;
        this.myModifierListOwner = modifierListOwner;
        this.myProject = anno.getProject();
    }

    public PsiAnnotation getAnnotation() {
        return this.myAnno;
    }

    @NameValue
    @Nullable
    public String getQualifiedName() {
        return (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)this.myAnno.findAttributeValue(null), String.class);
    }

    @NotNull
    public PsiModifierListOwner getPsiElement() {
        Object object = this.myModifierListOwner == null ? this.getType() : this.myModifierListOwner;
        if (object == null) {
            SpringJamQualifier.$$$reportNull$$$0(1);
        }
        return object;
    }

    @Nullable
    private PsiClass getType() {
        String annoQualifiedName = this.myAnno.getQualifiedName();
        return annoQualifiedName == null ? null : JavaPsiFacade.getInstance((Project)this.myProject).findClass(annoQualifiedName, this.myAnno.getResolveScope());
    }

    @Override
    public PsiClass getQualifierType() {
        return this.getType();
    }

    @Override
    public String getQualifierValue() {
        return this.getQualifiedName();
    }

    @Override
    @NotNull
    public List<? extends QualifierAttribute> getQualifierAttributes() {
        PsiNameValuePair[] attributes = this.myAnno.getParameterList().getAttributes();
        SmartList list = new SmartList();
        for (final PsiNameValuePair pair : attributes) {
            final String name = pair.getName();
            if (name == null || name.equals("value")) continue;
            list.add(new QualifierAttribute(){

                @Override
                public String getAttributeKey() {
                    return name;
                }

                @Override
                public Object getAttributeValue() {
                    return JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)pair.getValue(), Object.class);
                }
            });
        }
        SmartList smartList = list;
        if (smartList == null) {
            SpringJamQualifier.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @NotNull
    public static Collection<SpringQualifier> findSpringJamQualifiers(@NotNull Module module, @NotNull PsiModifierListOwner element) {
        if (module == null) {
            SpringJamQualifier.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SpringJamQualifier.$$$reportNull$$$0(4);
        }
        HashSet jamQualifiers = ContainerUtil.newHashSet();
        JamAnnotationTypeUtil jamAnnotationTypeUtil = JamAnnotationTypeUtil.getInstance(module);
        List<PsiClass> annotationTypeClasses = jamAnnotationTypeUtil.getQualifierAnnotationTypesWithChildren();
        for (PsiClass annotationTypeClass : annotationTypeClasses) {
            PsiAnnotation annotation;
            String qname;
            if (!SpringJamQualifier.isElementTypeAccepted(annotationTypeClass, element) || (qname = annotationTypeClass.getQualifiedName()) == null || qname.equals("javax.inject.Named") || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (boolean)true, (String[])new String[]{qname})) == null) continue;
            jamQualifiers.add(new SpringJamQualifier(annotation, element));
        }
        PsiAnnotation namedAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (boolean)true, (String[])new String[]{"javax.inject.Named"});
        if (namedAnnotation != null) {
            jamQualifiers.add(new SpringJamQualifier(namedAnnotation, element));
        }
        HashSet hashSet = jamQualifiers;
        if (hashSet == null) {
            SpringJamQualifier.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static boolean isElementTypeAccepted(@NotNull PsiClass annotationTypeClass, @NotNull PsiModifierListOwner element) {
        if (annotationTypeClass == null) {
            SpringJamQualifier.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SpringJamQualifier.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiClass) {
            return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE}) != null;
        }
        if (element instanceof PsiMethod) {
            return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD}) != null;
        }
        if (element instanceof PsiField) {
            return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD}) != null;
        }
        if (element instanceof PsiParameter) {
            return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER}) != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationTypeClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findSpringJamQualifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSpringJamQualifiers";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isElementTypeAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

