/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.custom.CustomModuleComponentsDiscoverer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringImplicitBeansProviderBase
extends CustomModuleComponentsDiscoverer {
    protected abstract Collection<CommonSpringBean> getImplicitBeans(@NotNull Module var1);

    @Override
    @NotNull
    public final Collection<CommonSpringBean> getCustomComponents(@Nullable Module module) {
        if (module == null || module.isDisposed() || DumbService.isDumb((Project)module.getProject())) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                SpringImplicitBeansProviderBase.$$$reportNull$$$0(0);
            }
            return list;
        }
        Collection<CommonSpringBean> collection = this.getImplicitBeans(module);
        if (collection == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    protected PsiClass findClassInDependenciesAndLibraries(@NotNull Module module, @NotNull String className) {
        if (module == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(2);
        }
        if (className == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(3);
        }
        if (module.isDisposed()) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        return facade.findClass(className, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)this.includeTests()));
    }

    protected boolean includeTests() {
        return false;
    }

    protected void addImplicitBean(@NotNull Collection<CommonSpringBean> implicitBeans, @NotNull Module module, @NotNull String className, @NotNull String beanName) {
        if (implicitBeans == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(4);
        }
        if (module == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(5);
        }
        if (className == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(6);
        }
        if (beanName == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(7);
        }
        this.doAddImplicitBean(implicitBeans, module, className, beanName, false);
    }

    protected void addImplicitLibraryBean(@NotNull Collection<CommonSpringBean> implicitBeans, @NotNull Module module, @NotNull String className, @NotNull String beanName) {
        if (implicitBeans == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(8);
        }
        if (module == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(9);
        }
        if (className == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(10);
        }
        if (beanName == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(11);
        }
        this.doAddImplicitBean(implicitBeans, module, className, beanName, true);
    }

    private void doAddImplicitBean(@NotNull Collection<CommonSpringBean> implicitBeans, @NotNull Module module, @NotNull String className, @NotNull String beanName, boolean isLibraryClass) {
        PsiClass psiClass;
        if (implicitBeans == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(12);
        }
        if (module == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(13);
        }
        if (className == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(14);
        }
        if (beanName == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(15);
        }
        PsiClass psiClass2 = psiClass = isLibraryClass ? SpringCommonUtils.findLibraryClass(module, className) : this.findClassInDependenciesAndLibraries(module, className);
        if (psiClass != null) {
            implicitBeans.add(new SpringImplicitBean(this.getProviderName(), psiClass, beanName));
        }
    }

    @Override
    public Object[] getDependencies(@NotNull Module module) {
        if (module == null) {
            SpringImplicitBeansProviderBase.$$$reportNull$$$0(16);
        }
        return SpringModificationTrackersManager.getInstance(module.getProject()).getOuterModelsDependencies();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/SpringImplicitBeansProviderBase";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitBeans";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponents";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/SpringImplicitBeansProviderBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClassInDependenciesAndLibraries";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitBean";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitLibraryBean";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doAddImplicitBean";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

