/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.structure;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.constants.SeamDataKeys;
import com.intellij.seam.facet.SeamFacet;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.structure.SeamComponentNodeDescriptor;
import com.intellij.seam.structure.SeamDomModelNodeDescriptor;
import com.intellij.seam.structure.SeamModuleLibrariesNodeDescriptor;
import com.intellij.seam.utils.SeamConfigFileUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class SeamFacetNodeDescriptor
extends JavaeeNodeDescriptor<SeamFacet> {
    public SeamFacetNodeDescriptor(Project project, SeamFacet facet, NodeDescriptor parentDescriptor, Object parameters) {
        super(project, parentDescriptor, parameters, (Object)facet);
    }

    protected String getNewNodeText() {
        return ((SeamFacet)((Object)this.getElement())).getModule().getName();
    }

    public JavaeeNodeDescriptor[] getChildren() {
        ArrayList<JavaeeNodeDescriptor> nodes = new ArrayList<JavaeeNodeDescriptor>();
        ArrayList<SeamJamComponent> compiledElements = new ArrayList<SeamJamComponent>();
        ArrayList<XmlFile> libElements = new ArrayList<XmlFile>();
        this.addJamNodes(nodes, compiledElements);
        this.addDomNodes(nodes, libElements);
        if (!compiledElements.isEmpty() || !libElements.isEmpty()) {
            nodes.add(new SeamModuleLibrariesNodeDescriptor(compiledElements, libElements, this.getProject(), (NodeDescriptor)this, this.getParameters(), ((SeamFacet)((Object)this.getElement())).getModule()));
        }
        return nodes.toArray(new JavaeeNodeDescriptor[nodes.size()]);
    }

    private void addDomNodes(List<JavaeeNodeDescriptor> nodes, List<XmlFile> libFiles) {
        SeamDomModelManager modelManager = SeamDomModelManager.getInstance(this.getProject());
        Set<XmlFile> files = SeamConfigFileUtils.getConfigurationFiles(((SeamFacet)((Object)this.getElement())).getModule());
        for (XmlFile file : files) {
            if (!modelManager.isSeamComponents(file)) continue;
            if (SeamFacetNodeDescriptor.isLibrary(file)) {
                libFiles.add(file);
                continue;
            }
            nodes.add(new SeamDomModelNodeDescriptor(this.getProject(), (NodeDescriptor)this, this.getParameters(), file, this.getProject().getBaseDir()));
        }
    }

    private static boolean isLibrary(XmlFile xmlFile) {
        VirtualFile file = xmlFile.getVirtualFile();
        assert (file != null);
        return file.getFileSystem() instanceof JarFileSystem;
    }

    private void addJamNodes(List<JavaeeNodeDescriptor> nodes, List<SeamJamComponent> compiledElements) {
        Module module = ((SeamFacet)((Object)this.getElement())).getModule();
        this.addJamNodes(nodes, compiledElements, module, true);
        for (Module moduleDependency : JamCommonUtil.getAllModuleDependencies((Module)module)) {
            this.addJamNodes(nodes, compiledElements, moduleDependency, false);
        }
    }

    private void addJamNodes(List<JavaeeNodeDescriptor> nodes, List<SeamJamComponent> compiledElements, Module module, boolean fromLibs) {
        for (SeamJamComponent component : SeamJamModel.getModel(module).getSeamComponents(false, fromLibs)) {
            if (component.getPsiElement() instanceof PsiCompiledElement) {
                compiledElements.add(component);
                continue;
            }
            nodes.add((JavaeeNodeDescriptor)new SeamComponentNodeDescriptor(component, this, this.getParameters()));
        }
    }

    protected Icon getNewIcon() {
        return ModuleType.get((Module)((SeamFacet)((Object)this.getElement())).getModule()).getIcon();
    }

    public Object getData(String dataId) {
        if (SeamDataKeys.SEAM_FACET.is(dataId)) {
            return this.getElement();
        }
        return super.getData(dataId);
    }
}

