/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.xml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.impl.model.xml.SeamDomModelImpl;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.components.SeamComponents;
import com.intellij.seam.utils.SeamConfigFileUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.model.impl.DomModelFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeamDomModelFactory
extends DomModelFactory<SeamComponents, SeamDomModel, PsiElement> {
    public SeamDomModelFactory(Project project) {
        super(SeamComponents.class, project, "Seam");
    }

    @NotNull
    public Object[] computeDependencies(@Nullable SeamDomModel model, @Nullable Module module) {
        ArrayList<Object> dependencies = new ArrayList<Object>();
        dependencies.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        if (module != null) {
            dependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            SeamDomModelFactory.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    protected List<SeamDomModel> computeAllModels(@NotNull Module module) {
        if (module == null) {
            SeamDomModelFactory.$$$reportNull$$$0(1);
        }
        ArrayList<SeamDomModel> models = new ArrayList<SeamDomModel>();
        for (XmlFile xmlFile : SeamConfigFileUtils.getConfigurationFiles(module)) {
            SeamDomModel seamModel = this.createSingleModel(xmlFile, module);
            if (seamModel == null) continue;
            models.add(seamModel);
        }
        return models;
    }

    protected SeamDomModel computeModel(@NotNull XmlFile psiFile, @Nullable Module module) {
        if (psiFile == null) {
            SeamDomModelFactory.$$$reportNull$$$0(2);
        }
        if (module == null) {
            return null;
        }
        SeamDomModel model = (SeamDomModel)super.computeModel(psiFile, (UserDataHolder)module);
        return model != null ? model : this.createSingleModel(psiFile, module);
    }

    @Nullable
    private SeamDomModel createSingleModel(XmlFile psiFile, Module module) {
        DomFileElement componentsDomFileElement = this.getDomRoot(psiFile);
        if (componentsDomFileElement != null) {
            HashSet<XmlFile> files = new HashSet<XmlFile>();
            files.add(psiFile);
            SeamDomModelFactory.addImports(files, (SeamComponents)componentsDomFileElement.getRootElement());
            DomFileElement fileElement = files.size() > 1 ? this.createMergedModelRoot(files) : componentsDomFileElement;
            return fileElement == null ? null : new SeamDomModelImpl(module, (DomFileElement<SeamComponents>)fileElement, files);
        }
        return null;
    }

    protected SeamDomModel createCombinedModel(@NotNull Set<XmlFile> configFiles, @NotNull DomFileElement<SeamComponents> mergedModel, SeamDomModel firstModel, Module module) {
        if (configFiles == null) {
            SeamDomModelFactory.$$$reportNull$$$0(3);
        }
        if (mergedModel == null) {
            SeamDomModelFactory.$$$reportNull$$$0(4);
        }
        return new SeamDomModelImpl(module, mergedModel, configFiles);
    }

    private static void addImports(Set<XmlFile> files, SeamComponents components) {
        for (GenericDomValue genericDomValue : components.getImports()) {
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/model/xml/SeamDomModelFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDependencies";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/model/xml/SeamDomModelFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeAllModels";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCombinedModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

