/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.seam.utils.beans.ContextVariable;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;

public class SeamAnnoReferenceConverter
implements CustomReferenceConverter<String> {
    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<String> genericDomValue, PsiElement element, final ConvertContext context) {
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element){

            public PsiElement resolve() {
                String name = genericDomValue.getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return null;
                }
                Module module = context.getModule();
                for (ContextVariable contextVariable : SeamCommonUtils.getSeamContextVariablesWithDependencies(module, true, false)) {
                    if (!name.equals(contextVariable.getName())) continue;
                    return contextVariable.getModelElement().getIdentifyingPsiElement();
                }
                return this.getElement().getParent().getParent();
            }

            public boolean isSoft() {
                return true;
            }

            @NotNull
            public Object[] getVariants() {
                if (EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/converters/SeamAnnoReferenceConverter$1", "getVariants"));
            }
        }};
        if (psiReferenceArray == null) {
            SeamAnnoReferenceConverter.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/model/converters/SeamAnnoReferenceConverter", "createReferences"));
    }
}

