/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.seam.highlighting.jam.SeamJamModelInspectionBase;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.SeamJamInstall;
import com.intellij.seam.model.jam.SeamJamModel;
import com.intellij.seam.model.jam.SeamJamRole;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.util.containers.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamDuplicateComponentsInspection
extends SeamJamModelInspectionBase {
    @Override
    protected void checkSeamJamComponent(SeamJamComponent seamComponent, ProblemsHolder holder) {
        Module module = seamComponent.getModule();
        if (module == null) {
            return;
        }
        if (SeamDuplicateComponentsInspection.isNotInstall(seamComponent)) {
            return;
        }
        String componentName = seamComponent.getComponentName();
        PsiType type = seamComponent.getComponentType();
        PsiAnnotation identifyingPsiElement = seamComponent.getIdentifyingAnnotation();
        Set<SeamJamComponent> seamComponents = SeamJamModel.getModel(module).getSeamComponents(false, false);
        List<SeamDomModel> models = SeamDomModelManager.getInstance(module.getProject()).getAllModels(module);
        SeamDuplicateComponentsInspection.checkDuplicateNames(holder, seamComponent, componentName, type, (PsiElement)identifyingPsiElement, seamComponents, models);
        for (SeamJamRole role : seamComponent.getRoles()) {
            String roleName = role.getName();
            identifyingPsiElement = role.getIdentifyingAnnotation();
            SeamDuplicateComponentsInspection.checkDuplicateNames(holder, seamComponent, roleName, type, (PsiElement)identifyingPsiElement, seamComponents, models);
        }
    }

    private static void checkDuplicateNames(ProblemsHolder holder, SeamJamComponent seamComponent, String componentName, PsiType type, PsiElement identifyingPsiElement, Set<SeamJamComponent> seamComponents, List<SeamDomModel> models) {
        if (StringUtil.isEmptyOrSpaces((String)componentName) || identifyingPsiElement == null || type == null) {
            return;
        }
        HashSet duplicatedInFiles = new HashSet();
        for (SeamJamComponent checkedComponent : seamComponents) {
            PsiFile containingFile;
            if (seamComponent.equals(checkedComponent) || SeamDuplicateComponentsInspection.isNotInstall(checkedComponent) || !SeamDuplicateComponentsInspection.isNameDuplicated(componentName, checkedComponent) || !SeamCommonUtils.comparelInstalls(seamComponent, checkedComponent) || (containingFile = checkedComponent.getContainingFile()) == null) continue;
            duplicatedInFiles.add(containingFile.getName());
        }
        block1: for (SeamDomModel model : models) {
            for (SeamDomComponent seamDomComponent : model.getSeamComponents()) {
                PsiFile containingFile;
                XmlElement xmlElement;
                PsiType psiType = seamDomComponent.getComponentType();
                if (!componentName.equals(seamDomComponent.getComponentName()) || psiType == null || type.isAssignableFrom(psiType) || !SeamCommonUtils.comparelInstalls(seamComponent, seamDomComponent) || (xmlElement = seamDomComponent.getXmlElement()) == null || (containingFile = xmlElement.getContainingFile()) == null) continue;
                duplicatedInFiles.add(containingFile.getName());
                continue block1;
            }
        }
        if (duplicatedInFiles.size() > 0) {
            holder.registerProblem(identifyingPsiElement, SeamInspectionBundle.message("jam.duplicated.component.annotation", duplicatedInFiles, duplicatedInFiles.size() > 1 ? "s:" : ""), new LocalQuickFix[0]);
        }
    }

    private static boolean isNameDuplicated(String componentName, SeamJamComponent checkedComponent) {
        boolean isDuplicated = componentName.equals(checkedComponent.getComponentName());
        return isDuplicated ? isDuplicated : SeamDuplicateComponentsInspection.isRoleNamesDuplicated(componentName, checkedComponent.getRoles());
    }

    private static boolean isRoleNamesDuplicated(String componentName, List<SeamJamRole> roles) {
        for (SeamJamRole role : roles) {
            if (!componentName.equals(role.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotInstall(SeamJamComponent checkedComponent) {
        SeamJamInstall seamJamInstall = checkedComponent.getInstall();
        return seamJamInstall != null && !seamJamInstall.isInstall();
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("duplicated.jam.component.inspection.name", new Object[0]);
        if (string == null) {
            SeamDuplicateComponentsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamDuplicateComponentsInspection" == null) {
            SeamDuplicateComponentsInspection.$$$reportNull$$$0(1);
        }
        return "SeamDuplicateComponentsInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            SeamDuplicateComponentsInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/highlighting/jam/SeamDuplicateComponentsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

