/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.view.tool;

import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.view.ArtifactUtils;
import com.intellij.javaee.view.tool.AppServerNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.DefaultPackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.remoteServer.impl.runtime.ui.tree.TreeBuilderBase;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ServersDropTargetAdapter
extends DropTargetAdapter {
    private final Tree myTree;
    private final TreeBuilderBase myBuilder;
    private final Project myProject;

    public ServersDropTargetAdapter(Tree tree, TreeBuilderBase builder, Project project) {
        this.myTree = tree;
        this.myBuilder = builder;
        this.myProject = project;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.doDragOver(dtde);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.doDragOver(dtde);
    }

    private void doDragOver(final DropTargetDragEvent dtde) {
        if (this.findArtifactsToDrop(new DropTargetEventWrapper(){

            @Override
            public Transferable getTransferable() {
                return dtde.getTransferable();
            }

            @Override
            public DropTargetContext getDropTargetContext() {
                return dtde.getDropTargetContext();
            }

            @Override
            public Point getLocation() {
                return dtde.getLocation();
            }
        }, null) != null) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void drop(final DropTargetDropEvent dtde) {
        Ref deploymentSettingsRef = new Ref();
        Collection<Artifact> artifactsToDrop = this.findArtifactsToDrop(new DropTargetEventWrapper(){

            @Override
            public Transferable getTransferable() {
                return dtde.getTransferable();
            }

            @Override
            public DropTargetContext getDropTargetContext() {
                return dtde.getDropTargetContext();
            }

            @Override
            public Point getLocation() {
                return dtde.getLocation();
            }
        }, (Ref<DeploymentSettings>)deploymentSettingsRef);
        if (artifactsToDrop == null) {
            return;
        }
        for (Artifact artifact : artifactsToDrop) {
            ((DeploymentSettings)deploymentSettingsRef.get()).getOrCreateModel(artifact);
        }
        this.myBuilder.queueUpdate();
    }

    private Collection<Artifact> findArtifactsToDrop(DropTargetEventWrapper dtde, Ref<DeploymentSettings> deploymentSettingsRef) {
        Transferable transferable = dtde.getTransferable();
        TreeNode[] treeNodes = AbstractProjectViewPane.getTransferedTreeNodes((Transferable)transferable);
        if (treeNodes == null) {
            return null;
        }
        final HashSet<Module> draggedModules = new HashSet<Module>();
        for (TreeNode treeNode : treeNodes) {
            Object treeNodeObject;
            if (!(treeNode instanceof DefaultMutableTreeNode) || !((treeNodeObject = AbstractProjectViewPane.extractUserObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)treeNode))) instanceof Module)) continue;
            draggedModules.add((Module)treeNodeObject);
        }
        if (draggedModules.isEmpty()) {
            return null;
        }
        Component targetComponent = dtde.getDropTargetContext().getComponent();
        Point targetPoint = dtde.getLocation();
        Point treeTargetPoint = new RelativePoint(targetComponent, targetPoint).getPoint((Component)this.myTree);
        TreePath targetPath = this.myTree.getPathForLocation(treeTargetPoint.x, treeTargetPoint.y);
        if (targetPath == null) {
            return null;
        }
        Object targetNode = targetPath.getLastPathComponent();
        Object targetElement = this.myBuilder.getUi().getElementFor(targetNode);
        if (!(targetElement instanceof AppServerNode)) {
            return null;
        }
        AppServerNode targetServer = (AppServerNode)((Object)targetElement);
        DeploymentSettings deploymentSettings = targetServer.getCommonStrategy().getDeploymentSettings();
        if (deploymentSettings == null) {
            return null;
        }
        if (deploymentSettingsRef != null) {
            deploymentSettingsRef.set((Object)deploymentSettings);
        }
        LinkedHashSet<Artifact> allSupportedArtifacts = ArtifactUtils.getServerSupportedArtifacts(this.myProject, targetServer.getCommonStrategy());
        final HashSet<Artifact> artifactsToDrop = new HashSet<Artifact>();
        final DefaultPackagingElementResolvingContext context = new DefaultPackagingElementResolvingContext(this.myProject);
        for (final Artifact artifact : allSupportedArtifacts) {
            ArtifactUtil.processPackagingElements((PackagingElement)artifact.getRootElement(), (PackagingElementType)ProductionModuleOutputElementType.ELEMENT_TYPE, (PackagingElementProcessor)new PackagingElementProcessor<ProductionModuleOutputPackagingElement>(){

                public boolean process(@NotNull ProductionModuleOutputPackagingElement element, @NotNull PackagingElementPath path) {
                    Module artifactModule;
                    if (element == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (path == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (draggedModules.contains(artifactModule = element.findModule((PackagingElementResolvingContext)context))) {
                        artifactsToDrop.add(artifact);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "path";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javaee/view/tool/ServersDropTargetAdapter$3";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (PackagingElementResolvingContext)context, (boolean)false, (ArtifactType)artifact.getArtifactType());
        }
        return artifactsToDrop.isEmpty() ? null : artifactsToDrop;
    }

    private static interface DropTargetEventWrapper {
        public Transferable getTransferable();

        public DropTargetContext getDropTargetContext();

        public Point getLocation();
    }
}

