/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.service;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceAnnotatorCheckerProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompletionsRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServerServiceSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.service.protocol.Angular2LanguageServiceProtocol;
import org.angularjs.service.protocol.command.Angular2CompletionsCommand;
import org.angularjs.service.protocol.command.Angular2GetHtmlErrCommand;
import org.angularjs.service.protocol.command.Angular2GetProjectHtmlErrCommand;
import org.angularjs.settings.AngularSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2LanguageService
extends TypeScriptServerServiceImpl {
    private static final ParameterizedCachedValueProvider<VirtualFile, Project> CACHE_SERVICE_PATH_PROVIDER = new ParameterizedCachedValueProvider<VirtualFile, Project>(){

        @Nullable
        public CachedValueProvider.Result<VirtualFile> compute(Project project) {
            VirtualFile result = Angular2LanguageService.findServiceDirectoryImpl(project);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        }
    };
    public static final Key<ParameterizedCachedValue<VirtualFile, Project>> NG_SERVICE_PATH_KEY = Key.create((String)"CACHED_NG_SERVICE_PATH");
    private final Condition<VirtualFile> myFileFilter;

    public Angular2LanguageService(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            Angular2LanguageService.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            Angular2LanguageService.$$$reportNull$$$0(1);
        }
        super(project, settings, "Angular Console");
        this.myFileFilter = Conditions.or((Condition)super.getAcceptableFilesFilter(), el -> {
            if (el != null && el.isInLocalFileSystem() && el.getFileType() == HtmlFileType.INSTANCE) {
                VirtualFile config = TypeScriptConfigUtil.getNearestParentConfig((VirtualFile)el);
                return config != null;
            }
            return false;
        });
    }

    @Nullable
    protected JSLanguageServiceProtocol createProtocol(Consumer<?> readyConsumer) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile directory = Angular2LanguageService.getServiceDirectory(this.myProject);
        if (directory == null) {
            return null;
        }
        String path = directory.getCanonicalPath();
        if (path == null) {
            return null;
        }
        return new Angular2LanguageServiceProtocol(this.myProject, path, this.mySettings, readyConsumer, (Consumer<JSLanguageServiceAnswer>)this.createEventConsumer());
    }

    public static VirtualFile getServiceDirectory(Project project) {
        return (VirtualFile)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)project, NG_SERVICE_PATH_KEY, CACHE_SERVICE_PATH_PROVIDER, false, (Object)project);
    }

    @Nullable
    private static VirtualFile findServiceDirectoryImpl(Project project) {
        for (VirtualFile file : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            VirtualFile serviceDirectory;
            VirtualFile angularPackage;
            VirtualFile modules;
            if (!file.isInLocalFileSystem() || !file.isDirectory() || (modules = file.findChild("node_modules")) == null || (angularPackage = modules.findChild("@angular")) == null || (serviceDirectory = angularPackage.findChild("language-service")) == null) continue;
            return serviceDirectory;
        }
        return null;
    }

    @NotNull
    protected Collection<JSLanguageServiceCacheableCommand> createGetErrCommand(@NotNull VirtualFile file, @NotNull String path) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(2);
        }
        if (path == null) {
            Angular2LanguageService.$$$reportNull$$$0(3);
        }
        if (file.getFileType() == HtmlFileType.INSTANCE) {
            String configFile = this.getConfigForFile(file);
            if (configFile == null) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    Angular2LanguageService.$$$reportNull$$$0(4);
                }
                return list;
            }
            Angular2GetHtmlErrCommand error = new Angular2GetHtmlErrCommand(path);
            ((TypeScriptFileWithConfigArgs)error.arguments).projectFileName = configFile;
            List<JSLanguageServiceCacheableCommand> list = Collections.singletonList(error);
            if (list == null) {
                Angular2LanguageService.$$$reportNull$$$0(5);
            }
            return list;
        }
        Collection collection = super.createGetErrCommand(file, path);
        if (collection == null) {
            Angular2LanguageService.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public boolean canHighlight(@NotNull PsiFile file) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(7);
        }
        if (file instanceof HtmlFileImpl) {
            return TypeScriptLanguageServiceAnnotatorCheckerProvider.checkServiceIsAvailable((Project)this.myProject, (JSLanguageServiceBase)this, (TypeScriptCompilerSettings)this.mySettings);
        }
        return super.canHighlight(file);
    }

    @NotNull
    protected String getProcessName() {
        if ("Angular" == null) {
            Angular2LanguageService.$$$reportNull$$$0(8);
        }
        return "Angular";
    }

    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter() {
        Condition<VirtualFile> condition = this.myFileFilter;
        if (condition == null) {
            Angular2LanguageService.$$$reportNull$$$0(9);
        }
        return condition;
    }

    @NotNull
    protected JSLanguageServiceSimpleCommand createCompletionCommand(@NotNull TypeScriptCompletionsRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull PsiFile file) {
        if (args == null) {
            Angular2LanguageService.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            Angular2LanguageService.$$$reportNull$$$0(11);
        }
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(12);
        }
        Angular2CompletionsCommand angular2CompletionsCommand = file instanceof XmlFile || virtualFile.getFileType() instanceof XmlLikeFileType ? new Angular2CompletionsCommand(args) : super.createCompletionCommand(args, virtualFile, file);
        if (angular2CompletionsCommand == null) {
            Angular2LanguageService.$$$reportNull$$$0(13);
        }
        return angular2CompletionsCommand;
    }

    @NotNull
    protected JSLanguageServiceCommand createProjectCommand(@NotNull VirtualFile file, @NotNull String path) {
        FileType type;
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(14);
        }
        if (path == null) {
            Angular2LanguageService.$$$reportNull$$$0(15);
        }
        Angular2GetProjectHtmlErrCommand angular2GetProjectHtmlErrCommand = (type = file.getFileType()) instanceof XmlLikeFileType ? new Angular2GetProjectHtmlErrCommand(path) : super.createProjectCommand(file, path);
        if (angular2GetProjectHtmlErrCommand == null) {
            Angular2LanguageService.$$$reportNull$$$0(16);
        }
        return angular2GetProjectHtmlErrCommand;
    }

    @Nullable
    protected JSLanguageServiceQueue createLanguageServiceQueue() {
        TypeScriptCompilerService defaultService = TypeScriptCompilerService.getDefaultService((Project)this.myProject);
        if (defaultService.isServiceCreated()) {
            JSLanguageServiceQueue.LOGGER.info("Dispose default service by " + this.getProcessName());
            TransactionGuard.submitTransaction((Disposable)this, () -> defaultService.terminateStartedProcess(false));
        }
        return super.createLanguageServiceQueue();
    }

    @Nullable
    protected String getConfigForFile(@NotNull VirtualFile file) {
        if (file == null) {
            Angular2LanguageService.$$$reportNull$$$0(17);
        }
        if (file.getFileType() instanceof XmlLikeFileType) {
            return (String)ReadAction.compute(() -> {
                VirtualFile config;
                if (file == null) {
                    Angular2LanguageService.$$$reportNull$$$0(18);
                }
                return (config = TypeScriptConfigUtil.getNearestParentConfig((VirtualFile)file)) == null ? null : TypeScriptCompilerConfigUtil.normalizeNameAndPath((VirtualFile)config);
            });
        }
        return super.getConfigForFile(file);
    }

    public static boolean isEnabledAngularService(Project project) {
        return AngularSettings.get(project).isUseService() && AngularIndexUtil.hasAngularJS2(project) && Angular2LanguageService.getServiceDirectory(project) != null;
    }

    @Nullable
    public TypeScriptServerServiceSettings getServiceSettings() {
        return AngularSettings.get(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/service/Angular2LanguageService";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/service/Angular2LanguageService";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGetErrCommand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableFilesFilter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionCommand";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createGetErrCommand";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canHighlight";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionCommand";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createProjectCommand";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConfigForFile$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

