/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.json.JsonFileType;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.angularjs.cli.AngularJSFramework;
import org.angularjs.cli.AngularJSProjectConfigurator;
import org.jetbrains.annotations.NotNull;

public class AngularJSFrameworkDetector
extends FrameworkDetector {
    protected AngularJSFrameworkDetector() {
        super("AngularCLI");
    }

    @NotNull
    public FileType getFileType() {
        JsonFileType jsonFileType = JsonFileType.INSTANCE;
        if (jsonFileType == null) {
            AngularJSFrameworkDetector.$$$reportNull$$$0(0);
        }
        return jsonFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        ObjectPattern objectPattern = FileContentPattern.fileContent().withName(StandardPatterns.string().endsWith(".angular-cli.json")).with((PatternCondition)new PatternCondition<FileContent>("notLibrary"){

            public boolean accepts(@NotNull FileContent content, ProcessingContext context) {
                if (content == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !JSLibraryUtil.isProbableLibraryFile((VirtualFile)content.getFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/angularjs/cli/AngularJSFrameworkDetector$1", "accepts"));
            }
        });
        if (objectPattern == null) {
            AngularJSFrameworkDetector.$$$reportNull$$$0(1);
        }
        return objectPattern;
    }

    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        if (newFiles == null) {
            AngularJSFrameworkDetector.$$$reportNull$$$0(2);
        }
        if (context == null) {
            AngularJSFrameworkDetector.$$$reportNull$$$0(3);
        }
        if (newFiles.size() > 0 && !AngularJSFrameworkDetector.isConfigured(newFiles, context.getProject())) {
            return Collections.singletonList(new AngularCLIFrameworkDescription(newFiles));
        }
        return Collections.emptyList();
    }

    private static boolean isConfigured(Collection<VirtualFile> files, Project project) {
        if (project == null) {
            return false;
        }
        for (VirtualFile file : files) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (module == null) continue;
            for (String root : ModuleRootManager.getInstance((Module)module).getExcludeRootUrls()) {
                if (!root.equals(file.getParent().getUrl() + "/tmp")) continue;
                return true;
            }
        }
        return false;
    }

    public FrameworkType getFrameworkType() {
        return AngularJSFramework.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/cli/AngularJSFrameworkDetector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitableFilePattern";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/cli/AngularJSFrameworkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AngularCLIFrameworkDescription
    extends DetectedFrameworkDescription {
        private final Collection<VirtualFile> myNewFiles;

        public AngularCLIFrameworkDescription(Collection<VirtualFile> newFiles) {
            this.myNewFiles = newFiles;
        }

        @NotNull
        public Collection<? extends VirtualFile> getRelatedFiles() {
            Collection<VirtualFile> collection = this.myNewFiles;
            if (collection == null) {
                AngularCLIFrameworkDescription.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @NotNull
        public String getSetupText() {
            if ("AngularCLI" == null) {
                AngularCLIFrameworkDescription.$$$reportNull$$$0(1);
            }
            return "AngularCLI";
        }

        @NotNull
        public FrameworkDetector getDetector() {
            AngularJSFrameworkDetector angularJSFrameworkDetector = AngularJSFrameworkDetector.this;
            if (angularJSFrameworkDetector == null) {
                AngularCLIFrameworkDescription.$$$reportNull$$$0(2);
            }
            return angularJSFrameworkDetector;
        }

        public void setupFramework(@NotNull ModifiableModelsProvider modifiableModelsProvider, @NotNull ModulesProvider modulesProvider) {
            if (modifiableModelsProvider == null) {
                AngularCLIFrameworkDescription.$$$reportNull$$$0(3);
            }
            if (modulesProvider == null) {
                AngularCLIFrameworkDescription.$$$reportNull$$$0(4);
            }
            for (Module module : modulesProvider.getModules()) {
                ContentEntry entry;
                ModifiableRootModel model = modifiableModelsProvider.getModuleModifiableModel(module);
                VirtualFile item = (VirtualFile)ContainerUtil.getFirstItem(this.myNewFiles);
                ContentEntry contentEntry = entry = item != null ? MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)item) : null;
                if (entry == null) {
                    modifiableModelsProvider.disposeModuleModifiableModel(model);
                    continue;
                }
                AngularJSProjectConfigurator.excludeDefault(item.getParent(), entry);
                modifiableModelsProvider.commitModuleModifiableModel(model);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof AngularCLIFrameworkDescription && this.myNewFiles.equals(((AngularCLIFrameworkDescription)((Object)obj)).myNewFiles);
        }

        public int hashCode() {
            return this.myNewFiles.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/angularjs/cli/AngularJSFrameworkDetector$AngularCLIFrameworkDescription";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiableModelsProvider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modulesProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelatedFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSetupText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDetector";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/angularjs/cli/AngularJSFrameworkDetector$AngularCLIFrameworkDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setupFramework";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

